/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.customers.external;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.screens.customers.external.CustomerImporter;
import officemate.screens.customers.external.ImportMapCustomerPanel;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Customer;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ImportCustomerAction
extends BasicAction {
    public static final Signal doAfterActionHandled = Signals.createSignal();

    public ImportCustomerAction() {
        super("Import from CSV", (Icon)IconLoader.get((String)"/ordermate/images/users.png"), "Import a customer from an .csv file.");
    }

    public void actionPerformed(ActionEvent e) {
        CustomerImporter importer = new CustomerImporter();
        List<Object> csvStrings = new ArrayList();
        try {
            csvStrings = importer.importCustomers();
        }
        catch (IOException e1) {
            OrderMate.LOG.error("Cannot import customers string:", (Throwable)e1);
        }
        if (csvStrings != null && !csvStrings.isEmpty()) {
            try {
                this.mapCustomers(csvStrings);
            }
            catch (Exception e1) {
                OrderMate.LOG.error("Cannot map customers from csv data:", (Throwable)e1);
            }
            doAfterActionHandled.emit();
        }
    }

    private void mapCustomers(List<String[]> newCustomers) throws Exception {
        boolean loopAgain = false;
        ImportMapCustomerPanel panel = new ImportMapCustomerPanel(newCustomers);
        panel.setPreferredSize(new Dimension(400, 400));
        do {
            OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(panel);
            dialog.setTitle("Map Customer Fields");
            dialog.setHtmlHeader("Use the table below to map your import fields to the Customers' Property Fields required in OrderMate");
            loopAgain = false;
            if (!dialog.doShow()) continue;
            OkCancelDialogBuilder confirmSave = Dialogs.getOkCancelDialogBuilder(new JPanel());
            confirmSave.setTitle("Confirm");
            confirmSave.setHtmlHeader("It is recommended that you preview changes first as Customer additions will be final");
            if (confirmSave.doShow()) {
                final List<Customer> finalList = panel.getCustomerList();
                Dialogs.showProgressDialog(new AbstractTask(){

                    public String getName() {
                        return "Importing Customers...";
                    }

                    protected void performTask() throws Exception {
                        EventContext context = new EventContext(Terminal.getServerMateTerminal(), GuiApp.getAppComplex().getApplicationSecurity().getUser());
                        for (Customer customer : finalList) {
                            int points = customer.getLoyaltyPoints();
                            customer.save();
                            if (points != 0) {
                                LoyaltyPointAdministrator.getInstance().createAdjustingTransaction(customer, points, null, context);
                            }
                            this.emitProgress();
                        }
                    }

                    protected int getTotalSubTasks() {
                        return finalList.size();
                    }
                });
                continue;
            }
            loopAgain = true;
        } while (loopAgain);
    }
}

