/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.dailytasks.accounting;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.screens.dailytasks.accounting.RetryExportTasksModel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.integration.accounting.ConfigRetryExportTasks;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.users.User;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXHeader;

class AccountingExportScreen
extends JPanel
implements ActionListener {
    protected static final String INTERLINE = "10px";
    private JLabel fileLabel;
    private JTextField fileName;
    private JButton selectFileButton;
    private DateRangePanel datePanel;
    private JComboBox exportTypeCombobox;
    private JLabel accountGroupLabel;
    private JComboBox accountGroupCombobox;
    private JLabel customerLabel;
    private JComboBox customerCombobox;
    private JCheckBoxCellRenderer customerComboRenderer;
    private JTable retryTasksTable;
    private EventComboBoxModel<AccountingExportFunction> exportTypeComboModel;
    private EventComboBoxModel<DebtorGroup> debtorgroupComboModel;
    private EventList<AccountingExportFunction> exportTypeEventList = new BasicEventList();
    private EventList<DebtorGroup> debtorGroupEventList = new BasicEventList();
    private EventList<AbstractDebtor> debtorEventList = new BasicEventList();
    final Signal enableExportSignal = Signals.createSignal(Boolean.class, (String)"enabled");
    private DebtorGroup dummyAllDebtorGroup;
    private static final String NULL_HOLDER = "Any";
    private DebtorGroup lastDebtorGroupSelected;
    private RetryExportTasksModel retryExportTasksModel;

    public AccountingExportScreen() {
        super(new BorderLayout());
        this.createComponents();
        this.dummyAllDebtorGroup = new DebtorGroup(NULL_HOLDER, NULL_HOLDER);
    }

    private void checkExportStatus() {
        if (!(this.fileName.isEnabled() && this.fileName.getText().isEmpty() || this.datePanel.getStartDate() == null || !this.datePanel.getStartDate().before(this.datePanel.getEndDate()))) {
            this.enableExportSignal.emit((Object)Boolean.TRUE);
        } else {
            this.enableExportSignal.emit((Object)Boolean.FALSE);
        }
    }

    private void createComponents() {
        JXHeader instructionsHeading = new JXHeader("", "Use this screen to export your accounting data. Select the export type i.e. Sales And Takings, the required date range and any other required settings.", (Icon)IconLoader.get((String)"/officemate/images/xferFileToProfile.png"));
        Box box = new Box(1);
        box.add((Component)instructionsHeading);
        box.add(new JSeparator());
        this.add((Component)box, "North");
        FormLayout layout = new FormLayout("right:pref, 4px, left:pref, 10px,right:pref, 4px, left:pref, 10px,right:pref, 4px, left:pref,right:pref, 4px, left:pref, 10px,right:pref, 4px, left:pref, 10px");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        CellConstraints cc = new CellConstraints();
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        int row = 1;
        this.exportTypeComboModel = new EventComboBoxModel(this.exportTypeEventList);
        this.exportTypeCombobox = new JComboBox<AccountingExportFunction>((ComboBoxModel<AccountingExportFunction>)this.exportTypeComboModel);
        this.exportTypeCombobox.setName("exportTypeCombobox");
        this.exportTypeCombobox.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.exportTypeCombobox);
        builder.add((Component)new JLabel("Export"), cc.xy(1, row));
        builder.add((Component)this.exportTypeCombobox, cc.xyw(3, row, 4));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        builder.addSeparator("Options", cc.xyw(1, row += 2, 11));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        row += 2;
        this.fileLabel = new JLabel("File:");
        this.fileName = new JTextField(50);
        this.fileName.setName("fileName");
        this.fileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AccountingExportScreen.this.checkExportStatus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AccountingExportScreen.this.checkExportStatus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AccountingExportScreen.this.checkExportStatus();
            }
        });
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        this.datePanel = new DateRangePanel(false);
        this.datePanel.setUsesTradingDayBoundaries(false);
        this.datePanel.datesChanged.connect((Object)this, "gotDateChanged");
        builder.add((Component)new JLabel("From"), cc.xy(1, row));
        builder.add((Component)this.datePanel.getStartDateChooser(), cc.xy(3, row));
        builder.add((Component)new JLabel("To"), cc.xy(5, row));
        builder.add((Component)this.datePanel.getEndDateChooser(), cc.xy(7, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.selectFileButton = new JButton("...");
        this.selectFileButton.addActionListener(this);
        this.selectFileButton.setName("selectFileButton");
        builder.add((Component)this.fileLabel, cc.xy(1, row += 2));
        builder.add((Component)this.fileName, cc.xyw(3, row, 7));
        builder.add((Component)this.selectFileButton, cc.xy(11, row));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.accountGroupLabel = new JLabel("Account Group");
        builder.add((Component)this.accountGroupLabel, cc.xy(1, row += 2));
        this.debtorgroupComboModel = new EventComboBoxModel(this.debtorGroupEventList);
        this.accountGroupCombobox = new JComboBox<DebtorGroup>((ComboBoxModel<DebtorGroup>)this.debtorgroupComboModel);
        this.accountGroupCombobox.setName("exportAccountGroupCombobox");
        this.accountGroupCombobox.addActionListener(this);
        ComponentUtils.setupComboBox((JComboBox)this.accountGroupCombobox);
        builder.add((Component)this.accountGroupCombobox, cc.xyw(3, row, 4));
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.customerLabel = new JLabel("Customer");
        builder.add((Component)this.customerLabel, cc.xy(1, row += 2));
        this.customerCombobox = new JComboBox(new EventComboBoxModel(this.debtorEventList));
        this.customerCombobox.setName("customerCombobox");
        ComponentUtils.setupComboBox((JComboBox)this.customerCombobox);
        this.customerComboRenderer = JCheckBoxCellRenderer.install((JComboBox)this.customerCombobox, (String)NULL_HOLDER);
        builder.add((Component)this.customerCombobox, cc.xyw(3, row, 4));
        row += 2;
        JPanel wrapper = new JPanel();
        wrapper.add(builder.getPanel());
        this.add((Component)wrapper, "Center");
        this.updateFilePath();
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        this.retryExportTasksModel = new RetryExportTasksModel(ConfigRetryExportTasks.getFailedRetryExportTasksListWithinRetryDays());
        this.retryTasksTable = new JTable(this.retryExportTasksModel);
        JScrollPane scroller = new JScrollPane(this.retryTasksTable);
        layout.appendRow(new RowSpec("pref"));
        layout.appendRow(new RowSpec(INTERLINE));
        builder.add((Component)scroller, cc.xyw(1, row += 2, 12));
    }

    public void gotDateChanged(Date newStartDate, Date newEndDate) {
        this.checkExportStatus();
        this.updateFilePath();
    }

    public void refresh() {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.exportTypeEventList, this.getUserPermissionedAccountingExportFunctions());
        if (this.exportTypeEventList.isEmpty()) {
            this.setAllComponentsEnabled(false);
        } else {
            this.setAllComponentsEnabled(true);
        }
        if (!(this.exportTypeCombobox.getSelectedItem() != null && this.exportTypeEventList.contains(this.exportTypeCombobox.getSelectedItem()) || this.exportTypeEventList.isEmpty())) {
            this.exportTypeCombobox.setSelectedIndex(0);
        } else {
            this.exportTypeCombobox.setSelectedItem(this.exportTypeCombobox.getSelectedItem());
        }
        this.updateDebtorGroupList();
        this.updateCustomerDebtorList();
        this.checkExportStatus();
        this.updateFilePath();
        this.updateRetryTasksList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectFileButton) {
            JFileChooser chooser = new JFileChooser(this.fileName.getText());
            int returnValue = chooser.showOpenDialog(this);
            if (returnValue == 0) {
                this.fileName.setText(chooser.getSelectedFile().toString());
            }
        } else if (e.getSource() == this.accountGroupCombobox) {
            this.customerCombobox.setSelectedItem(NULL_HOLDER);
            this.customerComboRenderer.clearSelectedItems();
            this.updateCustomerDebtorList();
        } else if (e.getSource() == this.exportTypeCombobox) {
            AccountingExportFunction exportFunction;
            AccountingExportFunction accountingExportFunction = exportFunction = this.exportTypeCombobox.getSelectedItem() != null ? (AccountingExportFunction)this.exportTypeCombobox.getSelectedItem() : null;
            if (AccountingExportFunction.CUSTOMER_ACCOUNTS.equals((Object)exportFunction)) {
                this.setAllComponentsEnabled(true);
            } else if (AccountingExportFunction.ACCOUNT_SETUP.equals((Object)exportFunction) || AccountingExportFunction.CUSTOMERS.equals((Object)exportFunction)) {
                this.setAllDebtorComponentsEnabled(false);
                this.setDateComponentsEnabled(false);
                this.setAllFileComponentsEnabled(AccountingExportManager.getInstance().getAccountingIntegrationExporter().getReportFormat().isExportToFile());
            } else {
                this.setAllDebtorComponentsEnabled(false);
                this.setDateComponentsEnabled(true);
                this.setAllFileComponentsEnabled(AccountingExportManager.getInstance().getAccountingIntegrationExporter().getReportFormat().isExportToFile());
            }
            this.updateFilePath();
        }
    }

    public Date getStartDate() {
        return this.datePanel.getStartDate();
    }

    public Date getEndDate() {
        return this.datePanel.getEndDate();
    }

    public String getFileName() {
        return this.fileName.getText();
    }

    public DebtorGroup getSelectedAccountGroup() {
        if (this.dummyAllDebtorGroup.equals(this.accountGroupCombobox.getSelectedItem())) {
            return null;
        }
        return (DebtorGroup)this.accountGroupCombobox.getSelectedItem();
    }

    public AccountingExportFunction getAccountingExportFunction() {
        return (AccountingExportFunction)this.exportTypeComboModel.getSelectedItem();
    }

    private List<AccountingExportFunction> getUserPermissionedAccountingExportFunctions() {
        List supportedAccFunctions = AccountingExportManager.getInstance().getAccountingIntegrationExporter().getAccountingExportFunctions();
        ArrayList<AccountingExportFunction> permissionedAccFunctions = new ArrayList<AccountingExportFunction>();
        User user = GuiApp.getAppComplex().getApplicationSecurity().getUser();
        for (AccountingExportFunction accFunc : supportedAccFunctions) {
            if (user == null || accFunc.getPermission() != null && !user.hasPermission(accFunc.getPermission())) continue;
            permissionedAccFunctions.add(accFunc);
        }
        return permissionedAccFunctions;
    }

    private void setAllComponentsEnabled(boolean enabled) {
        this.exportTypeCombobox.setEnabled(enabled);
        this.datePanel.getStartDateChooser().setEnabled(enabled);
        this.datePanel.getEndDateChooser().setEnabled(enabled);
        this.setDateComponentsEnabled(enabled);
        this.setAllDebtorComponentsEnabled(enabled);
        this.setAllFileComponentsEnabled(AccountingExportManager.getInstance().getAccountingIntegrationExporter().getReportFormat().isExportToFile());
    }

    private void setAllFileComponentsEnabled(boolean enabled) {
        this.fileLabel.setEnabled(enabled);
        this.fileName.setEnabled(enabled);
        this.selectFileButton.setEnabled(enabled);
    }

    private void setAllDebtorComponentsEnabled(boolean enabled) {
        this.accountGroupLabel.setEnabled(enabled);
        this.accountGroupCombobox.setEnabled(enabled);
        this.customerLabel.setEnabled(enabled);
        this.customerCombobox.setEnabled(enabled);
    }

    private void setDateComponentsEnabled(boolean enabled) {
        this.datePanel.getStartDateChooser().setEnabled(enabled);
        this.datePanel.getEndDateChooser().setEnabled(enabled);
    }

    public void updateFilePath() {
        String tmpFileName = System.getProperty("user.dir") + "\\";
        if (this.exportTypeCombobox.getSelectedItem() != null) {
            tmpFileName = tmpFileName + this.exportTypeCombobox.getSelectedItem();
        }
        if (this.datePanel != null) {
            this.fileName.setText(tmpFileName + " " + new DateDMY(this.datePanel.getStartDate()).toStringHyphens() + " to " + new DateDMY(this.datePanel.getEndDate()).toStringHyphens() + AccountingExportManager.getInstance().getAccountingIntegrationExporter().getReportFormat().getExportFileExtension());
        } else {
            this.fileName.setText(tmpFileName + AccountingExportManager.getInstance().getAccountingIntegrationExporter().getReportFormat().getExportFileExtension());
        }
    }

    private void updateRetryTasksList() {
        this.retryExportTasksModel.update();
        this.retryTasksTable.repaint();
    }

    private void updateDebtorGroupList() {
        List allDebtors = DebtorGroup.getCustomerAccountGroups();
        allDebtors.add(0, this.dummyAllDebtorGroup);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.debtorGroupEventList, allDebtors);
        if (this.accountGroupCombobox.getSelectedItem() == null) {
            this.accountGroupCombobox.setSelectedItem(this.dummyAllDebtorGroup);
        }
    }

    private void updateCustomerDebtorList() {
        if (this.accountGroupCombobox.getSelectedItem() != null && !this.accountGroupCombobox.getSelectedItem().equals(this.dummyAllDebtorGroup)) {
            OfficeMateAdminGuiUtils.getInstance().refreshList(this.debtorEventList, ((DebtorGroup)this.accountGroupCombobox.getSelectedItem()).getDebtors());
        } else {
            OfficeMateAdminGuiUtils.getInstance().refreshList(this.debtorEventList, DebtorQueries.getAllCustomerAccountDebtors());
        }
    }

    void setupExportParameters(AccountingExportParams params) {
        if (this.exportTypeCombobox.getSelectedItem() != null && AccountingExportFunction.CUSTOMER_ACCOUNTS.equals(this.exportTypeCombobox.getSelectedItem()) && !NULL_HOLDER.equals(this.customerCombobox.getSelectedItem())) {
            ArrayList debtorsToExportList = new ArrayList();
            Collections.addAll(debtorsToExportList, this.customerCombobox.getSelectedObjects());
            debtorsToExportList.remove(NULL_HOLDER);
            params.setDebtorsToExport(debtorsToExportList);
        }
    }
}

