/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.xmlintegration.piggy.GuestSuggestion;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.actions.AbstractActions;
import officemate.components.search.objectsearch.DebtorSearchState;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.screens.debtor.debtors.DebtorEditPanel;
import officemate.screens.debtor.debtors.DebtorListPanel;
import officemate.screens.debtor.debtors.DiscountDebtorsPanel;
import officemate.screens.debtor.debtors.PayoffDebtorsPanel;
import officemate.screens.debtor.debtors.PrintStatementsAction;
import officemate.screens.debtor.debtors.SurchargeDebtorsPanel;
import officemate.screens.debtor.debtorsales.DebtorSalesState;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.piggy.PiggyConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.users.AllPermissions;
import ordermate.integration.piggy.PiggyResult;
import ordermate.integration.piggy.PiggyService;
import ordermate.integration.piggy.PiggyServiceBuilder;
import ordermate.integration.piggy.PiggyServiceProvider;
import ordermate.reports.printing.DebtorsSummaryReport;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.services.finance.transactions.FinanceTransactionFactory;
import org.jdesktop.swingx.JXTable;

public class DebtorsState
extends AbstractEditableTableState<AbstractDebtor> {
    private DebtorListPanel centralArea;
    private Action editAction;
    private Action deleteAction;
    private Action newAction;
    private Action printAction;
    private PiggyService piggyService;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
    private PiggyConfig piggyConfig = PiggyConfig.getConfig();
    private FinanceTransactionFactory transactionFactory = new FinanceTransactionFactory();

    public DebtorsState() {
        super("Debtors", AllPermissions.DEBTOR_EDIT_DETAILS, "View and edit debtors");
    }

    @Override
    public void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.addAction(this.getPrintAction());
        this.addSelectionDependentAction((Action)((Object)new ReportAction()));
        this.addAction((Action)((Object)new PrintStatementsAction(this.getSearchFactory().getObjectList())));
        this.addSelectionDependentAction((Action)((Object)new ForceCheckOutAction()));
        this.addSelectionDependentAction((Action)((Object)new DebtorsDiscountAction()));
        this.addSelectionDependentAction((Action)((Object)new DebtorsSurchargeAction()));
        this.addSelectionDependentAction((Action)((Object)new BulkPayOffDebtorsAction()));
        if (SystemProperty.getInstance().getPropertyIntegration().equals((Object)PropertyIntegrationType.PIGGY)) {
            this.addSelectionDependentAction((Action)((Object)new DisplayReservationDetailAction()));
            this.initPiggyService();
        }
    }

    private void initPiggyService() {
        PiggyServiceBuilder piggyServiceBuilder = new PiggyServiceBuilder().setStoreId(Long.valueOf(SystemCurrentInfo.getInstance().getRedbackId()));
        PiggyServiceProvider.setPiggyServiceBuilder((PiggyServiceBuilder)piggyServiceBuilder);
        this.piggyService = PiggyServiceProvider.getPiggyService();
    }

    @Override
    public Action getPrintAction() {
        if (this.printAction == null) {
            this.printAction = new PrintSummaryAction(this.getSearchFactory().getObjectList());
        }
        return this.printAction;
    }

    @Override
    public Class<AbstractDebtor> getDisplayingType() {
        return AbstractDebtor.class;
    }

    @Override
    public ObjectEditor<AbstractDebtor> createObjectEditor() {
        return new DebtorEditPanel();
    }

    @Override
    public String getTypeName() {
        return "Debtor";
    }

    @Override
    public TableStateCentralArea createCentralArea() {
        ArrayList<ColumnFormat> columnFormat = new ArrayList<ColumnFormat>();
        columnFormat.add((ColumnFormat)new PropertyColumnFormat("Name", AbstractDebtor.Properties.LABEL));
        columnFormat.add((ColumnFormat)new PropertyColumnFormat(AbstractDebtor.Properties.GROUP));
        if (this.piggyConfig.isEnabled()) {
            columnFormat.add((ColumnFormat)new AbstractColumnFormat("Room #", String.class){

                public Object resolveColumnValue(Object baseObject) {
                    if (baseObject instanceof RoomAccount) {
                        RoomAccount roomAccount = (RoomAccount)baseObject;
                        return roomAccount.getRoomNumber();
                    }
                    return "";
                }
            });
        }
        columnFormat.add((ColumnFormat)new PropertyColumnFormat("<HTML>Amount<BR>Outstanding</HTML>", AbstractDebtor.Properties.AMOUNT_OUTSTANDING));
        columnFormat.add((ColumnFormat)new PropertyColumnFormat("<HTML>Credit<BR>Limit</HTML>", AbstractDebtor.Properties.CREDIT_LIMIT));
        columnFormat.add((ColumnFormat)new PropertyColumnFormat("<HTML>Earliest<BR>Due Date</HTML>", AbstractDebtor.Properties.EARLIEST_DUE_DATE));
        columnFormat.add((ColumnFormat)new PropertyColumnFormat("<HTML>Last<BR>Activity Date</HTML>", AbstractDebtor.Properties.LAST_ACTIVITY_DATE));
        this.centralArea = new DebtorListPanel(this.getObjectList(), columnFormat);
        JPanel searcher = this.getSearchFactory().getSearchPanel();
        this.centralArea.setSearchBar(searcher);
        return this.centralArea;
    }

    @Override
    public OfficeMateObjectSearch<AbstractDebtor> createSearchPanelFactory() {
        return new DebtorSearchState();
    }

    @Override
    protected AbstractDebtor createNewObject() {
        return new SimpleDebtor();
    }

    @Override
    protected String getObjectLabel(AbstractDebtor debtor) {
        return debtor.getLabel();
    }

    @Override
    protected boolean isDeleteAllowed(List<AbstractDebtor> toDelete) {
        for (AbstractDebtor debtor : toDelete) {
            if (!debtor.hasAmount()) continue;
            Dialogs.showErrorDialog("Cannot delete debtor", "You cannot delete debtors without first settling them.  Please settle the debtors outstanding payments");
            return false;
        }
        return super.isDeleteAllowed(toDelete);
    }

    @Override
    public void gotObjectDoubleClicked(AbstractDebtor toEdit) {
        this.traverseToDebtorSalesState();
    }

    private void traverseToDebtorSalesState() {
        Object selected = this.getCentralArea().getSelectedObject();
        if (selected != null) {
            ApplicationNavigator nav = GuiApp.getAppComplex().getApplicationNavigator();
            nav.navigateTo(DebtorSalesState.class.getName());
            ((DebtorSalesState)nav.getState(DebtorSalesState.class.getName())).setDebtor((AbstractDebtor)selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doEdit(AbstractDebtor toEdit) {
        super.doDialog(toEdit);
        if (super.gotOkClicked()) {
            EventList objectList = this.getObjectList();
            objectList.getReadWriteLock().writeLock().lock();
            try {
                AbstractDebtor editedDebtor = (AbstractDebtor)this.getObjectEditor().getObject();
                int index = objectList.indexOf((Object)toEdit);
                objectList.set(index, (Object)editedDebtor);
                if (!toEdit.equals((Object)editedDebtor)) {
                    objectList.remove((Object)toEdit);
                }
            }
            finally {
                objectList.getReadWriteLock().writeLock().unlock();
            }
            return true;
        }
        return false;
    }

    private boolean isForceCheckOutAllowed(List<AbstractDebtor> debtorList) {
        ArrayList<AbstractDebtor> nonRoomAccountDebtors = new ArrayList<AbstractDebtor>();
        for (AbstractDebtor debtor : debtorList) {
            if (debtor instanceof RoomAccount) continue;
            nonRoomAccountDebtors.add(debtor);
        }
        if (!nonRoomAccountDebtors.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following debtors are not room debtors and will not be deleted:\n");
            for (AbstractDebtor debtor : nonRoomAccountDebtors) {
                sb.append("\n").append(debtor.getLabel());
            }
            Dialogs.showErrorDialog("Cannot Force Checkout Debtors", sb.toString());
            debtorList.removeAll(nonRoomAccountDebtors);
        }
        return !debtorList.isEmpty() && super.isDeleteAllowed(debtorList);
    }

    @Override
    public Action getNewAction() {
        if (this.newAction == null) {
            this.newAction = new NewAction();
        }
        return this.newAction;
    }

    @Override
    public Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditAction();
        }
        return this.editAction;
    }

    @Override
    public Action getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction();
        }
        return this.deleteAction;
    }

    private void addCreditSurchargeTransaction(DebtorPaymentAgent payable, FinanceUnit subType, Price paidAmount) {
        if (Price.ZERO_DOLLAR.equals((Object)paidAmount)) {
            return;
        }
        Price surcharge = FinanceSurchargeCalculator.calculateSurcharge((Price)paidAmount, (Price)Price.ZERO_DOLLAR, (FinanceUnit)subType);
        if (!surcharge.equals((Object)Price.ZERO_DOLLAR)) {
            FinanceTransaction surchargeTransaction = DebtorAdjustmentTransaction.createDebtorSurchargeTransaction((FinanceTransactionContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), (Price)surcharge);
            payable.addFinanceTransaction(surchargeTransaction);
        }
    }

    private void addPaymentTransaction(DebtorPaymentAgent payable, String paymentMethod, FinanceUnit subType, Price paidAmount) {
        if (Price.ZERO_DOLLAR.equals((Object)paidAmount)) {
            return;
        }
        CashTransaction newTransaction = null;
        switch (paymentMethod) {
            case "Cash": {
                newTransaction = new CashTransaction(new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), paidAmount);
                break;
            }
            case "Credit": {
                newTransaction = this.transactionFactory.createCreditTransaction((EventContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), paidAmount, Price.ZERO_DOLLAR, subType);
                break;
            }
            case "Debit": {
                newTransaction = this.transactionFactory.createDebitTransaction((EventContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), paidAmount, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, subType);
                break;
            }
            case "Web": {
                newTransaction = this.transactionFactory.createWebTransaction((EventContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), paidAmount, Price.ZERO_DOLLAR, subType);
                break;
            }
        }
        if (newTransaction != null) {
            payable.addFinanceTransaction(newTransaction);
        }
    }

    private void addDiscountTransaction(String discountType, BigDecimal discountValue, Payable payable) {
        Price adjustmentAmount = "Amount".equals(discountType) ? new Price((Number)discountValue, 0.0) : new Price(payable.getTotal().doubleValue() * discountValue.doubleValue() / 100.0, 0.0);
        if (!adjustmentAmount.equals((Object)Price.ZERO_DOLLAR)) {
            adjustmentAmount = adjustmentAmount.abs();
            FinanceTransaction transaction = DebtorAdjustmentTransaction.createDebtorDiscountTransaction((FinanceTransactionContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), (Price)adjustmentAmount);
            payable.addFinanceTransaction(transaction);
        }
    }

    private void addSurchargeTransaction(String surchargeType, BigDecimal surchargeValue, Payable payable) {
        Price adjustmentAmount = "Amount".equals(surchargeType) ? new Price((Number)surchargeValue, 0.0) : new Price(payable.getTotal().doubleValue() * surchargeValue.doubleValue() / 100.0, 0.0);
        if (!adjustmentAmount.equals((Object)Price.ZERO_DOLLAR)) {
            adjustmentAmount = adjustmentAmount.abs();
            FinanceTransaction transaction = DebtorAdjustmentTransaction.createDebtorSurchargeTransaction((FinanceTransactionContext)new FinanceTransactionContext(OfficeMate.getInstance().getEventContext()), (Price)adjustmentAmount);
            payable.addFinanceTransaction(transaction);
        }
    }

    private boolean isRoomAccount() {
        Object selected = this.getCentralArea().getSelectedObject();
        if (selected != null) {
            AbstractDebtor debtor = (AbstractDebtor)selected;
            return debtor.getType().equals("ROOM");
        }
        return false;
    }

    private class DisplayReservationDetailAction
    extends AbstractActions {
        public DisplayReservationDetailAction() {
            super("View Reservation Detail", IconLoader.get((String)"/ordermate/images/view_report.png"), "View Debtor's Reservation Detail");
        }

        public void actionPerformed(ActionEvent e) {
            if (!DebtorsState.this.isRoomAccount()) {
                StringBuilder sb = new StringBuilder("The first selected debtor is not room debtor");
                Dialogs.showErrorDialog("Cannot View Reservation Detail", sb.toString());
            } else {
                Object selected = DebtorsState.this.getCentralArea().getSelectedObject();
                RoomAccount debtor = (RoomAccount)selected;
                try {
                    if (debtor.getExtID() == null) {
                        StringBuilder sb = new StringBuilder("The extid of  selected debtor is null");
                        Dialogs.showErrorDialog("Cannot View Reservation Detail", sb.toString());
                        return;
                    }
                    PiggyResult piggyResult = DebtorsState.this.piggyService.retrieveReservationDetail(debtor.getExtID());
                    List guestSuggestionList = piggyResult.getPiggyResponse().getGuestSuggestions();
                    if (guestSuggestionList != null && guestSuggestionList.size() > 0) {
                        GuestSuggestion guestSuggestion = (GuestSuggestion)guestSuggestionList.get(0);
                        String result = "Guest Name: " + guestSuggestion.getGuestName() + System.lineSeparator() + "Room Number: " + guestSuggestion.getRoomNumber() + System.lineSeparator() + "Arrival Date: " + DebtorsState.this.sdf.format(guestSuggestion.getGuestArrivalDate().toGregorianCalendar().getTime()) + System.lineSeparator() + "Departure Date: " + DebtorsState.this.sdf.format(guestSuggestion.getGuestDepartureDate().toGregorianCalendar().getTime()) + System.lineSeparator() + "Balance Amount: " + guestSuggestion.getBalanceAmount() + System.lineSeparator() + "Credit Limit: " + guestSuggestion.getCreditLimit() + System.lineSeparator() + "Status: " + guestSuggestion.getReservationStatus() + System.lineSeparator();
                        OrderMate.LOG.info(result);
                        Dialogs.showInfoDialog("Reservation Details", result);
                    }
                }
                catch (Exception e1) {
                    OfficeMate.LOG.error("Error trying to retrieve reservation detail", (Throwable)e1);
                }
            }
        }
    }

    private class ForceCheckOutAction
    extends AbstractActions {
        public ForceCheckOutAction() {
            super("Force Check Out", IconLoader.get((String)"/officemate/images/checkout22.png"), "Force Check Out");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            ArrayList deleteList = new ArrayList(DebtorsState.this.getCentralArea().getAllSelectedObjects());
            if (DebtorsState.this.isForceCheckOutAllowed(deleteList)) {
                EventList objectList = DebtorsState.this.getObjectList();
                objectList.getReadWriteLock().writeLock().lock();
                try {
                    objectList.removeAll(deleteList);
                }
                finally {
                    objectList.getReadWriteLock().writeLock().unlock();
                }
                for (AbstractDebtor debtor : deleteList) {
                    RoomAccount account = (RoomAccount)debtor;
                    OrderMate.LOG.info("Deactivated room account: \nRoom = " + account.getRoomNumber() + "\nFolio = " + account.getFolio() + "\nName = " + account.getLabel());
                    DebtorsState.this.getSaveStrategy().objectNeedsDeleting(debtor);
                }
            }
        }
    }

    private class BulkPayOffDebtorsAction
    extends BasicAction {
        public BulkPayOffDebtorsAction() {
            super("Payment", (Icon)IconLoader.get((String)"/ordermate/images/group22.png"), "Payment");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                boolean ok;
                List debtors = DebtorsState.this.centralArea.getAllSelectedObjects();
                PayoffDebtorsPanel payoffDetorsPanel = new PayoffDebtorsPanel();
                if (debtors.size() == 1) {
                    AbstractDebtor debtor = (AbstractDebtor)debtors.get(0);
                    DebtorPaymentAgent payable = new DebtorPaymentAgent(debtor);
                    payoffDetorsPanel.setDefaultAmount(payable.getDue());
                }
                if (ok = Dialogs.getOkCancelDialogBuilder(payoffDetorsPanel).setTitle("Debtors Payment").doPack().doShow()) {
                    for (AbstractDebtor debtor : debtors) {
                        String paymentMethod = payoffDetorsPanel.getPaymentMethod();
                        FinanceUnit subType = payoffDetorsPanel.getSubType();
                        Price paidAmount = payoffDetorsPanel.getPaidAmt();
                        DebtorPaymentAgent payable = new DebtorPaymentAgent(debtor);
                        DebtorsState.this.addCreditSurchargeTransaction(payable, subType, paidAmount);
                        DebtorsState.this.addPaymentTransaction(payable, paymentMethod, subType, paidAmount);
                        payable.pay();
                    }
                }
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to debtor summary report", (Throwable)e1);
            }
        }
    }

    private class DebtorsSurchargeAction
    extends BasicAction {
        public DebtorsSurchargeAction() {
            super("Surcharge", (Icon)IconLoader.get((String)"/ordermate/images/group22.png"), "Surcharge");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SurchargeDebtorsPanel surchargeDetorsPanel = new SurchargeDebtorsPanel();
                boolean ok = Dialogs.getOkCancelDialogBuilder(surchargeDetorsPanel).setTitle("Debtors Surcharge").doPack().doShow();
                if (ok) {
                    List debtors = DebtorsState.this.centralArea.getAllSelectedObjects();
                    for (AbstractDebtor debtor : debtors) {
                        String surchargeType = surchargeDetorsPanel.getSurchargeType();
                        BigDecimal surchargeValue = surchargeDetorsPanel.getSurchargeValue();
                        DebtorPaymentAgent payable = new DebtorPaymentAgent(debtor);
                        DebtorsState.this.addSurchargeTransaction(surchargeType, surchargeValue, (Payable)payable);
                        payable.pay();
                    }
                }
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to debtor summary report", (Throwable)e1);
            }
        }
    }

    private class DebtorsDiscountAction
    extends BasicAction {
        public DebtorsDiscountAction() {
            super("Discount", (Icon)IconLoader.get((String)"/ordermate/images/group22.png"), "Discount");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                DiscountDebtorsPanel discountDetorsPanel = new DiscountDebtorsPanel();
                boolean ok = Dialogs.getOkCancelDialogBuilder(discountDetorsPanel).setTitle("Debtors Discount").doPack().doShow();
                if (ok) {
                    List debtors = DebtorsState.this.centralArea.getAllSelectedObjects();
                    for (AbstractDebtor debtor : debtors) {
                        String discountType = discountDetorsPanel.getDiscountType();
                        BigDecimal discountValue = discountDetorsPanel.getDiscountValue();
                        DebtorPaymentAgent payable = new DebtorPaymentAgent(debtor);
                        DebtorsState.this.addDiscountTransaction(discountType, discountValue, (Payable)payable);
                        payable.pay();
                    }
                }
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to debtor summary report", (Throwable)e1);
            }
        }
    }

    private class PrintSummaryAction
    extends BasicAction {
        private final EventList<AbstractDebtor> debtors;
        private EventList<AbstractDebtor> filteredDebtors;

        public PrintSummaryAction(EventList<AbstractDebtor> debtorList) {
            super("Print", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print Debtor Summary");
            this.debtors = debtorList;
        }

        private void filterDebtorList() {
            JXTable jxTable = DebtorsState.this.getCentralArea().getTable();
            ArrayList<AbstractDebtor> newList = new ArrayList<AbstractDebtor>((Collection<AbstractDebtor>)this.debtors);
            int size = newList.size();
            for (int i = 0; i < size; ++i) {
                newList.set(jxTable.convertRowIndexToView(i), (AbstractDebtor)this.debtors.get(i));
            }
            this.filteredDebtors = GlazedLists.eventList(newList);
        }

        public void actionPerformed(ActionEvent e) {
            this.filterDebtorList();
            this.filteredDebtors.getReadWriteLock().writeLock().lock();
            DebtorsSummaryReport report = new DebtorsSummaryReport("/ordermate/reports/printing/DebtorsSummaryReport.jrxml", this.filteredDebtors);
            this.filteredDebtors.getReadWriteLock().writeLock().unlock();
            try {
                report.generate();
                JDialog reportDisplay = new JDialog();
                reportDisplay.setContentPane(report.getReportViewer());
                reportDisplay.setSize(800, 600);
                reportDisplay.setVisible(true);
            }
            catch (Exception e1) {
                OfficeMate.LOG.error("Error trying to debtor summary report", (Throwable)e1);
            }
        }
    }

    protected class NewAction
    extends PermissibleAction {
        public NewAction() {
            super("New", AllPermissions.DEBTOR_CREATE_NEW, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Create New", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            AbstractDebtor newObj = DebtorsState.this.createNewObject();
            if (DebtorsState.this.doDialog(newObj)) {
                EventList objectList = DebtorsState.this.getObjectList();
                objectList.getReadWriteLock().writeLock().lock();
                try {
                    objectList.add((Object)newObj);
                }
                finally {
                    objectList.getReadWriteLock().writeLock().unlock();
                }
            }
        }
    }

    protected class DeleteAction
    extends PermissibleAction {
        public DeleteAction() {
            super("Delete", AllPermissions.DEBTOR_EDIT_DETAILS, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Delete", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        public void actionPerformed(ActionEvent e) {
            List selected = DebtorsState.this.getCentralArea().getAllSelectedObjects();
            DebtorsState.this.doDelete(selected);
        }
    }

    protected class EditAction
    extends PermissibleAction {
        public EditAction() {
            super("Edit", AllPermissions.DEBTOR_EDIT_DETAILS, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDebtor editObj = (AbstractDebtor)DebtorsState.this.getCentralArea().getSelectedObject();
            DebtorsState.this.doEdit(editObj);
        }
    }

    protected class ReportAction
    extends BasicAction {
        public ReportAction() {
            super("View Sales", (Icon)IconLoader.get((String)"/ordermate/images/view_report.png"), "View Debtor's Sales");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorsState.this.traverseToDebtorSalesState();
        }
    }
}

