/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ordermate.internationalization.Internationalization;

public class DiscountDebtorsPanel
extends JPanel
implements ActionListener {
    private JPanel contentPanel;
    private JLabel instructions = new JLabel();
    public static final String PERCENTAGE_DISCOUNT = "Percentage";
    public static final String AMOUNT_DISCOUNT = "Amount";
    private JComboBox discountTypeCB;
    private JLabel discountValLabel;
    private JTextField discountValTF;

    public DiscountDebtorsPanel() {
        super(new BorderLayout());
        this.contentPanel = this.getContentPanel();
        this.add((Component)this.instructions, "North");
        this.add((Component)new JScrollPane(this.contentPanel), "Center");
    }

    private JPanel getDiscountPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Debtor Discount"));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Discount Type:");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)label, gbc);
        this.discountTypeCB = new JComboBox<String>(new String[]{PERCENTAGE_DISCOUNT, AMOUNT_DISCOUNT});
        this.discountTypeCB.addActionListener(this);
        gbc.fill = 2;
        this.setGBC(gbc, 1, 0);
        panel.add((Component)this.discountTypeCB, gbc);
        this.discountValLabel = new JLabel("");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 1);
        panel.add((Component)this.discountValLabel, gbc);
        this.discountValTF = new JTextField(15);
        this.discountValTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                String s;
                int dot;
                char c = evt.getKeyChar();
                if (!Character.isDigit(c) && c != '.' && c != '\b') {
                    DiscountDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                } else if (c == '.' && (dot = (s = DiscountDebtorsPanel.this.discountValTF.getText()).indexOf(46)) != -1) {
                    DiscountDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                }
            }
        });
        gbc.fill = 2;
        this.setGBC(gbc, 1, 1);
        gbc.ipadx = 50;
        panel.add((Component)this.discountValTF, gbc);
        this.discountTypeCB.setSelectedItem(PERCENTAGE_DISCOUNT);
        return panel;
    }

    private JPanel getContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel discountPanel = this.getDiscountPanel();
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)discountPanel, gbc);
        return panel;
    }

    private void setGBC(GridBagConstraints gbc, int x, int y) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    private void setGBC(GridBagConstraints gbc, int x, int y, int width) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    public String getDiscountType() {
        return (String)this.discountTypeCB.getSelectedItem();
    }

    public BigDecimal getDiscountValue() {
        if (this.discountValTF.getText().isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.discountValTF.getText()).setScale(2, 6);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.discountTypeCB) {
            String selectedType = (String)this.discountTypeCB.getSelectedItem();
            if (PERCENTAGE_DISCOUNT.equals(selectedType)) {
                this.discountValLabel.setText("Percentage %");
            } else if (AMOUNT_DISCOUNT.equals(selectedType)) {
                this.discountValLabel.setText("Amount " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            }
        }
    }
}

