/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.internationalization.Internationalization;

public class PayoffDebtorsPanel
extends JPanel
implements ActionListener {
    private JPanel contentPanel;
    private JLabel instructions = new JLabel();
    public static final String CASH = "Cash";
    public static final String CREDIT = "Credit";
    public static final String DEBIT = "Debit";
    public static final String WEB = "Web";
    private JComboBox paymentMethodCB;
    private JComboBox paymentSubTypeCB;
    private JTextField paidAmtTF;

    public PayoffDebtorsPanel() {
        super(new BorderLayout());
        this.contentPanel = this.getContentPanel();
        this.add((Component)this.instructions, "North");
        this.add((Component)new JScrollPane(this.contentPanel), "Center");
    }

    private JPanel getPaymentMethodPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Payment Method"));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Payment Methods:");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)label, gbc);
        this.paymentMethodCB = new JComboBox<String>(new String[]{CASH, CREDIT, DEBIT, WEB});
        this.paymentMethodCB.addActionListener(this);
        gbc.fill = 2;
        this.setGBC(gbc, 1, 0);
        gbc.ipadx = 50;
        panel.add((Component)this.paymentMethodCB, gbc);
        label = new JLabel("Types:");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 1);
        panel.add((Component)label, gbc);
        this.paymentSubTypeCB = new JComboBox();
        gbc.fill = 2;
        this.setGBC(gbc, 1, 1);
        panel.add((Component)this.paymentSubTypeCB, gbc);
        this.paymentMethodCB.setSelectedItem(CASH);
        label = new JLabel("Amount " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
        gbc.fill = 2;
        this.setGBC(gbc, 0, 2);
        panel.add((Component)label, gbc);
        this.paidAmtTF = new JTextField(15);
        this.paidAmtTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                String s;
                int index;
                char c = evt.getKeyChar();
                if (!Character.isDigit(c) && c != '.' && c != '-' && c != '\b') {
                    PayoffDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                } else if ((c == '.' || c == '-') && (index = (s = PayoffDebtorsPanel.this.paidAmtTF.getText()).indexOf(c)) != -1) {
                    PayoffDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                }
            }
        });
        gbc.fill = 2;
        this.setGBC(gbc, 1, 2);
        panel.add((Component)this.paidAmtTF, gbc);
        return panel;
    }

    private JPanel getContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel paymentMethodPanel = this.getPaymentMethodPanel();
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)paymentMethodPanel, gbc);
        return panel;
    }

    private void setGBC(GridBagConstraints gbc, int x, int y) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    private void setGBC(GridBagConstraints gbc, int x, int y, int width) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    public String getPaymentMethod() {
        return (String)this.paymentMethodCB.getSelectedItem();
    }

    public FinanceUnit getSubType() {
        return (FinanceUnit)this.paymentSubTypeCB.getSelectedItem();
    }

    public Price getPaidAmt() {
        if (StringUtils.isEmpty((String)this.paidAmtTF.getText())) {
            return Price.ZERO_DOLLAR;
        }
        return Price.parsePrice((String)this.paidAmtTF.getText());
    }

    public void setDefaultAmount(Price amountPaid) {
        this.paidAmtTF.setText(amountPaid.toString(false));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.paymentMethodCB) {
            String selectedMethod = (String)this.paymentMethodCB.getSelectedItem();
            if (CASH.equals(selectedMethod)) {
                this.paymentSubTypeCB.setEnabled(false);
            } else {
                this.paymentSubTypeCB.setEnabled(true);
                this.paymentSubTypeCB.removeAllItems();
                List subTypes = new ArrayList();
                switch (selectedMethod) {
                    case "Credit": {
                        subTypes = FinanceUnit.getActiveCreditUnits();
                        break;
                    }
                    case "Debit": {
                        subTypes = FinanceUnit.getActiveDebitUnits();
                        break;
                    }
                    case "Web": {
                        subTypes = FinanceUnit.getWebUnits();
                    }
                }
                for (FinanceUnit subType : subTypes) {
                    this.paymentSubTypeCB.addItem(subType);
                }
            }
        }
    }
}

