/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ordermate.internationalization.Internationalization;

public class SurchargeDebtorsPanel
extends JPanel
implements ActionListener {
    private JPanel contentPanel;
    private JLabel instructions = new JLabel();
    public static final String PERCENTAGE_SURCHARGE = "Percentage";
    public static final String AMOUNT_SURCHARGE = "Amount";
    private JComboBox surchargeTypeCB;
    private JLabel surchargeValLabel;
    private JTextField surchargeValTF;

    public SurchargeDebtorsPanel() {
        super(new BorderLayout());
        this.contentPanel = this.getContentPanel();
        this.add((Component)this.instructions, "North");
        this.add((Component)new JScrollPane(this.contentPanel), "Center");
    }

    private JPanel getDiscountPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Debtor Surcharge"));
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Surcharge Type:");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)label, gbc);
        this.surchargeTypeCB = new JComboBox<String>(new String[]{PERCENTAGE_SURCHARGE, AMOUNT_SURCHARGE});
        this.surchargeTypeCB.addActionListener(this);
        gbc.fill = 2;
        this.setGBC(gbc, 1, 0);
        panel.add((Component)this.surchargeTypeCB, gbc);
        this.surchargeValLabel = new JLabel("");
        gbc.fill = 2;
        this.setGBC(gbc, 0, 1);
        panel.add((Component)this.surchargeValLabel, gbc);
        this.surchargeValTF = new JTextField(15);
        this.surchargeValTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                String s;
                int dot;
                char c = evt.getKeyChar();
                if (!Character.isDigit(c) && c != '.' && c != '\b') {
                    SurchargeDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                } else if (c == '.' && (dot = (s = SurchargeDebtorsPanel.this.surchargeValTF.getText()).indexOf(46)) != -1) {
                    SurchargeDebtorsPanel.this.getToolkit().beep();
                    evt.consume();
                }
            }
        });
        gbc.fill = 2;
        this.setGBC(gbc, 1, 1);
        gbc.ipadx = 50;
        panel.add((Component)this.surchargeValTF, gbc);
        this.surchargeTypeCB.setSelectedItem(PERCENTAGE_SURCHARGE);
        return panel;
    }

    private JPanel getContentPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel discountPanel = this.getDiscountPanel();
        gbc.fill = 2;
        this.setGBC(gbc, 0, 0);
        panel.add((Component)discountPanel, gbc);
        return panel;
    }

    private void setGBC(GridBagConstraints gbc, int x, int y) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    private void setGBC(GridBagConstraints gbc, int x, int y, int width) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.weighty = 1.0;
        gbc.ipadx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
    }

    public String getSurchargeType() {
        return (String)this.surchargeTypeCB.getSelectedItem();
    }

    public BigDecimal getSurchargeValue() {
        if (this.surchargeValTF.getText().isEmpty()) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(this.surchargeValTF.getText()).setScale(2, 6);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.surchargeTypeCB) {
            String selectedType = (String)this.surchargeTypeCB.getSelectedItem();
            if (PERCENTAGE_SURCHARGE.equals(selectedType)) {
                this.surchargeValLabel.setText("Percentage %");
            } else if (AMOUNT_SURCHARGE.equals(selectedType)) {
                this.surchargeValLabel.setText("Amount " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"));
            }
        }
    }
}

