/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.debtor.debtorsales;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.reports.PrintDataReport;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.debtor.debtorsales.DateRangeDialog;
import officemate.screens.debtor.debtorsales.DebtorReportPanel;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.activitystatement.ActivityStatement;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.users.AllPermissions;
import ordermate.reports.printing.ActivityStatementReport;
import ordermate.reports.printing.StatementReport;

public class DebtorSalesState
extends BasicOfficeMateState {
    private DebtorReportPanel reportPanel;
    private PrintStatementAction statementAction = new PrintStatementAction();
    private PrintActivityStatementAction activityStatementAction = new PrintActivityStatementAction();
    private RefreshAction refreshAction = new RefreshAction();
    private static Cursor busy = Cursor.getPredefinedCursor(3);
    private static Cursor done = Cursor.getDefaultCursor();

    public DebtorSalesState() {
        super("Debtor Sales", AllPermissions.DEBTOR_ORDER_DETAILS, "View and print debtor sales and transactions");
        this.reportPanel = new DebtorReportPanel();
        this.reportPanel.debtorSaleEdited.connect((Object)this, "gotDebtorSaleEdited");
        this.reportPanel.debtorSelected.connect((Object)this, "gotDebtor");
        this.reportPanel.allDebtorsSelected.connect((Object)this, "gotAllDebtors");
        this.setScreenPanel(this.reportPanel);
        this.addAction((Action)((Object)this.statementAction));
        this.addAction((Action)((Object)this.activityStatementAction));
        this.addAction((Action)((Object)this.refreshAction));
        this.setDebtor(null);
    }

    public void gotDebtorSaleEdited(DebtorSale sale) {
        if (!this.getUser().hasPermission(AllPermissions.DEBTOR_EDIT_DETAILS)) {
            Dialogs.showWarningDialog("You do not have permission", "You do not have permission to edit the details of this debtor");
            this.refresh();
            return;
        }
        sale.saveChild();
    }

    public void gotAllDebtors(Boolean allDebtors) {
        if (Boolean.TRUE.equals(allDebtors)) {
            this.statementAction.setEnabled(false);
            this.activityStatementAction.setEnabled(false);
        }
        this.refreshAction.setEnabled(allDebtors);
    }

    public void setDebtor(AbstractDebtor d) {
        this.statementAction.setEnabled(d != null);
        this.activityStatementAction.setEnabled(d != null);
        this.refreshAction.setEnabled(d != null);
        this.reportPanel.setDebtor(d);
    }

    public void gotDebtor(AbstractDebtor debtor) {
        this.statementAction.setEnabled(debtor != null);
        this.activityStatementAction.setEnabled(debtor != null);
        this.refreshAction.setEnabled(debtor != null);
    }

    @Override
    public void refresh() {
        this.reportPanel.refresh();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    protected void printReport(final PrintDataReport report) {
        GuiApp.getAppComplex().getApplicationFrame().getFrame().setCursor(busy);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    report.generate();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JDialog reportDisplay = new JDialog();
                            reportDisplay.setContentPane(report.getReportViewer());
                            reportDisplay.setSize(800, 600);
                            reportDisplay.setVisible(true);
                        }
                    });
                }
                catch (Exception ex) {
                    try {
                        OfficeMate.LOG.error("Error trying to print the report.", (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GuiApp.getAppComplex().getApplicationFrame().getFrame().setCursor(done);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }, this.getName()).start();
    }

    private class RefreshAction
    extends BasicAction {
        public RefreshAction() {
            super("Refresh", (Icon)IconLoader.get((String)"/ordermate/images/refresh_icon22.png"), "Refresh");
        }

        public void actionPerformed(ActionEvent e) {
            DebtorSalesState.this.refresh();
        }
    }

    private class PrintActivityStatementAction
    extends BasicAction {
        private final DateRangeDialog dates;

        public PrintActivityStatementAction() {
            super("Print Activity Statement", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"));
            this.dates = new DateRangeDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Activity Statement", this.enabled);
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDebtor debtor = DebtorSalesState.this.reportPanel.getDebtor();
            if (debtor != null) {
                if (!this.dates.start()) {
                    return;
                }
                ActivityStatementReport report = new ActivityStatementReport();
                ActivityStatement stmt = new ActivityStatement(debtor, this.dates.getStartDate(), this.dates.getEndDate());
                report.setStatement(stmt);
                DebtorSalesState.this.printReport((PrintDataReport)report);
            }
        }
    }

    private class PrintStatementAction
    extends BasicAction {
        public PrintStatementAction() {
            super("Print Invoice Statement", (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"));
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDebtor debtor = DebtorSalesState.this.reportPanel.getDebtor();
            if (debtor != null) {
                List salesToPrint = debtor.getUnpaidSales();
                if (salesToPrint.size() == 0) {
                    JOptionPane errorPane = new JOptionPane("No outstanding sales.  There is no statement to print.", 0);
                    JDialog dialog = errorPane.createDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "No outstanding sales");
                    dialog.setVisible(true);
                } else {
                    StatementReport report = new StatementReport(salesToPrint, Price.ZERO, "/ordermate/reports/printing/StatementPrintDataReport.jrxml");
                    DebtorSalesState.this.printReport((PrintDataReport)report);
                }
            }
        }
    }
}

