/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.integration;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.swing.ImageIcon;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.database.integration.online.OnlineIntegrationConfig;

public class OfficeMateOnlineOrdersGuiUtils {
    private static final String DEFAULT_TOOLTIP_ONLINE_MENU_SYNC_TEXT = "Online Menu Sync";
    public static final String ONLINE_MENU_SYNC_WARNING_DIALOG_TITLE = "Online Menu Sync is Required";
    private static final String ONLINE_MENU_SYNC_LINK_DISPLAY_TEXT = "Please click to synchronize online menu";
    private static final String ONLINE_MENU_SYNC_DETAILED_MSG = "You have changes which effect your online store that haven't been updated online yet! Please synchronise to see these changes take effect!";

    public static void warnForOnlineMenuSync() {
        try {
            Dialogs.showLinkDialog(ONLINE_MENU_SYNC_WARNING_DIALOG_TITLE, HtmlUtils.html((String)ONLINE_MENU_SYNC_DETAILED_MSG), new URI("https://platform.hungryhungry.com"), ONLINE_MENU_SYNC_LINK_DISPLAY_TEXT);
        }
        catch (URISyntaxException e) {
            OrderMate.LOG.error("URISyntaxException while grabbing HungryHungry URI!", (Throwable)e);
        }
    }

    public static ImageIcon getOnlineMenuSyncIcon(boolean needsImport) {
        return IconLoader.get((String)(needsImport ? "/officemate/images/hh_import_animated.gif" : "/officemate/images/hh_import.png"));
    }

    public static ImageIcon getStandardOnlineMenuSyncIcon() {
        return IconLoader.get((String)"/officemate/images/hh_import.png");
    }

    public static String getTooltipForOnlineMenuSyncIcon() {
        StringBuilder sb = new StringBuilder(DEFAULT_TOOLTIP_ONLINE_MENU_SYNC_TEXT);
        String lastImport = OfficeMateOnlineOrdersGuiUtils.getHHLastMenuImportTime();
        if (!StringUtils.isEmpty((String)lastImport)) {
            sb.append(". Last Menu Imported: ").append(lastImport);
        }
        return sb.toString();
    }

    private static String getHHLastMenuImportTime() {
        try {
            OnlineIntegrationConfig hungryHungryConfig = OnlineIntegrationConfig.getHungryHungryConfig();
            Date lastMenuImportTime = hungryHungryConfig != null ? hungryHungryConfig.getLastMenuImportTime() : null;
            return lastMenuImportTime != null ? DateTimeUtils.getDateTimeFormat().format(lastMenuImportTime) : "";
        }
        catch (Exception e) {
            OrderMate.LOG.error("Unable to get Hungry Hungry last menu import time!", (Throwable)e);
            return "";
        }
    }
}

