/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.adjust;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.print.Printing;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.screens.ObjectManagerI;
import officemate.screens.maintainstock.adjust.OldAdjustmentsLookDifferentCellRenderer;
import officemate.screens.maintainstock.adjust.StockAdjustmentTableModel;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.reports.stock.adjustment.StockAdjustmentReportQuery;
import ordermate.database.searchers.stock.adjustment.StockAdjustmentSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockAdjustment;
import ordermate.database.stock.usage.StockUsage;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.internationalization.Internationalization;

public class StockAdjustmentState
extends BasicOfficeMateState {
    static final String DB_STOCK_USAGE_ID = "stock_usage.ID";
    static final String DB_STOCK_ITEM_NAME = "stock_item.Name";
    static final String DB_STOCK_USAGE_QUANTITY = "-stock_usage.Quantity";
    static final String DB_STOCK_USAGE_DATE = "stock_usage.UsageDate";
    static final String DB_USER_NAME = "UserName";
    static final String DB_STOCK_USAGE_CREATION_DATE = "stock_usage.CreationDate";
    static final String DB_STOCK_ITEM_DISPLAY_UNIT = "stock_item.fk_display_measure_unit_container";
    static final String DB_STOCK_USAGE_VALUE = "UsageValue";
    private static final String GST = Internationalization.getLiteralFor((String)"GST");
    private static final String VALUE_COL_NAME = MessageFormat.format("Value (Inc {0})", GST);
    private JPanel innerPanel;
    private JPanel northPanel;
    private JSplitPane splitter;
    private StockGroupTreePanel treePanel = null;
    private SelectQuery query;
    private JPanel tablePanel;
    private JPanel southPanel;
    private QueryTable table;
    private QueryTableModel tableModel;
    private LinkedTotalTable totalsTable;
    private DateRangePanel datePanel = null;
    private final ObjectTemplate stockAdjustmentTemplate = Templates.STOCK_ADJUSTMENT;
    private JComboBox areaCombo;
    private JComboBox userCombo;
    private boolean updatesAllowed = true;
    private boolean lastStartOk = false;
    private StockAdjustmentSearcher searcher;

    public StockAdjustmentState() {
        super("Adjustment", AllPermissions.ACCESS_ADJUSTMENT_SCREEN, "View, create and modify adjustments to stock levels");
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setName("Adjustment");
        this.setScreenPanel(this.innerPanel);
        this.searcher = new StockAdjustmentSearcher();
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.ADD_ADJUSTMENTS));
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_ADJUSTMENTS));
        this.addAction((Action)ActionFactory.createPermissibleDeleteAction(this, AllPermissions.DELETE_ADJUSTMENTS));
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Stock Adjustment screen...");
        if (!this.lastStartOk) {
            this.lastStartOk = Dialogs.showProgressDialog((AbstractTask)new StockAdjustmentSetupTask());
            if (!this.lastStartOk) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        this.updateButtonStates();
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public boolean supportsNew() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doNewAction() {
        this.addObject();
    }

    private void setupGUI() {
        this.splitter = new JSplitPane();
        this.northPanel = new JPanel(new BorderLayout());
        this.innerPanel.add((Component)this.splitter, "Center");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupDates() {
        this.datePanel = new DateRangePanel();
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        Date now = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        Date startOfMonth = new Date(cal.getTimeInMillis());
        this.datePanel.setEndDate(now);
        this.datePanel.setStartDate(startOfMonth);
        this.northPanel.add((Component)this.datePanel, "East");
    }

    private void setupCombos() {
        this.areaCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areaCombo.setName("Area");
        this.areaCombo.insertItemAt("(All)", 0);
        this.areaCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areaCombo);
        ActionListener comboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StockAdjustmentState.this.updatesAllowed) {
                    StockAdjustmentState.this.refresh();
                }
            }
        };
        this.areaCombo.addActionListener(comboListener);
        this.userCombo = new JComboBox(new Vector(User.getUsers()));
        this.userCombo.setName("User");
        this.userCombo.insertItemAt("(All)", 0);
        this.userCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.userCombo);
        this.userCombo.addActionListener(comboListener);
        FieldPanelBuilder builder = new FieldPanelBuilder(0);
        builder.addRow("Area:", (Component)this.areaCombo);
        builder.addRow("User:", (Component)this.userCombo);
        this.northPanel.add((Component)builder.getPanel(), "West");
    }

    private void setupTree() {
        this.treePanel = new StockGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void setupTable() {
        this.tableModel = new StockAdjustmentTableModel(this.query, DB_STOCK_USAGE_ID, StockAdjustmentReportQuery.dbColumns, StockAdjustmentReportQuery.displayColumns, GuiApp.getAppComplex().getApplicationContext());
        this.tableModel.addTotalColumn(DB_STOCK_USAGE_VALUE);
        this.table = new QueryTable(this.tableModel);
        this.table.setName("StockAdjustmentTable");
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        StockTake lastStockTake = StockTake.getLastSavedStockTake();
        if (lastStockTake != null) {
            this.table.setCellRendererForAll(new OldAdjustmentsLookDifferentCellRenderer(lastStockTake.getDate()));
        }
        this.table.objectChosen.connect((Object)this, "doEditAction");
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        JPanel buttonWrapperPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.southPanel = new JPanel(new BorderLayout());
        this.southPanel.add((Component)this.tablePanel, "Center");
        this.southPanel.add((Component)buttonWrapperPanel, "East");
        this.splitter.setRightComponent(this.southPanel);
        this.splitter.setDividerLocation(160);
    }

    private void setupTotalsPanel() {
        this.totalsTable = new LinkedTotalTable(this.table.getColumnModel());
        JPanel totalWrapperPanel = new JPanel(new BorderLayout());
        totalWrapperPanel.add((Component)new JLabel("Totals:"), "North");
        totalWrapperPanel.add((Component)this.totalsTable, "Center");
        this.tablePanel.add((Component)totalWrapperPanel, "South");
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        if (this.treePanel == null) {
            this.updatesAllowed = true;
            return;
        }
        Object comboSelected = this.areaCombo.getSelectedItem();
        this.areaCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
        this.areaCombo.insertItemAt("(All)", 0);
        this.areaCombo.setSelectedIndex(0);
        this.areaCombo.setSelectedItem(comboSelected);
        Object selGroup = this.treePanel.getSelectedObject();
        this.treePanel.refresh();
        this.treePanel.getTree().setSelectedObject(selGroup);
        comboSelected = this.userCombo.getSelectedItem();
        this.userCombo.setModel(new DefaultComboBoxModel(new Vector(User.getUsers())));
        this.userCombo.insertItemAt("(All)", 0);
        this.userCombo.setSelectedIndex(0);
        this.userCombo.setSelectedItem(comboSelected);
        StockTake lastStockTake = StockTake.getLastSavedStockTake();
        if (lastStockTake != null) {
            this.table.setCellRendererForAll(new OldAdjustmentsLookDifferentCellRenderer(lastStockTake.getDate()));
        }
        this.updateQuery(this.getCurrentStockGroup());
        this.updatesAllowed = true;
    }

    @Override
    public void doPrintAction() {
        String title = "Stock on Hand Adjustments";
        DateDMY start = new DateDMY((Date)this.datePanel.getSQLStartDate());
        DateDMY end = new DateDMY((Date)this.datePanel.getSQLEndDate());
        String dateString = " from " + start + " to " + end;
        StockArea area = this.getCurrentStockArea();
        User user = this.getCurrentUser();
        String areaString = area != null ? " Stock Area: " + area.getLabel() : "";
        String userString = user != null ? " User: " + user.getLabel() : "";
        Printing.printJTableReport(this.table, title + dateString, areaString + userString, 8, this.totalsTable.getColumnStrings());
    }

    private StockArea getCurrentStockArea() {
        Object obj = this.areaCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    private User getCurrentUser() {
        Object obj = this.userCombo.getSelectedItem();
        return obj instanceof User ? (User)obj : null;
    }

    private StockGroup getCurrentStockGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof StockGroup ? (StockGroup)obj : null;
    }

    private void updateQuery() {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockArea(), this.getCurrentStockGroup(), this.datePanel.getStartDate(), this.datePanel.getEndDate());
    }

    private void updateQuery(Date start, Date end) {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockArea(), this.getCurrentStockGroup(), start, end);
    }

    private void updateQuery(StockGroup currentStockGroup) {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockArea(), currentStockGroup, this.datePanel.getStartDate(), this.datePanel.getEndDate());
    }

    public void updateQuery(User user, StockArea area, StockGroup group, Date start, Date end) {
        this.searcher.getStockAreaFilter().setSearchValue((Object)area);
        this.searcher.getStockGroupFilter().setSearchValue((Object)group);
        this.searcher.getUserSearchFilter().setSearchValue((Object)user);
        this.searcher.getDateRangeFilter().setStart((Comparable)start);
        this.searcher.getDateRangeFilter().setEnd((Comparable)end);
        this.query = this.searcher.getQuery();
        this.tableModel.setQuery(this.query);
        this.table.updateModel();
        this.totalsTable.setColumnValues(this.table.getTotals());
        this.table.revalidate();
        this.table.repaint();
        this.totalsTable.repaint();
    }

    private void addObject() {
        boolean hasAreaAndItem;
        boolean bl = hasAreaAndItem = StockArea.stockAreasExist() && StockItemQueries.stockItemsExist();
        if (!hasAreaAndItem) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To create an adjustment, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't create adjustment!", 2);
            return;
        }
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Creating " + this.stockAdjustmentTemplate.getName() + "...");
        ObjectEditorPanel editorView = this.stockAdjustmentTemplate.getNewEditPanel(null);
        while (ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView, true) == 0) {
            editorView.saveObject();
            StockUsage obj = (StockUsage)editorView.getEditedObject();
            Assert.isTrue((obj != null ? 1 : 0) != 0, (String)"Edited object must not be null");
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(obj, this.stockAdjustmentTemplate);
            if (obj != null) {
                obj.commit();
                StockControlEventLog.logCreateStockAdjustment((User)this.getUser(), (StockAdjustment)((StockAdjustment)obj));
            }
            editorView = this.stockAdjustmentTemplate.getNewEditPanel(null);
            this.updateQuery();
        }
        editorView.cancelObject();
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public void doEditAction() {
        boolean hasAreaAndItem;
        boolean bl = hasAreaAndItem = StockArea.stockAreasExist() && StockItemQueries.stockItemsExist();
        if (!hasAreaAndItem) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To edit an adjustment, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't edit adjustment!", 2);
            return;
        }
        StockAdjustment obj = this.getCurrentStockAdjustment();
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(this.stockAdjustmentTemplate);
        changeRecorder.snapshot(obj);
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing " + this.stockAdjustmentTemplate.getName() + ":  " + this.stockAdjustmentTemplate.getObjectText(obj));
        ObjectEditorPanel editorView = this.stockAdjustmentTemplate.getNewEditPanel(obj);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView);
        if (result == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockAdjustment((User)this.getUser(), (StockAdjustment)obj, changeRecorder.getChanges(obj));
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(obj, this.stockAdjustmentTemplate);
            obj.commit();
        } else if (result == 1) {
            editorView.cancelObject();
        } else if (result != 2) {
            throw new IllegalArgumentException("Illegal dialog result: " + result);
        }
        this.updateQuery();
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public void doDeleteAction() {
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Are you sure you wish to delete the selected adjustment? \nThis operation cannot be undone.", "Delete adjustment?", 0, 2);
        if (result == 0) {
            StockAdjustment obj = this.getCurrentStockAdjustment();
            int selRow = this.table.getSelectedRow();
            GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Removing " + this.stockAdjustmentTemplate.getName() + ":  " + this.stockAdjustmentTemplate.getObjectText(obj));
            StockControlEventLog.logDeleteStockAdjustment((User)this.getUser(), (StockAdjustment)obj);
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().deleteObject(obj, this.stockAdjustmentTemplate);
            obj.cancelUsage();
            this.updateQuery();
            int rowCount = this.table.getModel().getRowCount();
            this.table.requestFocus();
            if (selRow < rowCount) {
                this.table.setRowSelectionInterval(selRow, selRow);
            } else if (rowCount > 0) {
                this.table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            }
            this.updateButtonStates();
            GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
        }
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.updatesAllowed) {
            StockGroup group = null;
            if (obj instanceof StockGroup) {
                group = (StockGroup)obj;
            }
            this.updateQuery(group);
        }
    }

    public StockAdjustment getCurrentStockAdjustment() {
        long id = this.tableModel.getID(this.table.getSelectedRow());
        return id != -1L ? new StockAdjustment(id) : null;
    }

    void gotTableObjectSelected() {
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        StockAdjustment usage = this.getCurrentStockAdjustment();
        boolean isObjectSelected = usage != null && this.table.getSelectedRow() != -1;
        this.toggleDefaultAction(this.getEditAction(), isObjectSelected);
        this.toggleDefaultAction(this.getDeleteAction(), isObjectSelected && usage != null && !usage.isFrozen());
    }

    void gotDatesChanged(Date newStartDate, Date newEndDate) {
        if (this.datePanel != null) {
            this.updateQuery(newStartDate, newEndDate);
        }
    }

    public StockAdjustmentSearcher getSearcher() {
        return this.searcher;
    }

    private class StockAdjustmentSetupTask
    extends AbstractGuiTask {
        private StockAdjustmentSetupTask() {
        }

        public String getName() {
            return "Loading Stock Adjustment screen...";
        }

        public void doGuiTask() throws Exception {
            StockAdjustmentState.this.setupGUI();
            this.emitProgress();
            StockAdjustmentState.this.setupCombos();
            this.emitProgress();
            StockAdjustmentState.this.setupTree();
            this.emitProgress();
            StockAdjustmentState.this.setupTable();
            this.emitProgress();
            StockAdjustmentState.this.setupTotalsPanel();
            this.emitProgress();
            StockAdjustmentState.this.setupDates();
            this.emitProgress();
            StockAdjustmentState.this.refresh();
            StockAdjustmentState.this.lastStartOk = true;
            if (StockAdjustmentState.this.table.getModel().getRowCount() > 0) {
                StockAdjustmentState.this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 7;
        }
    }
}

