/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;
import officemate.adminkit.cellrenderers.OldItemsLookDifferentCellRenderer;
import officemate.screens.maintainstock.invoice.StockInvoiceTableModel;

public class OldInvoicesLookDifferentCellRenderer
extends OldItemsLookDifferentCellRenderer {
    private static final Color NON_MATCHING_COLOR = Color.red;
    private static final Color NORMAL_COLOR = Color.black;

    public OldInvoicesLookDifferentCellRenderer(Date date) {
        super(date);
    }

    @Override
    protected Date getItemDate(JTable theTable, int row) {
        StockInvoiceTableModel model = (StockInvoiceTableModel)theTable.getModel();
        return model.getCreationDate(row);
    }

    @Override
    public Component getTableCellRendererComponent(JTable theTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(theTable, value, isSelected, hasFocus, row, column);
        StockInvoiceTableModel model = (StockInvoiceTableModel)theTable.getModel();
        double expectedTotal = model.getExpectedTotal(row).doubleValue();
        double actualTotal = model.getActualTotal(row).doubleValue();
        String invoiceType = model.getInvoiceType(row);
        double diff = Math.abs(expectedTotal - actualTotal);
        if (invoiceType.equals("Purchase Order")) {
            this.setForeground(NORMAL_COLOR);
            this.setFont(this.getNormalFont());
        } else if (invoiceType.equals("Delivery Note") || diff > 0.05) {
            this.setForeground(NON_MATCHING_COLOR);
        } else {
            this.setForeground(NORMAL_COLOR);
        }
        return this;
    }
}

