/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.DateDMY_HM;
import au.com.ordermate.util.Price;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;

public class StockInvoiceTableModel
extends QueryTableModel {
    private List expectedTotals = new ArrayList();
    private List actualTotals = new ArrayList();
    private List invoiceTypes = new ArrayList();
    private List creationDates = new ArrayList();

    public StockInvoiceTableModel(SelectQuery selQuery, DBConnectionInterface dc, String idField, String[] colNames, String[] colDisplayNames) {
        super(selQuery, dc, idField, colNames, colDisplayNames);
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        if (col == 0) {
            Timestamp creationTS = rs.getTimestamp("stock_invoice.CreationDate");
            Date creationDate = new Date(creationTS.getTime());
            this.creationDates.add(creationDate);
            Price actualTotal = new Price(rs.getDouble("TotalIncTax"), 0.0);
            this.actualTotals.add(actualTotal);
            Price expectedTotal = new Price(rs.getDouble("stock_invoice.ExpectedTotal"), 0.0);
            this.expectedTotals.add(expectedTotal);
            String invoiceType = rs.getString("stock_invoice.invoice_type");
            this.invoiceTypes.add(invoiceType);
        }
        if (this.isPriceField(colName)) {
            return new Price(rs.getDouble(colName), 0.01);
        }
        if (colName.equals("stock_invoice.Date")) {
            Timestamp t = rs.getTimestamp(colName);
            if (t != null) {
                return new DateDMY((Date)rs.getTimestamp(colName));
            }
            return null;
        }
        if (colName.equals("stock_invoice.CreationDate")) {
            return new DateDMY_HM((Date)rs.getTimestamp(colName));
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }

    public Date getCreationDate(int row) {
        return (Date)this.creationDates.get(row);
    }

    public String getInvoiceType(int row) {
        return (String)this.invoiceTypes.get(row);
    }

    public Price getActualTotal(int row) {
        return (Price)this.actualTotals.get(row);
    }

    public Price getExpectedTotal(int row) {
        return (Price)this.expectedTotals.get(row);
    }

    @Override
    protected Number getTotalValue(int column, double rawValue, String colName, int dbColIndex) {
        if (this.isPriceField(colName)) {
            return new Price(rawValue, 0.01);
        }
        return super.getTotalValue(column, rawValue, colName, dbColIndex);
    }

    private boolean isPriceField(String colName) {
        return colName.equals("TaxAmount") || colName.equals("TotalExTax") || colName.equals("TotalIncTax");
    }

    @Override
    public void update() {
        this.expectedTotals.clear();
        this.actualTotals.clear();
        this.invoiceTypes.clear();
        this.creationDates.clear();
        super.update();
    }
}

