/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.util.List;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.templates.StockInvoiceEntryTemplate;
import officemate.screens.maintainstock.invoice.ObjectTotalsPanel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoice;

class StockInvoiceTotalsPanel
extends ObjectTotalsPanel {
    private StockInvoice invoice;
    private double TAX = SystemProperty.getInstance().getBaseTaxRate();

    public StockInvoiceTotalsPanel(List objectList, ObjectTemplate objTemplate, String[] fieldNamesToUse, boolean[] fieldNamesToConsider, ObjectFilter objFilter, StockInvoice theInvoice) {
        super(objectList, objTemplate, fieldNamesToUse, fieldNamesToConsider, objFilter);
        this.invoice = theInvoice;
    }

    @Override
    protected Number getCalcPrice(List objects, ObjectTemplate template, String columnName, ObjectFilter filter) {
        if (columnName.equals(StockInvoiceEntryTemplate.COST_INC_GST)) {
            Number totalPrice = super.getCalcPrice(objects, template, columnName, filter);
            double newTotal = totalPrice.doubleValue();
            if (this.invoice != null) {
                newTotal += this.invoice.getAdminCost().doubleValue();
                newTotal += this.invoice.getFreightCost().doubleValue();
                newTotal -= this.invoice.getDiscount().doubleValue();
            }
            return new Price(newTotal, 0.01);
        }
        if (columnName.equals(StockInvoiceEntryTemplate.COST_EX_GST)) {
            Number totalPrice = super.getCalcPrice(objects, template, columnName, filter);
            double newTotal = totalPrice.doubleValue();
            if (this.invoice != null) {
                newTotal += FinanceUtils.removeTax((double)this.invoice.getAdminCost().doubleValue(), (double)this.TAX);
                newTotal += FinanceUtils.removeTax((double)this.invoice.getFreightCost().doubleValue(), (double)this.TAX);
                newTotal -= FinanceUtils.removeTax((double)this.invoice.getDiscount().doubleValue(), (double)this.TAX);
            }
            return new Price(newTotal, 0.01);
        }
        if (columnName.equals(StockInvoiceEntryTemplate.GST)) {
            Number totalPrice = super.getCalcPrice(objects, template, columnName, filter);
            double newTotal = totalPrice.doubleValue();
            if (this.invoice != null) {
                newTotal += FinanceUtils.getTaxValue((double)this.invoice.getAdminCost().doubleValue(), (double)this.TAX);
                newTotal += FinanceUtils.getTaxValue((double)this.invoice.getFreightCost().doubleValue(), (double)this.TAX);
                newTotal -= FinanceUtils.getTaxValue((double)this.invoice.getDiscount().doubleValue(), (double)this.TAX);
            }
            return new Price(newTotal, 0.01);
        }
        return super.getCalcDouble(objects, template, columnName, filter);
    }
}

