/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.gui.GuiHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import officemate.screens.maintainstock.invoice.external.AbstractFileHandler;
import officemate.screens.maintainstock.invoice.external.DefaultInvoiceResolver;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.InvoiceImportException;
import ordermate.integration.invoicing.InvoiceImportResult;
import ordermate.integration.invoicing.alm.ALMReader;
import ordermate.integration.invoicing.alm.invoice.ALMInvoice;
import ordermate.integration.invoicing.alm.invoice.ALMToStockInvoiceConverter;

public class ALMFileHandler
extends AbstractFileHandler {
    @Override
    public FileFilter getFileFilter() {
        return new FileNameExtensionFilter("ALM Data files", "dat");
    }

    @Override
    public List<StockInvoice> readInFile(File file) {
        ALMReader reader = new ALMReader((GuiHandler)new OfficeMateGuiHandler());
        ArrayList<StockInvoice> stockInvoices = new ArrayList<StockInvoice>();
        if (reader.handleFile(file)) {
            List invoices = reader.getInvoices();
            ALMToStockInvoiceConverter converter = new ALMToStockInvoiceConverter((ExternalInvoiceResolver)new DefaultInvoiceResolver(), (GuiHandler)new OfficeMateGuiHandler());
            for (ALMInvoice invoice : invoices) {
                try {
                    StockInvoice convertedInvoice = converter.convertToInvoice(invoice);
                    if (convertedInvoice == null) continue;
                    stockInvoices.add(convertedInvoice);
                    this.addResult(Integer.toString(invoice.getInvoiceHeader().getInvoiceNum()), InvoiceImportResult.SUCCESS);
                }
                catch (InvoiceImportException ex) {
                    this.addResult(ex.getInvoiceNo(), ex.getReason());
                }
                catch (Exception ex) {
                    this.handleDodgyInvoice(invoice, ex);
                }
            }
        } else {
            this.addResult("Unknown", InvoiceImportResult.INVALID_FILE);
        }
        return stockInvoices;
    }

    @Override
    public String getStartingDirectory() {
        return InvoiceIntegrationConfig.getConfigForType((InvoiceIntegrationConfig.InvoiceIntegrationType)InvoiceIntegrationConfig.InvoiceIntegrationType.ALM).getDefaultFilePath();
    }

    @Override
    public boolean doPrequisiteCheck() {
        boolean result;
        InvoiceIntegrationConfig config = InvoiceIntegrationConfig.getConfigForType((InvoiceIntegrationConfig.InvoiceIntegrationType)InvoiceIntegrationConfig.InvoiceIntegrationType.ALM);
        boolean bl = result = config.getStockArea() != null && config.getSupplier() != null && !config.getCustomerNo().isEmpty();
        if (!result) {
            Dialogs.showErrorDialog("Invoice Import", "Invoices can not be imported until the Setup -> Invoice Integration options have been setup. \n\nPlease ensure that you have set a Customer No, Stock Area and Supplier.");
        }
        return result;
    }

    private void handleDodgyInvoice(ALMInvoice invoice, Exception ex) {
        StringBuilder SB = new StringBuilder("An error was encountered when attempting to convert Invoice ");
        SB.append(invoice.getInvoiceHeader().getInvoiceNum()).append(".\n\n").append("If this problem persists please contact Ordermate Support.").append(ex.getMessage());
        Dialogs.showInfoDialog("Cannot Import Invoice", SB.toString());
        OfficeMate.LOG.error("Error converting ALM Invoice.", (Throwable)ex);
    }
}

