/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import java.util.ArrayList;
import java.util.List;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.maintainstock.invoice.external.InvoiceFileHandler;
import ordermate.integration.invoicing.InvoiceImportResult;

public abstract class AbstractFileHandler
implements InvoiceFileHandler {
    private List<ImportResult> importResults = new ArrayList<ImportResult>();

    @Override
    public void showImportResults(boolean onlyShowIfFailures) {
        if (!onlyShowIfFailures || this.hasErrorsInResults()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Errors where encountered while importing Invoices. \n\nThe results are shown below:\n\n");
            sb.append("<html>");
            sb.append("<table border=\"0\">");
            sb.append("<tr>");
            sb.append("<td>Failure Reason</td>");
            sb.append("<td>No Of Invoices Affected</td>");
            sb.append("</tr>");
            for (InvoiceImportResult impResult : InvoiceImportResult.values()) {
                int numOcc = this.getNumEntriesForResult(impResult);
                if (numOcc <= 0) continue;
                sb.append("<tr>");
                sb.append("<td>").append(impResult).append("</td>");
                sb.append("<td>").append(numOcc).append("</td>");
                sb.append("</tr>");
            }
            sb.append("</table>");
            sb.append("</html>");
            Dialogs.showMessageDialog("Import Invoice Results", sb.toString());
        }
    }

    private int getNumEntriesForResult(InvoiceImportResult resultToFind) {
        int result = 0;
        for (ImportResult importResult : this.importResults) {
            if (!importResult.getResult().equals((Object)resultToFind)) continue;
            ++result;
        }
        return result;
    }

    private boolean hasErrorsInResults() {
        for (ImportResult result : this.importResults) {
            if (result.getResult().equals((Object)InvoiceImportResult.SUCCESS)) continue;
            return true;
        }
        return false;
    }

    public void addResult(String invoiceNo, InvoiceImportResult result) {
        this.importResults.add(new ImportResult(invoiceNo, result));
    }

    private class ImportResult {
        private String invoiceNo;
        private InvoiceImportResult result;

        public ImportResult(String invoiceNo, InvoiceImportResult result) {
            this.invoiceNo = invoiceNo;
            this.result = result;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public InvoiceImportResult getResult() {
            return this.result;
        }
    }
}

