/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.templates.Templates;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.maintainstock.invoice.StockInvoiceEditorPanel;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ImportedInvoicePanel
extends JPanel {
    private EventList<StockInvoice> stockInvoices;
    private PersistentObjectTable<StockInvoice> stockInvoiceTable;

    public ImportedInvoicePanel(List<StockInvoice> stockInvoices) {
        super(new BorderLayout());
        this.stockInvoices = GlazedLists.eventList(stockInvoices);
        this.createAndAddStockInvoicesTable();
        this.createAndAddButtonPanel();
    }

    private void createAndAddStockInvoicesTable() {
        this.stockInvoiceTable = new PersistentObjectTable<StockInvoice>(this.stockInvoices, new ColumnTableFormat((ColumnFormat[])new AbstractColumnFormat[]{new PropertyColumnFormat(StockInvoice.Properties.INVOICE_NUMBER), new PropertyColumnFormat(StockInvoice.Properties.ORDER_NUMBER), new PropertyColumnFormat(StockInvoice.Properties.DATE), new PropertyColumnFormat(StockInvoice.Properties.SUPPLIER), new PropertyColumnFormat(StockInvoice.Properties.STOCK_AREA), new PropertyColumnFormat(StockInvoice.Properties.EXPECTED_TOTAL), new AbstractColumnFormat(SystemProperty.getInstance().getBaseTaxLabel() + " Amount", Price.class){

            public Object resolveColumnValue(Object baseObject) {
                StockInvoice item = (StockInvoice)baseObject;
                return item.getTaxAmount();
            }
        }, new AbstractColumnFormat("Total (Ex " + SystemProperty.getInstance().getBaseTaxLabel() + ")", Price.class){

            public Object resolveColumnValue(Object baseObject) {
                StockInvoice item = (StockInvoice)baseObject;
                return item.getTotalCostExTax();
            }
        }, new AbstractColumnFormat("Total (Inc " + SystemProperty.getInstance().getBaseTaxLabel() + ")", Price.class){

            public Object resolveColumnValue(Object baseObject) {
                StockInvoice item = (StockInvoice)baseObject;
                return item.getTotalCost();
            }
        }, new PropertyColumnFormat(StockInvoice.Properties.INVOICE_TYPE)}));
        this.stockInvoiceTable.objectDoubleClicked().connect((Object)this, "doShowInvoice");
        ArrayList<String> ignore = new ArrayList<String>();
        ignore.add(StockInvoice.Properties.INVOICE_NUMBER.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.ORDER_NUMBER.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.DATE.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.SUPPLIER.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.STOCK_AREA.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.INVOICE_TYPE.getUserVisibleLabel());
        ignore.add(StockInvoice.Properties.EXPECTED_TOTAL.getUserVisibleLabel());
        this.stockInvoiceTable.setTotalsBuilder(new TotalsTableModelBuilder(ignore));
        this.add(this.stockInvoiceTable, "Center");
    }

    private void createAndAddButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        JButton addButton = new JButton((Action)((Object)new AddInvoiceAction()));
        addButton.setName("Add Invoice");
        JButton dropButton = new JButton((Action)((Object)new DropInvoiceAction()));
        dropButton.setName("Remove Invoice");
        JButton mergeButton = new JButton((Action)((Object)new MergeInvoiceAction()));
        mergeButton.setName("Merge Invoice");
        JButton editButton = new JButton((Action)((Object)new EditInvoiceAction()));
        mergeButton.setName("Edit Invoice");
        buttonPanel.add(editButton);
        buttonPanel.add(addButton);
        buttonPanel.add(mergeButton);
        buttonPanel.add(dropButton);
        this.stockInvoiceTable.addSelectionDependentAction(editButton.getAction());
        this.stockInvoiceTable.addSelectionDependentAction(addButton.getAction());
        this.stockInvoiceTable.addSelectionDependentAction(mergeButton.getAction());
        this.stockInvoiceTable.addSelectionDependentAction(dropButton.getAction());
        this.add((Component)buttonPanel, "East");
    }

    private void doShowInvoice() {
        StockInvoice invoice = this.stockInvoiceTable.getSelectedObject();
        StockInvoiceEditorPanel editorView = (StockInvoiceEditorPanel)Templates.STOCK_INVOICE.getNewEditPanel(invoice);
        editorView.setAllowMergeInvoiceOption(true);
        if (ObjectEditorDialog.doDialog(OfficeMate.getApplicationFrame(), editorView) == 0) {
            editorView.assignObjectProperties();
            GlazedListUtils.replace(this.stockInvoices, (Object)this.stockInvoiceTable.getSelectedObject(), (Object)this.stockInvoiceTable.getSelectedObject());
        }
    }

    private boolean checkInvoiceNoAlreadyExists() {
        StockInvoice selectedInvoice = this.stockInvoiceTable.getSelectedObject();
        if (selectedInvoice != null) {
            StockInvoice forNumber = StockInvoice.getStockInvoiceForNumber((String)selectedInvoice.getInvoiceNumber());
            return forNumber != null && !forNumber.equals((Object)selectedInvoice);
        }
        return false;
    }

    private void doMergeInvoices(StockInvoice stockInvoice, StockInvoice mergeInvoice) {
        stockInvoice.setAdminCost(stockInvoice.getAdminCost().add(mergeInvoice.getAdminCost()));
        stockInvoice.setDiscount(stockInvoice.getDiscount().add(mergeInvoice.getDiscount()));
        stockInvoice.setExpectedTotal(stockInvoice.getExpectedTotal().add(mergeInvoice.getExpectedTotal()));
        stockInvoice.setFreightCost(stockInvoice.getFreightCost().add(mergeInvoice.getFreightCost()));
        List entries = mergeInvoice.getEntries();
        for (StockInvoiceEntry entry : entries) {
            stockInvoice.addEntry(entry);
        }
        stockInvoice.save();
    }

    private class EditInvoiceAction
    extends BasicAction {
        public EditInvoiceAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            ImportedInvoicePanel.this.doShowInvoice();
        }
    }

    private class MergeInvoiceAction
    extends BasicAction {
        public MergeInvoiceAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/next.png"), "Merge Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            StockInvoice selectedInvoice = (StockInvoice)ImportedInvoicePanel.this.stockInvoiceTable.getSelectedObject();
            StockInvoice mergeToInvoice = StockInvoice.getStockInvoiceForNumber((String)((StockInvoice)ImportedInvoicePanel.this.stockInvoiceTable.getSelectedObject()).getInvoiceNumber());
            ImportedInvoicePanel.this.doMergeInvoices(mergeToInvoice, selectedInvoice);
            GlazedListUtils.delete((EventList)ImportedInvoicePanel.this.stockInvoices, (Object)selectedInvoice);
        }

        public void setEnabled(boolean newValue) {
            boolean toSet = newValue;
            if (newValue) {
                toSet = ImportedInvoicePanel.this.checkInvoiceNoAlreadyExists();
            }
            super.setEnabled(toSet);
        }
    }

    private class DropInvoiceAction
    extends BasicAction {
        public DropInvoiceAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Drop Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            GlazedListUtils.removeInList((EventList)ImportedInvoicePanel.this.stockInvoices, ImportedInvoicePanel.this.stockInvoiceTable.getAllSelectedObjects());
        }
    }

    private class AddInvoiceAction
    extends BasicAction {
        public AddInvoiceAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add Invoice");
        }

        public void actionPerformed(ActionEvent e) {
            for (StockInvoice invoice : ImportedInvoicePanel.this.stockInvoiceTable.getAllSelectedObjects()) {
                invoice.save();
            }
            GlazedListUtils.removeInList((EventList)ImportedInvoicePanel.this.stockInvoices, ImportedInvoicePanel.this.stockInvoiceTable.getAllSelectedObjects());
        }

        public void setEnabled(boolean newValue) {
            boolean toSet = newValue;
            if (newValue) {
                toSet = !ImportedInvoicePanel.this.checkInvoiceNoAlreadyExists();
            }
            super.setEnabled(toSet);
        }
    }
}

