/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import officemate.OfficeMate;
import officemate.screens.maintainstock.invoice.external.ALMFileHandler;
import officemate.screens.maintainstock.invoice.external.InvitboxFileHandler;
import officemate.screens.maintainstock.invoice.external.InvoiceFileHandler;
import officemate.screens.maintainstock.invoice.external.LightYearFileHandler;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockInvoice;

class InvoiceImporter {
    InvoiceFileHandler handler;

    public InvoiceImporter(InvoiceIntegrationConfig.InvoiceIntegrationType type) {
        if (InvoiceIntegrationConfig.InvoiceIntegrationType.ALM.equals((Object)type)) {
            this.handler = new ALMFileHandler();
        } else if (InvoiceIntegrationConfig.InvoiceIntegrationType.InvitBox.equals((Object)type)) {
            this.handler = new InvitboxFileHandler();
        } else if (InvoiceIntegrationConfig.InvoiceIntegrationType.LightYear.equals((Object)type)) {
            this.handler = new LightYearFileHandler();
        } else {
            throw new IllegalArgumentException("Cannot determine an Invoice Handler for type:" + type);
        }
    }

    List<StockInvoice> importInvoices() {
        if (this.handler.doPrequisiteCheck()) {
            ArrayList<StockInvoice> invoices = new ArrayList<StockInvoice>();
            File[] file = this.getFiles(this.handler.getFileFilter(), this.handler.getStartingDirectory());
            if (file != null) {
                for (int i = 0; i < file.length; ++i) {
                    if (file[i] == null || !file[i].exists()) continue;
                    invoices.addAll(this.handler.readInFile(file[i]));
                }
                this.handler.showImportResults(true);
            }
            return invoices;
        }
        return null;
    }

    private File[] getFiles(FileFilter filter, String startingDir) {
        JFileChooser chooser = new JFileChooser(startingDir);
        chooser.setMultiSelectionEnabled(true);
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if (chooser.showOpenDialog(OfficeMate.getApplicationFrame()) == 0) {
            return chooser.getSelectedFiles();
        }
        return null;
    }
}

