/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import officemate.adminkit.dialogs.Dialogs;
import officemate.screens.maintainstock.invoice.external.AbstractFileHandler;
import officemate.screens.maintainstock.invoice.external.DefaultInvoiceResolver;
import ordermate.OrderMate;
import ordermate.database.integration.InvoiceIntegrationConfig;
import ordermate.database.stock.StockInvoice;
import ordermate.integration.invoicing.ExternalInvoiceResolver;
import ordermate.integration.invoicing.lightyear.LightYearCsvIntegration;

public class LightYearFileHandler
extends AbstractFileHandler {
    private FileFilter filter;

    @Override
    public FileFilter getFileFilter() {
        if (this.filter == null) {
            this.filter = new FileNameExtensionFilter("CSV files", "csv");
        }
        return this.filter;
    }

    @Override
    public List<StockInvoice> readInFile(File file) {
        LightYearCsvIntegration integration = new LightYearCsvIntegration((ExternalInvoiceResolver)new DefaultInvoiceResolver());
        try {
            return integration.importCsv(file);
        }
        catch (FileNotFoundException ex) {
            OrderMate.LOG.warn("Cannot find file;" + file, (Throwable)ex);
            Dialogs.showErrorDialog("Invalid file", "The chosen file is missing or corrupt.");
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot import the stock invoice", (Throwable)ex);
            Dialogs.showErrorDialog("Failed Import", "The Stock Invoice could not be imported. See Logs.");
        }
        return Collections.emptyList();
    }

    @Override
    public String getStartingDirectory() {
        return InvoiceIntegrationConfig.getConfigForType((InvoiceIntegrationConfig.InvoiceIntegrationType)InvoiceIntegrationConfig.InvoiceIntegrationType.LightYear).getDefaultFilePath();
    }

    @Override
    public boolean doPrequisiteCheck() {
        InvoiceIntegrationConfig config = InvoiceIntegrationConfig.getConfigForType((InvoiceIntegrationConfig.InvoiceIntegrationType)InvoiceIntegrationConfig.InvoiceIntegrationType.LightYear);
        if (config.getStockArea() == null || !"ACTIVE".equals(config.getStockArea().getSystemState())) {
            Dialogs.showErrorDialog("Invoice Import", "LightYear importing requies an active default StockArea");
            return false;
        }
        return true;
    }
}

