/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.integration.finance.AccountingExportFunction;
import ordermate.integration.finance.AccountingExportManager;
import ordermate.integration.finance.AccountingExportParams;
import ordermate.integration.finance.AccountingExporter;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ManualExportAction
extends BasicAction {
    public Signal<?, ?, ?, ?, ?> retrieveInvoice = Signals.createSignal();
    private Date startDate;
    private Date endDate;
    private List<Integer> invoiceIDs = Collections.EMPTY_LIST;

    public ManualExportAction() {
        super(HtmlUtils.htmlCenter((String)"Manual Export"), (Icon)IconLoader.get((String)"/ordermate/images/left_arrow.png"), "Manually export the selected invoice(s).");
    }

    public void setParameters(Date startDate, Date endDate, List<Integer> invoiceIDs) {
        this.startDate = startDate;
        this.endDate = endDate;
        this.invoiceIDs = invoiceIDs;
    }

    public void actionPerformed(ActionEvent e) {
        this.retrieveInvoice.emit();
        this.export();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void export() {
        this.setEnabled(false);
        AccountingExporter exporter = AccountingExportManager.getInstance().getAccountingIntegrationExporter((GuiHandler)new OfficeMateGuiHandler(), OfficeMate.getInstance().getEventContext());
        try {
            ExportTask exportTask = new ExportTask(exporter);
            ProgressDialog progressDialog = new ProgressDialog((Frame)OfficeMate.getApplicationFrame(), true, "Export Accounting Data", (Runnable)((Object)exportTask));
            progressDialog.start();
            if (exportTask.getResult() == null) {
                Dialogs.showInfoDialog("Manual Export Complete", "Successfully exported data.");
            } else {
                Dialogs.showErrorDialog("Manual Export Failed", "Failed to export data.");
            }
        }
        finally {
            this.setEnabled(true);
        }
    }

    private final class ExportTask
    extends AbstractTask {
        private String result;
        private AccountingExporter exporter;

        public ExportTask(AccountingExporter exporter) {
            this.exporter = exporter;
        }

        public String getName() {
            return "Manual Export of Invoices";
        }

        protected void performTask() throws Exception {
            AccountingExportParams params = new AccountingExportParams(DateTimeUtils.addTime((Date)ManualExportAction.this.startDate, (int)5, (int)-1), DateTimeUtils.addTime((Date)ManualExportAction.this.endDate, (int)5, (int)1), ManualExportAction.this.invoiceIDs);
            try {
                this.result = this.exporter.export(AccountingExportFunction.INVOICES, params);
            }
            catch (Exception ex) {
                Dialogs.showErrorDialog("Manual Export Failed", ex.getMessage());
            }
        }

        protected int getTotalSubTasks() {
            return 0;
        }

        public String getResult() {
            return this.result;
        }
    }
}

