/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import au.com.ordermate.guicore.Refreshable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.templates.Templates;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.TreeFilterPanel;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.SplitTableState;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tree.StockGroupTreeFilterPanel;
import officemate.screens.setup.stock.items.StockItemSearchState;
import officemate.screens.setup.stock.items.StockItemSearcher;
import ordermate.database.stock.StockItem;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class StockResolverPanel
extends JPanel
implements ActionListener {
    private JButton newStockItemButton;
    private JPanel header;
    private JCheckBox groupedCheck;
    private final StockItemSearcher searcher = new StockItemSearcher();
    private PersistentObjectTable<StockItem> mainTable;
    private TreeFilterPanel stockGroupTreePanel;
    private OfficeMateObjectSearch<StockItem> search = new StockItemSearchState(this.searcher);
    private ObjectEditorPanel editorPanel;
    public final Signal okSignal = Signals.createSignal();
    private boolean newItemAdded = false;
    private StockItem prototype;

    StockResolverPanel(StockItem prototype) {
        super(new BorderLayout());
        this.setupComponents();
        this.header = new JPanel(new BorderLayout());
        JCheckBox groupCheck = this.setupGroupCheck();
        this.header.add((Component)groupCheck, "East");
        this.header.add((Component)this.search.getSearchPanel(), "West");
        this.add((Component)this.header, "North");
        this.search.reaquireSearchOptions();
        this.prototype = prototype;
    }

    private void setupComponents() {
        this.mainTable = new PersistentObjectTable<StockItem>(this.search.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Stock Group", StockItem.Properties.STOCK_GROUP), new PropertyColumnFormat("Name", StockItem.Properties.LABEL), new PropertyColumnFormat("Purchase Cost", StockItem.Properties.CURRENT_COST), new PropertyColumnFormat(StockItem.Properties.PURCHASE_QTY), new PropertyColumnFormat(StockItem.Properties.DISPLAY_MEASURE_UNIT_CONTAINER), new PropertyColumnFormat(StockItem.Properties.EXT_ID)}));
        this.mainTable.groupOn("Stock Group", null);
        this.mainTable.objectDoubleClicked().connect((Object)this, "gotDoubleClick");
        this.stockGroupTreePanel = new StockGroupTreeFilterPanel((Refreshable)this.search, this.searcher.getStockGroupFilter());
        SplitTableState<StockItem> splitter = SplitTableState.createHorizontalSplit(this.stockGroupTreePanel, this.mainTable);
        this.add((Component)splitter.getComponent(), "Center");
        JPanel buttonHolder = new JPanel(new FlowLayout(0));
        this.newStockItemButton = new JButton("New Stock Item...");
        this.newStockItemButton.addActionListener(this);
        buttonHolder.add(this.newStockItemButton);
        this.add((Component)buttonHolder, "South");
        this.refresh();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StockResolverPanel.this.search.refresh(new Runnable(){

                    @Override
                    public void run() {
                        StockResolverPanel.this.mainTable.getTable().packAll();
                    }
                });
            }
        });
    }

    private void gotDoubleClick() {
        this.okSignal.emit();
    }

    private JCheckBox setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", true);
        this.groupedCheck.setSelected(true);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StockResolverPanel.this.groupedCheck.isSelected()) {
                    StockResolverPanel.this.mainTable.groupOn("Stock Group", null);
                } else {
                    StockResolverPanel.this.mainTable.groupOn(null, null);
                }
                StockResolverPanel.this.refresh();
            }
        });
        return this.groupedCheck;
    }

    private void addStockItem() {
        StockItem newPrototype = this.prototype.clone();
        for (String barcode : this.prototype.getBarcodes()) {
            newPrototype.addBarcode(barcode);
        }
        this.editorPanel = Templates.STOCK_ITEM.getNewEditPanel(newPrototype);
        boolean okPressed = Dialogs.showOkCancelCustomDialog("New Stock Item", "<html>Use this panel to setup your new stock item</html>", this.editorPanel);
        while (okPressed) {
            if (this.editorPanel.requestSaveAllowed()) {
                this.editorPanel.saveObject();
                this.newItemAdded = true;
                this.okSignal.emit();
                break;
            }
            okPressed = Dialogs.showOkCancelCustomDialog("New Stock Item", "<html>Use this panel to setup your new stock item</html>", this.editorPanel);
        }
    }

    StockItem getSelectedStockItem() {
        if (this.newItemAdded && this.editorPanel != null) {
            return (StockItem)this.editorPanel.getEditedObject();
        }
        return this.mainTable.getSelectedObject();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.newStockItemButton) {
            this.addStockItem();
        }
    }
}

