/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.external;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.templates.Templates;
import ordermate.database.stock.StockSupplier;
import ordermate.gui.FieldPanelBuilder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class StockSupplierResolverPanel
extends JPanel
implements ActionListener {
    Signal<?, ?, ?, ?, ?> okSignal = Signals.createSignal();
    private JButton addButton;
    private JComboBox supplierCombo;
    private DefaultComboBoxModel model;
    private StockSupplier prototype;
    private StockSupplier selectedSupplier;

    StockSupplierResolverPanel(StockSupplier suspectSupplier) {
        this.prototype = suspectSupplier;
        this.setupComponents();
    }

    private void setupComponents() {
        List suppliers = StockSupplier.getSuppliers();
        if (suppliers.size() > 0) {
            this.selectedSupplier = (StockSupplier)suppliers.get(0);
        }
        this.model = new DefaultComboBoxModel<Object>(suppliers.toArray());
        this.supplierCombo = new JComboBox(this.model);
        this.supplierCombo.addActionListener(this);
        this.addButton = new JButton("Add Supplier...");
        this.addButton.addActionListener(this);
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Supplier", (Component)this.supplierCombo);
        builder.addRow("", (Component)this.addButton);
        this.add(builder.getPanel());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.doAddSupplier();
        } else if (e.getSource() == this.supplierCombo) {
            this.selectedSupplier = (StockSupplier)this.supplierCombo.getSelectedItem();
        }
    }

    public StockSupplier getSelectedSupplier() {
        return this.selectedSupplier;
    }

    private void doAddSupplier() {
        StockSupplier supplier = new StockSupplier(this.prototype);
        ObjectEditorPanel editorPanel = Templates.STOCK_SUPPLIER.getNewEditPanel(supplier);
        boolean okPressed = Dialogs.showOkCancelCustomDialog("New Stock Supplier", "<html>Use this panel to setup your new Stock Supplier</html>", editorPanel);
        while (okPressed) {
            if (editorPanel.requestSaveAllowed()) {
                editorPanel.saveObject();
                supplier.save();
                this.selectedSupplier = supplier;
                this.okSignal.emit();
                break;
            }
            okPressed = Dialogs.showOkCancelCustomDialog("New Stock Supplier", "<html>Use this panel to setup your new Stock Supplier</html>", editorPanel);
        }
    }
}

