/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.purchaseorder;

import au.com.ordermate.message.MessageServer;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogHandler;
import officemate.components.actions.OfficematePermissableAction;
import officemate.screens.maintainstock.invoice.purchaseorder.PurchaseOrderMailmanTask;
import ordermate.database.misc.OfficeMateEventLog;
import ordermate.database.stock.StockInvoice;
import ordermate.database.users.PermissionLoader;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class EmailPurchaseOrderAction
extends OfficematePermissableAction {
    public Signal<?, ?, ?, ?, ?> retrieveInvoice = Signals.createSignal();
    private Signal<?, ?, ?, ?, ?> readyToSend = Signals.createSignal();
    private StockInvoice workingInvoice;
    private JPanel bodyPanel;
    private JTextArea textArea;
    private static final int ROWS = 7;
    private static final int COLUMNS = 65;
    private static final String DEFAULT_TEXT_PRE = "Please find purchase order attached.\n\nRegards,\n";
    private static final String DEFAULT_TEXT_POST = ".\n\n(Powered by OrderMate)\n";

    public EmailPurchaseOrderAction() {
        super(HtmlUtils.htmlCenter((String)"Email PO to Supplier"), PermissionLoader.getInstance().load("Email PO to Supplier"), IconLoader.get((String)"/officemate/images/mail_forward.png"), "Email the selected purchase order to a supplier.");
    }

    public void actionPerformed(ActionEvent e) {
        this.retrieveInvoice.emit();
        if (this.workingInvoice == null) {
            Dialogs.showErrorDialog("No invoice selected!", "Please select a Purchase Order to email.");
            return;
        }
        if (!this.isInvoiceAPurchaseOrder()) {
            Dialogs.showErrorDialog("Must select a Purchase Order!", "Only Purchase Orders can be emailed to suppliers. Please select a purchase order.");
        } else if (!this.isEmailConfigured()) {
            Dialogs.showErrorDialog("SMTP not configured!", "Your SMTP settings are not configured to send emails. In order to email a purchase order, you must have these settings configured in E-Mail Settings.");
        } else if (!this.doesSupplierHaveEmail()) {
            Dialogs.showErrorDialog("No email for this supplier!", this.workingInvoice.getSupplier().getName() + " does not have an email address listed. Please add an email address for this supplier.");
        } else {
            boolean okPressed = this.displayEmailDialog();
            if (okPressed) {
                this.handleResult(this.performTask());
            }
            this.setWorkingInvoice(null);
        }
    }

    public void setWorkingInvoice(StockInvoice invoice) {
        this.workingInvoice = invoice;
    }

    private boolean isEmailConfigured() {
        if (NudgeManager.isNudgeConfigured()) {
            return true;
        }
        MessageServer ms = MessageServer.getServer();
        if (!ms.isSmtpServerConfigured()) {
            ms.serversChanged();
        }
        return ms.isSmtpServerConfigured();
    }

    private boolean isInvoiceAPurchaseOrder() {
        return "Purchase Order".equals(this.workingInvoice.getInvoiceType());
    }

    private boolean doesSupplierHaveEmail() {
        String email = this.workingInvoice.getSupplier().getEmail();
        return email != null && !email.isEmpty();
    }

    private boolean displayEmailDialog() {
        String headerText = this.generateHeaderText();
        return Dialogs.getOkCancelDialogBuilder(this.getBodyPanel()).setTitle("Email Purchase Order...").setHtmlHeader(headerText).setOkSignal(this.readyToSend).setIsResizable(false).setHandler(new OkCancelDialogHandler(){

            @Override
            public boolean isOKAllowed() {
                return true;
            }

            @Override
            public boolean isCancelAllowed() {
                return true;
            }
        }).doPack().doShow();
    }

    private JPanel getBodyPanel() {
        if (this.bodyPanel == null) {
            this.bodyPanel = new JPanel(new FlowLayout());
            this.bodyPanel.add(this.getTextArea());
        }
        this.textArea.setText(this.getDefaultBodyText());
        return this.bodyPanel;
    }

    private JScrollPane getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea(7, 65);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setLineWrap(true);
            this.textArea.setFont(UIManager.getFont("Label.font"));
        }
        JScrollPane scrolly = new JScrollPane(this.textArea);
        scrolly.setVerticalScrollBarPolicy(20);
        return scrolly;
    }

    private String getDefaultBodyText() {
        StringBuilder sb = new StringBuilder();
        sb.append(DEFAULT_TEXT_PRE);
        sb.append(OfficeMate.getInstance().getEventContext().getUser().getName());
        sb.append(DEFAULT_TEXT_POST);
        return sb.toString();
    }

    private String generateHeaderText() {
        StringBuilder sbPre = new StringBuilder();
        sbPre.append("Sending Purchase Order ").append(this.workingInvoice.getOrderNumber());
        sbPre.append(" to ").append(this.workingInvoice.getSupplier().getName());
        sbPre.append(" at ").append(this.workingInvoice.getSupplier().getEmail()).append(".");
        StringBuilder sbPost = new StringBuilder();
        sbPost.append(HtmlUtils.boldColor((String)sbPre.toString(), (String)"black"));
        sbPost.append(HtmlUtils.newline((int)2));
        sbPost.append("The purchase order will be attached. Enter email body text below (optional).");
        return HtmlUtils.html((String)sbPost.toString());
    }

    private boolean performTask() {
        PurchaseOrderMailmanTask task = new PurchaseOrderMailmanTask(this.workingInvoice, this.textArea.getText());
        Dialogs.createProgressDialog(task).start();
        return task.getResult();
    }

    private void handleResult(boolean result) {
        if (result) {
            OfficeMateEventLog.getInst().logEmailPurchaseOrder(this.workingInvoice, OfficeMate.getInstance().getEventContext());
            StringBuilder sb = new StringBuilder();
            sb.append("Your purchase order (").append(this.workingInvoice.getOrderNumber());
            sb.append(") has successfully been emailed to ").append(this.workingInvoice.getSupplier().getName());
            sb.append(" at ").append(this.workingInvoice.getSupplier().getEmail()).append(".");
            Dialogs.showMessageDialog("Success!", sb.toString());
        } else {
            Dialogs.showErrorDialog("Failure!", HtmlUtils.html((String)"An unexpected error has occurred and the purchase order has not been emailed.<BR>Please contact OrderMate Tech Support."));
        }
    }
}

