/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.invoice.purchaseorder;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import officemate.screens.maintainstock.invoice.purchaseorder.PurchaseOrderReportCompiler;
import officemate.screens.maintainstock.invoice.purchaseorder.PurchaseOrderSummaryReport;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockSupplier;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.ReportStyles;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class PurchaseOrderReportProvider
extends AbstractReportProvider {
    public static final String PARAM_PO = "PARAM_PO_NO";
    public static final String PARAM_PO_DATE = "PARAM_PO_DATE";
    private final List<StockInvoiceEntry> entriesList;
    private final PurchaseOrderReportCompiler compiler = new PurchaseOrderReportCompiler();
    private final StockSupplier supplier;

    public PurchaseOrderReportProvider(List<StockInvoiceEntry> entries, StockSupplier stockSupplier) {
        this.entriesList = entries;
        this.supplier = stockSupplier;
    }

    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.compileResults(this.entriesList, this.supplier));
    }

    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder reportBuilder = new ReportBuilder((ReportStyles)new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(reportBuilder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.addSupplierInfo(reportBuilder.getReportBuilder());
        reportBuilder.addReportColumn(PurchaseOrderSummaryReport.Properties.PRODUCT_CODE, "Product Code", null);
        reportBuilder.addReportColumn(PurchaseOrderSummaryReport.Properties.STOCK_ITEM, "Stock Item", null);
        reportBuilder.addReportColumn(PurchaseOrderSummaryReport.Properties.QTY_TO_ORDER_DESC, "Quantity", null);
        Internationalization.refreshData();
        String dollarSign = Internationalization.getLiteralFor((String)"DOLLAR_SIGN");
        ReportProperty showCostProperty = ReportProperty.find((ReportGroup)ReportGroup.PurchaseOrder, (String)"Show Cost");
        if (Boolean.TRUE.equals(showCostProperty.getBooleanValue(Boolean.FALSE))) {
            reportBuilder.addReportColumn(PurchaseOrderSummaryReport.Properties.UNIT_COST, "Unit Cost", null);
            reportBuilder.addReportColumn(PurchaseOrderSummaryReport.Properties.COST, "Cost", dollarSign + ".00");
            reportBuilder.setUseGrandTotal(true);
            reportBuilder.addFooterCalculation((AbstractColumn)reportBuilder.getPropertyColumn(PurchaseOrderSummaryReport.Properties.COST), Double.class, DJCalculation.SUM);
        }
        return reportBuilder;
    }

    private void addSupplierInfo(ReportBuilder.SafeReportBuilder builder) {
        Style suppDetailsStyle = new StyleBuilder(true).setFont(new Font(10, "Verdana", false)).setVerticalAlign(VerticalAlign.TOP).build();
        StringBuilder supplierDetails = new StringBuilder("\\n").append("Supplier: ").append(this.supplier.getName()).append("\\n").append("Account No: ").append(this.supplier.getAccountNumber() != null ? this.supplier.getAccountNumber() : "").append("\\n").append("Phone: ").append(this.supplier.getPhone()).append("\\n").append("Fax: ").append(this.supplier.getFax()).append("\\n").append("Email: ").append(this.supplier.getEmail()).append("\\n").append("Purchase Order: ").append(this.getParameters().get(PARAM_PO));
        Date orderDate = (Date)this.getParameters().get(PARAM_PO_DATE);
        if (orderDate != null) {
            supplierDetails.append(" (").append(DateTimeUtils.getLongFormat().format(orderDate)).append(")");
        }
        builder.setTitle("");
        builder.setSubtitleStyle(suppDetailsStyle);
        builder.setSubtitle(supplierDetails.toString());
    }

    protected String getAdditionalFooterText() {
        return null;
    }
}

