/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.preprod;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.ServiceLocator;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.types.QuantityFieldType;
import officemate.components.AbstractObjectEditor;
import officemate.components.search.SingleSearchDialog;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TotalsTableModelBuilder;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.setup.stock.items.StockItemSearchState;
import officemate.screens.setup.stock.items.StockItemSearcher;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usage.PreProdConsumeUsage;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usage.PreProdProduceUsage;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.beansbinding.Validator;

public class PreProdObjectEditor
extends AbstractObjectEditor<PreProdProduceUsage> {
    private final SingleSearchDialog<StockItem> stockItemSearchDialog;
    private final BasicOfficeMateState parentState;
    public static final String STOCK_ITEM_BUTTON_NAME = "stockItem";
    private final EventList<StockArea> stockAreas = GlazedLists.eventList((Collection)StockArea.getStockAreas());
    private final JComboBox areaCombo;
    private final EventList<PreProdConsumeUsage> ingredientUsages = new BasicEventList();
    private final PersistentObjectTable<PreProdConsumeUsage> ingredientsTable;
    private final QuantityFieldPanel quantityFieldPanel;
    private final JButton stockItemButton;
    private StockItem item;
    private boolean isGuiValid;
    private static final String STOCK_ITEM_EMPTY_TEXT = "None";

    public PreProdObjectEditor(BasicOfficeMateState state) {
        this.parentState = state;
        StockItemSearcher searcher = new StockItemSearcher();
        searcher.setMode(StockItemSearcher.Mode.ONLY_WITH_INGREDIENTS);
        searcher.setLimit(200);
        this.stockItemSearchDialog = new SingleSearchDialog<StockItem>(new StockItemSearchState(searcher), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(StockItem.Properties.STOCK_GROUP), new PropertyColumnFormat(StockItem.Properties.LABEL)}), "Stock Item", state.getLargeIcon());
        this.stockItemSearchDialog.getObjectTable().groupOn("Stock Group", new String[0]);
        FieldPanelBuilder builder = new FieldPanelBuilder(new JPanel());
        this.stockItemButton = this.getStockItemButton();
        builder.addRow("Stock Item to produce", (Component)this.stockItemButton);
        this.areaCombo = this.setupComboBox(PreProdProduceUsage.Properties.STOCK_AREA, (ComboBoxModel)new EventComboBoxModel(this.stockAreas), (Validator)new NotEmptyValidator());
        builder.addRow("Stock Area", (Component)this.areaCombo);
        this.quantityFieldPanel = this.createQuantityPanel();
        builder.addRow("Quantity to produce", (Component)this.quantityFieldPanel.getGuiComponent());
        this.ingredientsTable = this.createIngredientsTable();
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "North");
        this.add(this.ingredientsTable, "Center");
        this.refresh();
    }

    private final JButton getStockItemButton() {
        final JButton button = new JButton(STOCK_ITEM_EMPTY_TEXT);
        button.setName(STOCK_ITEM_BUTTON_NAME);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreProdObjectEditor.this.setStockItem((StockItem)PreProdObjectEditor.this.stockItemSearchDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame()));
                PreProdObjectEditor.this.saveObject();
                PreProdProduceUsage usage = (PreProdProduceUsage)PreProdObjectEditor.this.getObject();
                usage.setStockItem(PreProdObjectEditor.this.item);
                PreProdObjectEditor.this.setObject(usage);
                button.setText(PreProdObjectEditor.this.item != null ? PreProdObjectEditor.this.item.getLabel() : PreProdObjectEditor.STOCK_ITEM_EMPTY_TEXT);
                PreProdObjectEditor.this.updateTable();
            }
        });
        return button;
    }

    private void setStockItem(StockItem newItem) {
        this.item = newItem;
        if (this.item != null) {
            this.quantityFieldPanel.setValue(this.item.getPurchaseQty());
        } else {
            this.quantityFieldPanel.setValue(new Quantity(1.0));
        }
    }

    private final QuantityFieldPanel createQuantityPanel() {
        QuantityFieldPanel panel = new QuantityFieldPanel();
        panel.setFieldType(new QuantityFieldType(new Quantity(1.0)));
        panel.addChangeListenerToComponent(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PreProdObjectEditor.this.updateTable();
            }
        });
        return panel;
    }

    public void createObject() {
        PreProdProduceUsage usage = new PreProdProduceUsage();
        usage.setStockArea((StockArea)this.stockAreas.get(0));
        this.stockItemButton.setText(STOCK_ITEM_EMPTY_TEXT);
        this.quantityFieldPanel.setValue(new Quantity(1.0));
        this.setObject(usage);
        this.updateTable();
    }

    @Override
    public void refresh() {
        super.refresh();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.stockAreas, StockArea.getStockAreas());
        this.areaCombo.setSelectedIndex(0);
    }

    private void updateTable() {
        this.saveObject();
        PreProdProduceUsage usage = (PreProdProduceUsage)this.getObject();
        try {
            if (usage.getStockItem() != null && usage.getStockArea() != null) {
                usage = ((PreProdManager)ServiceLocator.locate(PreProdManager.class)).produceItem(usage.getStockArea(), usage.getStockItem(), usage.getRawQuantity(), new EventContext(null, this.parentState.getUser()));
            }
        }
        catch (Exception ex) {
            Dialogs.showErrorDialog("Could not calculate usages", "Could not calculate usages for " + usage.getStockItem());
            OrderMate.LOG.error("Could not calculate stock usages for " + usage.getStockItem(), (Throwable)ex);
        }
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.ingredientUsages, usage.getConsumedUsages());
        this.isGuiValid();
    }

    @Override
    public void setObject(PreProdProduceUsage toEdit) {
        super.setObject(toEdit);
    }

    @Override
    public void saveObject() {
        super.saveObject();
        Quantity qty = this.quantityFieldPanel.getValue();
        PreProdProduceUsage obj = (PreProdProduceUsage)this.getObject();
        obj.setRawQuantity(qty.getRawValue());
    }

    private PersistentObjectTable<PreProdConsumeUsage> createIngredientsTable() {
        PersistentObjectTable<PreProdConsumeUsage> table = new PersistentObjectTable<PreProdConsumeUsage>(this.ingredientUsages, new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Stock Item", PreProdConsumeUsage.Properties.STOCK_ITEM), new PropertyColumnFormat("Quantity", (PropertiedObject.Property)PreProdConsumeUsage.Properties.QUANTITY_USED), new PropertyColumnFormat("Cost", PreProdConsumeUsage.Properties.HISTORICAL_COST)}));
        table.setTotalsBuilder(new TotalsTableModelBuilder("Stock Item", "Quantity"));
        return table;
    }

    @Override
    public boolean isGuiValid() {
        boolean newValue = super.isGuiValid() && this.item != null;
        boolean oldValue = this.isGuiValid;
        this.isGuiValid = newValue;
        if (newValue != oldValue) {
            this.firePropertyChange("guiValid", oldValue, newValue);
        }
        return this.isGuiValid;
    }
}

