/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.preprod;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.ServiceLocator;
import au.com.ordermate.persistence.cache.PersistentObjDescriptor;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.components.EditorDialog;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.actions.AbstractActions;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.SplitTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tree.StockGroupTreeFilterPanel;
import officemate.screens.maintainstock.preprod.PreProdObjectEditor;
import ordermate.OrderMate;
import ordermate.database.searchers.stock.PreProdConsumeUsageSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.usage.PreProdConsumeUsage;
import ordermate.database.stock.usage.PreProdManager;
import ordermate.database.stock.usage.PreProdProduceUsage;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PreprodState
extends AbstractTableState<PreProdConsumeUsage> {
    private final PreProdConsumeUsageSearcher searcher = new PreProdConsumeUsageSearcher();
    private EventList<StockArea> stockAreas = new BasicEventList();
    private EventList<User> users = new BasicEventList();
    private PreProdObjectEditor creatorEditor;

    public PreprodState() {
        super("Pre production", AllPermissions.ACCESS_PRE_PRODUCTION_SCREEN, "Screen for producing stock items from other stock items");
        this.addAction((Action)((Object)new AbstractActions.NewAction(){

            public void actionPerformed(ActionEvent e) {
                PreprodState.this.createNew();
            }
        }));
        this.addSelectionDependentAction((Action)((Object)new AbstractActions.DeleteAction(){

            public void actionPerformed(ActionEvent e) {
                PreprodState.this.delete();
            }
        }));
    }

    @Override
    public boolean supportsNew() {
        return true;
    }

    private void delete() {
        PreProdConsumeUsage usage = (PreProdConsumeUsage)this.getCentralArea().getSelectedObject();
        if (usage != null) {
            try {
                ((PreProdManager)ServiceLocator.locate(PreProdManager.class)).deleteUsageAndRevertStock(usage.getProducedUsage());
                this.refresh();
            }
            catch (Exception ex) {
                Dialogs.showErrorDialog("Could not delete", "Could not delete pre production");
                OrderMate.LOG.error("Could not delete usage : " + usage, (Throwable)ex);
            }
        }
    }

    private void createNew() {
        if (this.creatorEditor == null) {
            this.creatorEditor = new PreProdObjectEditor(this);
        }
        EditorDialog dialog = new EditorDialog(this.creatorEditor);
        this.creatorEditor.createObject();
        if (dialog.doModal()) {
            PreProdProduceUsage usage = (PreProdProduceUsage)this.creatorEditor.getObject();
            try {
                PersistentObjDescriptor descriptor = ((PreProdManager)ServiceLocator.locate(PreProdManager.class)).saveUsageAndUseStock(usage);
                this.refresh();
                PreProdProduceUsage produceUsage = (PreProdProduceUsage)PersistenceManager.getByID((long)descriptor.getID(), PreProdProduceUsage.class);
                Date now = new Date();
                for (PreProdConsumeUsage consumeUsage : produceUsage.getConsumedUsages()) {
                    consumeUsage.setUsageDate(now);
                    PersistenceManager.saveChild((PersistentObject)consumeUsage);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error in preprod, could not produce " + usage, (Throwable)ex);
                Dialogs.showErrorDialog("Could not produce : " + usage.getStockItem(), "An error occurred communication with the server:\n" + ex.getMessage());
            }
        }
    }

    @Override
    protected TableStateCentralArea<PreProdConsumeUsage> createCentralArea() {
        Format produceUsageFormat = new Format(){

            @Override
            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                if (obj != null) {
                    PreProdProduceUsage item = (PreProdProduceUsage)obj;
                    toAppendTo.append(item.getStockItem() + " - " + item.getQuantityUsed().multiply(-1.0));
                }
                return toAppendTo;
            }

            @Override
            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }
        };
        PersistentObjectTable centralTable = new PersistentObjectTable(this.getSearchFactory().getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(PreProdConsumeUsage.Properties.PRODUCED_USAGE, produceUsageFormat), new PropertyColumnFormat(PreProdConsumeUsage.Properties.STOCK_ITEM), new PropertyColumnFormat((PropertiedObject.Property)PreProdConsumeUsage.Properties.QUANTITY_USED), new PropertyColumnFormat("Date", PreProdConsumeUsage.Properties.CREATION_DATE), new PropertyColumnFormat(PreProdConsumeUsage.Properties.USER), new PropertyColumnFormat(PreProdConsumeUsage.Properties.STOCK_AREA), new PropertyColumnFormat("Cost", PreProdConsumeUsage.Properties.HISTORICAL_COST)}));
        StockGroupTreeFilterPanel treePanel = new StockGroupTreeFilterPanel((Refreshable)this.getSearchFactory(), (ISingleValueSearchFilter<Collection<StockGroup>>)this.searcher.getStockGroupFilter());
        SplitTableState<PreProdConsumeUsage> splitter = SplitTableState.createHorizontalSplit(treePanel, centralTable);
        centralTable.groupOn("Produced Usage", "Cost");
        return splitter;
    }

    @Override
    protected Class<PreProdConsumeUsage> getDisplayingType() {
        return PreProdConsumeUsage.class;
    }

    @Override
    protected OfficeMateObjectSearch<PreProdConsumeUsage> createSearchPanelFactory() {
        ObjectPropertySearch<PreProdConsumeUsage> guiSearch = new ObjectPropertySearch<PreProdConsumeUsage>(PreProdConsumeUsage.class, (ObjectQuerySearcher)this.searcher, (EventList)new BasicEventList()){

            @Override
            public void reaquireSearchOptions() {
                OfficeMateAdminGuiUtils.getInstance().refreshList(PreprodState.this.stockAreas, StockArea.getStockAreas());
                OfficeMateAdminGuiUtils.getInstance().refreshList(PreprodState.this.users, User.getUsers());
            }
        };
        RefreshAction refresh = new RefreshAction((Refreshable)guiSearch);
        DateRangeSearchField dateRangeSearchField = new DateRangeSearchField("Created", (IRangedQuerySearchFilter)this.searcher.getCreationDateRangeFilter(), new Date(), (Action)refresh);
        ComboSearchField stockAreaSearchField = new ComboSearchField("Stock Area", this.searcher.getStockAreaFilter(), true, (Action)refresh, this.stockAreas);
        MultiSelectComboSearchField userSearchField = new MultiSelectComboSearchField("User", (Action)refresh, this.users, null, this.searcher.getUserFilter(), new JCheckBoxCellRenderer());
        guiSearch.addSearchField((SearchGuiField)dateRangeSearchField);
        guiSearch.addSearchField((SearchGuiField)stockAreaSearchField);
        guiSearch.addSearchField((SearchGuiField)userSearchField);
        JPanel searchPanel = guiSearch.getSearchPanel();
        searchPanel.removeAll();
        searchPanel.setLayout(new BorderLayout());
        JPanel datePanel = new JPanel();
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref, 3dlu, left:pref");
        datePanel.setLayout((LayoutManager)layout);
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, datePanel);
        formBuilder.append("From:", (Component)dateRangeSearchField.getDateRangePanel().getStartPicker());
        formBuilder.nextLine();
        formBuilder.append("To:", (Component)dateRangeSearchField.getDateRangePanel().getEndPicker());
        JButton goButton = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
        goButton.setToolTipText("Go");
        goButton.addActionListener((ActionListener)refresh);
        CellConstraints cc = new CellConstraints();
        formBuilder.add((Component)goButton, cc.xywh(5, 1, 1, 3));
        FieldPanelBuilder builder = new FieldPanelBuilder(0);
        builder.addRow("Area:", (Component)stockAreaSearchField.getComboBox());
        builder.addRow("User:", (Component)userSearchField.getComboBox());
        searchPanel.add((Component)formBuilder.getPanel(), "East");
        searchPanel.add((Component)builder.getPanel(), "West");
        return guiSearch;
    }
}

