/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.stocktake;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import officemate.components.search.ObjectPropertySearch;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.searchers.stock.stocktake.StockTakeSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import ordermate.gui.FieldPanelBuilder;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StockTakeEntrySearch
extends ObjectPropertySearch<StockTakeEntry>
implements ActionListener {
    private final RefreshAction refresh = new RefreshAction((Refreshable)this);
    private EventList<StockTake> stocktakes = new BasicEventList();
    private EventList<StockArea> allStockAreas = GlazedLists.eventList((Collection)StockArea.getStockAreas());
    private ComboSearchField stockAreaCombo;
    private ComboSearchField stockTakeCombo;
    private StockTakeSearcher searcher;
    private JComboBox filterCombo;
    private JComboBox aggregateCombo;
    private JPanel extraComponentHolder;
    public Signal aggregationUpdated = Signals.createSignal();

    public StockTakeEntrySearch() {
        super(StockTakeEntry.class);
        this.useSearchRefreshStrategy();
        this.searcher = new StockTakeSearcher();
        this.setSystemStateFilterActive(true);
        this.stocktakes.addAll((Collection)PersistenceManager.getObjectList(StockTake.class, (String)Query.select(StockTake.class).active(StockTake.class).orderByDesc(StockTake.Properties.END_DATE).toString(), null));
        this.stockTakeCombo = new ComboSearchField("StockTake", this.searcher.getStockTakeSearch(), false, (Action)this.refresh, this.stocktakes);
        if (this.stocktakes.size() > 0) {
            this.stockTakeCombo.setSelectedObject(this.stocktakes.get(0));
        }
        ComponentUtils.setupComboBox((JComboBox)this.stockTakeCombo.getComboBox());
        this.addSearchField((SearchGuiField)this.stockTakeCombo);
        this.stockAreaCombo = new ComboSearchField("Stock Area", this.searcher.getStockAreaSearch(), true, (Action)this.refresh, this.allStockAreas);
        this.addSearchField((SearchGuiField)this.stockAreaCombo);
        ComponentUtils.setupComboBox((JComboBox)this.stockAreaCombo.getComboBox());
        this.stockAreaCombo.setAnyHolder("All");
        DefaultComboBoxModel<StockTakeFilter> boxModel = new DefaultComboBoxModel<StockTakeFilter>(StockTakeFilter.values());
        this.filterCombo = new JComboBox<StockTakeFilter>(boxModel);
        ComponentUtils.setupComboBox((JComboBox)this.filterCombo);
        this.filterCombo.setEditable(false);
        this.filterCombo.addActionListener(this);
        this.filterCombo.setName("filterCombo");
        DefaultComboBoxModel<StockTakeAggregateType> aggyModel = new DefaultComboBoxModel<StockTakeAggregateType>(StockTakeAggregateType.values());
        this.aggregateCombo = new JComboBox<StockTakeAggregateType>(aggyModel);
        ComponentUtils.setupComboBox((JComboBox)this.aggregateCombo);
        this.aggregateCombo.setName("agg-combo");
        this.aggregateCombo.addActionListener(this);
        if (this.allStockAreas.size() > 0) {
            this.stockAreaCombo.setSelectedObject(this.allStockAreas.get(0));
            this.stockAreaCombo.setDefaultValueIndex(1);
            this.searcher.getStockAreaSearch().setSearchValue(this.allStockAreas.get(0));
        }
        if (this.stocktakes.size() > 0) {
            this.searcher.getStockTakeSearch().setSearchValue(this.stocktakes.get(0));
        }
    }

    @Override
    public JPanel createSearchPanel() {
        JPanel superPanel = super.createSearchPanel();
        this.extraComponentHolder = new JPanel(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        builder.addRow("Filter By:", (Component)this.filterCombo);
        builder.addRow("Aggregate To:", (Component)this.aggregateCombo);
        this.extraComponentHolder.add(builder.getPanel());
        superPanel.add((Component)this.extraComponentHolder, "East");
        return superPanel;
    }

    public JPanel getExtraComponentPanel() {
        return this.extraComponentHolder;
    }

    @Override
    protected ObjectQuerySearcher<StockTakeEntry> getPropertySearcher() {
        return this.searcher;
    }

    @Override
    protected ObjectQuerySearcher<StockTakeEntry> constructPropertySearcher() {
        return this.searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reaquireSearchOptions() {
        super.reaquireSearchOptions();
        StockArea area = null;
        try {
            this.allStockAreas.getReadWriteLock().writeLock().lock();
            if (this.stockAreaCombo.getSelectedObject() instanceof StockArea) {
                area = (StockArea)this.stockAreaCombo.getSelectedObject();
            }
            this.allStockAreas.clear();
            this.allStockAreas.addAll((Collection)StockArea.getStockAreas());
        }
        finally {
            this.allStockAreas.getReadWriteLock().writeLock().unlock();
        }
        StockTake currentStocktake = (StockTake)this.stockTakeCombo.getSelectedObject();
        List allStocktakes = PersistenceManager.getObjectList(StockTake.class, (String)Query.select(StockTake.class).active(StockTake.class).orderByDesc(StockTake.Properties.END_DATE).toString(), null);
        try {
            this.stocktakes.getReadWriteLock().writeLock().lock();
            this.stocktakes.clear();
            this.stocktakes.addAll((Collection)allStocktakes);
        }
        finally {
            this.stocktakes.getReadWriteLock().writeLock().unlock();
        }
        if (area != null && !area.equals(this.stockAreaCombo.getSelectedObject())) {
            this.stockAreaCombo.setSelectedObject((Object)area);
        }
        if (currentStocktake != null && (!currentStocktake.equals(this.stockTakeCombo.getSelectedObject()) || currentStocktake.hasChanged())) {
            if (currentStocktake.equals(this.stockTakeCombo.getSelectedObject())) {
                this.stockTakeCombo.setSelectedObject(null);
            }
            this.stockTakeCombo.setSelectedObject((Object)currentStocktake);
        }
    }

    public boolean isLiveSelected() {
        StockTake selected = (StockTake)this.stockTakeCombo.getSelectedObject();
        return selected != null && selected.isLive();
    }

    public StockTake getSelectedStockTake() {
        return (StockTake)this.stockTakeCombo.getSelectedObject();
    }

    public StockArea getSelectedStockArea() {
        return (StockArea)this.stockAreaCombo.getSelectedObject();
    }

    public void setSelectedStocktake(final StockTake stocktake) {
        if (stocktake != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StockTakeEntrySearch.this.stockTakeCombo.setSelectedObject((Object)stocktake);
                    StockTakeEntrySearch.this.refresh();
                }
            });
        }
    }

    public ISingleValueSearchFilter<Collection<StockGroup>> getStockGroupSearch() {
        return this.searcher.getStockGroupSearch();
    }

    public void selectFirstStocktake() {
        this.setSelectedStocktake((StockTake)this.stocktakes.get(0));
    }

    private void updateFilter() {
        StockTakeFilter filter = (StockTakeFilter)((Object)this.filterCombo.getSelectedItem());
        if (filter != null) {
            this.searcher.getRecordedSearch().setSearchValue((Object)(filter == StockTakeFilter.Recorded ? Boolean.TRUE : null));
            this.searcher.getNotRecordedSearch().setSearchValue((Object)(filter == StockTakeFilter.NotRecorded ? Boolean.TRUE : null));
            this.searcher.getVarianceSearch().setSearchValue((Object)(filter == StockTakeFilter.Variance ? Boolean.TRUE : null));
            this.refresh();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.filterCombo) {
            this.updateFilter();
        } else if (source == this.aggregateCombo) {
            this.searcher.aggregateBy((StockTakeAggregateType)this.aggregateCombo.getSelectedItem());
            this.aggregationUpdated.emit();
            this.refresh();
        }
    }

    public boolean isAggregated() {
        return !StockTakeAggregateType.None.equals((Object)this.getAggregatedType());
    }

    public StockTakeAggregateType getAggregatedType() {
        return (StockTakeAggregateType)this.aggregateCombo.getSelectedItem();
    }

    private static enum StockTakeFilter {
        ShowAll("Show All"),
        Recorded("Recorded Only"),
        NotRecorded("Not Recorded Only"),
        Variance("Variance Only");

        private String label;

        private StockTakeFilter(String yourLabel) {
            this.label = yourLabel;
        }

        public String toString() {
            return this.label;
        }
    }
}

