/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.suggested;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.GuiUtils;
import au.com.ordermate.util.Price;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.AdminDialog;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.StockItemSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.screens.ObjectManagerI;
import officemate.screens.maintainstock.suggested.SuggestedOrderingTableModel;
import ordermate.database.config.Quantity;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockParLevel;
import ordermate.database.stock.StockSupplier;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.modify.security.StandardSecurityDecorator;

public class SuggestedOrderingReportState
extends BasicOfficeMateState {
    public static final int ROUND_NONE = 0;
    public static final int ROUND_UNIT = 1;
    public static final int ROUND_OUTER = 2;
    static final String DB_ITEM_ID = "stock_item.ID";
    static final String DB_ITEM_NAME = "stock_item.Name";
    static final String DB_ITEM_QUANTITY = "stock_item.Quantity";
    static final String DB_ITEM_PRODUCT_CODE = "stock_item_suppliers.ProductCode";
    static final String DB_ITEM_DISPLAY_UNIT_CONTAINER = "stock_item.fk_display_measure_unit_container";
    static final String DB_ITEM_INGRED_MEASURE = "stock_item.IngredientMeasureUnit";
    static final String DB_SUPPLIER_NAME = "stock_supplier.Name";
    static final String DB_ITEM_OUTER_NAME = "stock_item.OuterName";
    static final String DB_ITEM_OUTER_QUANTITY = "stock_item.OuterQuantity";
    static final String DB_GROUP_NAME = "stock_group.Name";
    static final String DB_SOH_QTY = "SOHQuantity";
    static final String DB_SUGGESTED_MIN = "stock_item_par_level.suggested_min";
    static final String DB_SUGGESTED_MAX = "stock_item_par_level.suggested_max";
    static final String DB_SUGGESTED_ORDER_FORMULA = "SUM(IF(stock_on_hand.Quantity < stock_item_par_level.suggested_min, stock_item_par_level.suggested_max - stock_on_hand.Quantity, 0))/ COUNT(Distinct stock_supplier.ID)";
    static final String DB_SUGGESTED_ORDER = "SuggestedOrder";
    static final int MONTH_RANGE = 1;
    private JPanel innerPanel;
    private JPanel northPanel;
    private JPanel northEastPanel;
    private JPanel northWestPanel;
    private JPanel tablePanel;
    private JPanel eastPanel;
    private JSplitPane splitter;
    private StockGroupTreePanel treePanel = null;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private SelectQuery query;
    private QueryTable table;
    private SuggestedOrderingTableModel tableModel;
    private List<StockArea> selectedStockAreas = new ArrayList<StockArea>();
    private JComboBox suppliersCombo;
    private JCheckBox showAllCheck;
    private JComboBox roundModeCombo;
    private JButton areaButton;
    private AdminDialog selectAreaDialog;
    private JComponent createPurchaseOrderButton;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;
    private JComboBox parLevelsCombo;

    public SuggestedOrderingReportState() {
        super("Suggested Ordering", AllPermissions.ACCESS_SUGGESTED_ORDER_SCREEN, "View suggested ordering, and generate purchase orders");
        this.innerPanel = new JPanel(new BorderLayout());
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Suggested Ordering Report screen...");
        if (!StockArea.stockAreasExist() || !StockItemQueries.stockItemsExist()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To view the Suggested Ordering Report, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't view Suggested Ordering Report!", 2);
            if (this.alreadySetup) {
                this.changeButtonStates(false);
                this.areaButton.setEnabled(false);
                this.suppliersCombo.setEnabled(false);
                this.roundModeCombo.setEnabled(false);
                this.showAllCheck.setEnabled(false);
                this.parLevelsCombo.setEnabled(false);
            }
        } else if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new SuggestedOrderingSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.changeButtonStates(true);
            this.areaButton.setEnabled(true);
            this.suppliersCombo.setEnabled(true);
            this.roundModeCombo.setEnabled(true);
            this.showAllCheck.setEnabled(true);
            this.parLevelsCombo.setEnabled(true);
            this.refresh();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    private void changeButtonStates(boolean isEnabled) {
        this.toggleDefaultAction(this.getRefreshAction(), isEnabled);
        this.toggleDefaultAction(this.getPrintAction(), isEnabled);
        this.toggleDefaultAction(this.getSearchAction(), isEnabled);
    }

    @Override
    protected void onEnd() {
    }

    @Override
    public boolean supportsSearch() {
        return false;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    private void setupGUI() {
        FieldPanelBuilder comboBuilder = new FieldPanelBuilder(0, 3);
        comboBuilder.addRow("Supplier:", (Component)this.getSuppliersCombo());
        comboBuilder.addRow("Area:", this.getAreasSelector());
        comboBuilder.addRow("Par Level:", (Component)this.getParLevelCombo());
        comboBuilder.addRow("Round up:", this.getRoundingSelector());
        comboBuilder.getPanel().setAlignmentY(0.0f);
        this.showAllCheck = new JCheckBox("Show All", false);
        this.showAllCheck.addActionListener(new RefreshActionListener());
        this.groupedCheck = new JCheckBox("Group Results", this.groupResults);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuggestedOrderingReportState.this.groupResults = SuggestedOrderingReportState.this.groupedCheck.isSelected();
                SuggestedOrderingReportState.this.refresh();
            }
        });
        FieldPanelBuilder checkBuilder = new FieldPanelBuilder();
        checkBuilder.addRow("", (Component)this.groupedCheck);
        checkBuilder.addRow("", (Component)this.showAllCheck);
        checkBuilder.getPanel().setAlignmentY(0.0f);
        this.northPanel = new JPanel(new BorderLayout());
        this.northEastPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel();
        this.northWestPanel.setLayout(new BoxLayout(this.northWestPanel, 0));
        this.northPanel.add((Component)this.northEastPanel, "East");
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.northWestPanel.add(comboBuilder.getPanel());
        this.northWestPanel.add(Box.createHorizontalStrut(30));
        this.northWestPanel.add(checkBuilder.getPanel());
        this.northEastPanel.add(this.getNewOrderSelector(), "Center");
        this.splitter = new JSplitPane();
        this.innerPanel.add((Component)this.splitter, "Center");
        this.eastPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.eastPanel.add((Component)this.tablePanel, "Center");
        this.eastPanel.add((Component)addRemoveWrapper, "East");
        this.splitter.setRightComponent(this.eastPanel);
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    public void createPurchaseOrder() {
        StockInvoice order = new StockInvoice();
        StockControlProperty props = StockControlProperty.getInstance();
        String newOrderNumber = props.getOrderNumberPrefix();
        if (newOrderNumber == null) {
            newOrderNumber = "";
        }
        newOrderNumber = newOrderNumber + props.getNextOrderNumber();
        props.incrementNextOrderNumber();
        order.setOrderNumber(newOrderNumber);
        order.setInvoiceType("Purchase Order");
        order.setSupplier(this.getCurrentStockSupplier());
        order.setStockArea(this.selectedStockAreas.get(0));
        int suggestedCol = this.tableModel.getColumnForDBName(DB_SUGGESTED_ORDER);
        int numRows = this.tableModel.getRowCount();
        for (int i = 0; i < numRows; ++i) {
            Long itemID = this.tableModel.getID(i);
            Quantity suggestedQty = (Quantity)this.tableModel.getValueAt(i, suggestedCol);
            if (!(suggestedQty.getRawValue() > 0.0) || itemID == null) continue;
            StockInvoiceEntry entry = new StockInvoiceEntry();
            StockItem item = (StockItem)PersistenceManager.getByID((long)itemID, StockItem.class);
            double numReceived = suggestedQty.getRawValue() / item.getPurchaseQty().getRawValue();
            double cost = numReceived * item.getCurrentReplacementCost().doubleValue();
            entry.setStockItem(item);
            entry.setNumReceived(numReceived);
            entry.setBonusReceived(0.0);
            entry.setPricePaid(new Price(cost));
            entry.setTaxIncluded(item.isTaxIncluded());
            order.addEntry(entry);
        }
        this.editPurchaseOrder(order);
    }

    private void editPurchaseOrder(StockInvoice purchaseOrder) {
        if (!(StockSupplier.stockSuppliersExist() && StockArea.stockAreasExist() && StockItemQueries.stockItemsExist())) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To edit a purchase order, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item \n    - Stock Supplier", "Can't edit invoice!", 2);
            return;
        }
        ObjectTemplate invoiceTemplate = Templates.STOCK_INVOICE;
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(invoiceTemplate);
        changeRecorder.snapshot(purchaseOrder);
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Editing Purchase Order:  " + invoiceTemplate.getObjectText(purchaseOrder));
        ObjectEditorPanel editorView = invoiceTemplate.getNewEditPanel(purchaseOrder);
        int result = ObjectEditorDialog.doDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), editorView, "Edit Purchase Order", false);
        if (result == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockInvoice((User)this.getUser(), (StockInvoice)purchaseOrder, changeRecorder.getChanges(purchaseOrder));
            StockControlProperty.getInstance().save();
            this.refresh();
        } else if (result == 2) {
            // empty if block
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    public JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private void refreshAreas() {
        String menuTitle = this.selectedStockAreas.size() == 0 ? "(None selected)" : (this.selectedStockAreas.size() == 1 ? this.selectedStockAreas.get(0).toString() : "(" + this.selectedStockAreas.size() + " selected)");
        this.areaButton.setText(menuTitle);
    }

    private Component getRoundingSelector() {
        String[] roundingOptions = new String[]{"None", "Unit", "Outer"};
        this.roundModeCombo = new JComboBox<String>(roundingOptions);
        this.roundModeCombo.setName("Round Up");
        ComponentUtils.setupComboBox((JComboBox)this.roundModeCombo);
        this.roundModeCombo.setPreferredSize(new Dimension(80, 20));
        this.roundModeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuggestedOrderingReportState.this.tableModel.setRoundUpMode(SuggestedOrderingReportState.this.roundModeCombo.getSelectedIndex());
                SuggestedOrderingReportState.this.refresh();
            }
        });
        return this.roundModeCombo;
    }

    private Component getNewOrderSelector() {
        JButton actualCreatePurchaseOrderButton = new JButton("Create Purchase Order");
        actualCreatePurchaseOrderButton.setName("Create Purchase Order");
        actualCreatePurchaseOrderButton.setToolTipText("Generates a Purchase Order from the suggested order report");
        actualCreatePurchaseOrderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuggestedOrderingReportState.this.createPurchaseOrder();
            }
        });
        this.createPurchaseOrderButton = new StandardSecurityDecorator((JComponent)actualCreatePurchaseOrderButton, AllPermissions.CREATE_PURCHASE_ORDER);
        return this.createPurchaseOrderButton;
    }

    private Component getAreasSelector() {
        this.selectAreaDialog = new AreaDialog();
        this.areaButton = new JButton();
        this.areaButton.setName("Area");
        this.areaButton.setPreferredSize(new Dimension(160, 25));
        this.areaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SuggestedOrderingReportState.this.selectAreaDialog.start();
                SuggestedOrderingReportState.this.refresh();
            }
        });
        return this.areaButton;
    }

    private GroupedTable getNewGroupedTable() {
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), "Group", new String[0]);
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        return this.groupedTable;
    }

    private JComboBox getSuppliersCombo() {
        this.suppliersCombo = new JComboBox<Object>(StockSupplier.getSuppliers().toArray());
        this.suppliersCombo.setName("Supplier");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.suppliersCombo);
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.suppliersCombo.getModel();
        model.insertElementAt("(All)", 0);
        this.suppliersCombo.setSelectedIndex(0);
        this.suppliersCombo.addActionListener(new RefreshActionListener());
        return this.suppliersCombo;
    }

    private JComboBox getParLevelCombo() {
        this.parLevelsCombo = new JComboBox<Object>(StockParLevel.getAllParLevels().toArray());
        this.parLevelsCombo.setName("ParLevel");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.parLevelsCombo);
        this.parLevelsCombo.addActionListener(new RefreshActionListener());
        return this.parLevelsCombo;
    }

    private void setupTree() {
        this.treePanel = new StockGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void addWheresToQuery() {
        this.query.clearHaving();
        this.query.clearWhere();
        this.query.addWhere(SQL.join((String)"stock_on_hand", (String)"stock_item"));
        this.query.addWhere(SQL.join((String)"stock_item_suppliers", (String)"stock_item"));
        this.query.addWhere(SQL.join((String)"stock_item_suppliers", (String)"stock_supplier"));
        this.query.addWhere(SQL.join((String)"stock_item", (String)"stock_group"));
        this.query.addWhere(SQL.join((String)"stock_item_par_level", (String)"stock_item"));
        this.query.addWhere(SQL.isActive((String)"stock_item"));
        this.query.addWhere(SQL.isActive((String)"stock_on_hand"));
        this.query.addWhere("stock_on_hand.StockAllowed = 1");
    }

    private void setupTable() {
        this.query = SQL.createQuery((String[])new String[]{"stock_item", "stock_item_suppliers", "stock_on_hand", "stock_supplier", "stock_group", "stock_item_par_level"});
        this.query.addSelectValue(DB_ITEM_ID);
        this.query.addSelectValue(DB_ITEM_NAME);
        this.query.addSelectValue(DB_GROUP_NAME);
        this.query.addSelectValue(DB_ITEM_PRODUCT_CODE);
        this.query.addSelectValue(DB_ITEM_DISPLAY_UNIT_CONTAINER);
        this.query.addSelectValue(DB_ITEM_INGRED_MEASURE);
        this.query.addSelectValue(DB_SUPPLIER_NAME);
        this.query.addSelectValue("SUM(stock_on_hand.quantity) / COUNT(Distinct stock_supplier.ID) AS SOHQuantity");
        this.query.addSelectValue(DB_SUGGESTED_MIN);
        this.query.addSelectValue(DB_SUGGESTED_MAX);
        this.query.addSelectValue(DB_ITEM_QUANTITY);
        this.query.addSelectValue("SUM(IF(stock_on_hand.Quantity < stock_item_par_level.suggested_min, stock_item_par_level.suggested_max - stock_on_hand.Quantity, 0))/ COUNT(Distinct stock_supplier.ID) AS SuggestedOrder");
        this.query.addSelectValue(DB_ITEM_OUTER_NAME);
        this.query.addSelectValue(DB_ITEM_OUTER_QUANTITY);
        this.query.addGroupBy(DB_ITEM_ID);
        this.query.addOrderBy(DB_GROUP_NAME, true);
        this.query.addOrderBy(DB_ITEM_NAME, true);
        this.addWheresToQuery();
        String[] dbColumns = new String[]{DB_GROUP_NAME, DB_ITEM_NAME, DB_ITEM_QUANTITY, DB_SOH_QTY, DB_SUGGESTED_ORDER, DB_SUPPLIER_NAME, DB_ITEM_PRODUCT_CODE};
        String[] displayColumns = new String[]{"Group", "Name", "Unit Qty", "Qty On Hand", "Suggested Order", "Supplier", "Product Code"};
        this.tableModel = new SuggestedOrderingTableModel(this.query, GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), DB_ITEM_ID, dbColumns, displayColumns);
        this.tableModel.setRoundUpMode(this.roundModeCombo.getSelectedIndex());
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.splitter.setDividerLocation(160);
    }

    private void updateQuery(List areas, StockSupplier supplier, StockGroup group, boolean showAll, StockParLevel parLevel) {
        this.addWheresToQuery();
        String[] conditions = new String[areas.size() + 1];
        String[] parLevelConditions = new String[areas.size() + 1];
        int numAreas = areas.size();
        conditions[0] = "0";
        parLevelConditions[0] = "0";
        if (numAreas > 0) {
            for (int i = 0; i < numAreas; ++i) {
                StockArea area = (StockArea)areas.get(i);
                conditions[i + 1] = "stock_on_hand.FK_stock_area = " + area.getID();
                parLevelConditions[i + 1] = "stock_item_par_level.FK_stock_area = " + area.getID();
            }
        }
        this.query.addWhereOr(conditions);
        this.query.addWhereOr(parLevelConditions);
        if (!showAll) {
            this.query.addHaving("SuggestedOrder > 0");
        }
        if (supplier != null) {
            this.query.addWhere("stock_supplier.ID = " + supplier.getID());
        }
        if (parLevel != null) {
            this.query.addWhere("stock_item_par_level.FK_stock_par_level = " + parLevel.getID());
        }
        this.query.addWhere("stock_item_par_level.fk_stock_area = stock_on_hand.fk_stock_area");
        if (group != null) {
            List allChildren = group.getRecursiveSubGroups();
            conditions = new String[allChildren.size() + 1];
            conditions[0] = "stock_item.FK_stock_group = " + group.getID();
            for (int i = 0; i < allChildren.size(); ++i) {
                StockGroup child = (StockGroup)allChildren.get(i);
                conditions[i + 1] = "stock_item.FK_stock_group = " + child.getID();
            }
            this.query.addWhereOr(conditions);
        }
        if (this.groupResults) {
            this.query.clearOrderBy();
            this.query.addOrderBy(DB_GROUP_NAME);
            this.query.addOrderBy(DB_ITEM_NAME);
        }
        this.table.updateModel();
        this.tablePanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.tablePanel.remove(this.groupedTable.getScroller());
        }
        if (this.groupResults) {
            this.tablePanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.tablePanel.add((Component)this.table.getScroller(), "Center");
        }
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        Object selGroup = this.treePanel.getSelectedObject();
        this.treePanel.refresh();
        this.treePanel.getTree().setSelectedObject(selGroup);
        this.refreshAreas();
        Object comboSelected = this.suppliersCombo.getSelectedItem();
        this.suppliersCombo.setModel(new DefaultComboBoxModel<Object>(StockSupplier.getSuppliers().toArray()));
        this.suppliersCombo.insertItemAt("(All)", 0);
        this.suppliersCombo.setSelectedItem(comboSelected);
        this.createPurchaseOrderButton.setEnabled(this.suppliersCombo.getSelectedIndex() > 0 && this.selectedStockAreas.size() != 0);
        Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, this.groupResults ? this.groupedTable : null);
        int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, this.groupResults ? this.groupedTable : null);
        this.updateQuery(this.selectedStockAreas, this.getCurrentStockSupplier(), this.getCurrentStockGroup(), this.showAllCheck.isSelected(), this.getCurrentStockParLevel());
        OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, this.groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
        this.updatesAllowed = true;
    }

    private StockGroup getCurrentStockGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof StockGroup ? (StockGroup)obj : null;
    }

    private StockSupplier getCurrentStockSupplier() {
        Object obj = this.suppliersCombo.getSelectedItem();
        return obj instanceof StockSupplier ? (StockSupplier)obj : null;
    }

    private StockParLevel getCurrentStockParLevel() {
        Object obj = this.parLevelsCombo.getSelectedItem();
        return obj instanceof StockParLevel ? (StockParLevel)obj : null;
    }

    @Override
    public void doSearchAction() {
        StockItemSearchPanel searchPanel = new StockItemSearchPanel();
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Stock Item...");
        if (id != null) {
            JScrollPane scrollerToUse;
            Object tableToUse;
            int tableRow;
            this.treePanel.getTree().setSelectedObject(null);
            int originalRow = this.table.getQueryTableModel().getRow(id);
            if (originalRow == -1) {
                JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "This report does not contain the requested item. ", "Can't find item", 1);
                return;
            }
            if (this.groupResults) {
                tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(originalRow);
                this.groupedTable.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.groupedTable;
                scrollerToUse = this.groupedTable.getScroller();
            } else {
                tableRow = originalRow;
                this.table.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.table;
                scrollerToUse = this.table.getScroller();
            }
            GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)tableToUse, (int)tableRow);
            ((JComponent)tableToUse).revalidate();
            ((Component)tableToUse).repaint();
        }
    }

    @Override
    public void doPrintAction() {
        StockGroup group = this.getCurrentStockGroup();
        StockSupplier supplier = this.getCurrentStockSupplier();
        String groupString = group != null ? " Group: " + group.toString() : "";
        String areaString = "";
        for (int i = 0; i < this.selectedStockAreas.size(); ++i) {
            areaString = i == 0 ? " Area: " : areaString + ", ";
            StockArea area = this.selectedStockAreas.get(i);
            areaString = areaString + area.getLabel();
        }
        String supplierString = supplier != null ? " Supplier: " + supplier.toString() : "";
        String title = "Suggested Ordering (" + new DateDMY(System.currentTimeMillis()) + ")";
        Printing.printJTableReport(this.getActiveTable(), title, groupString + areaString + supplierString, 8, null);
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.updatesAllowed) {
            StockGroup group = null;
            if (obj instanceof StockGroup) {
                group = (StockGroup)obj;
            }
            this.updateQuery(this.selectedStockAreas, this.getCurrentStockSupplier(), group, this.showAllCheck.isSelected(), this.getCurrentStockParLevel());
        }
    }

    private class AreaDialog
    extends AdminDialog {
        private JPanel areasPanel;
        private Map<StockArea, JCheckBox> areasMap;
        private List areas;
        private FieldPanelBuilder areasBuilder;

        public AreaDialog() {
            super(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Choose Areas...", true);
            this.areasPanel = new JPanel();
            this.areasBuilder = new FieldPanelBuilder();
            this.areasMap = new HashMap<StockArea, JCheckBox>();
            super.setMainComponent(this.areasPanel);
        }

        @Override
        public boolean start() {
            this.areasPanel.removeAll();
            this.areasBuilder = new FieldPanelBuilder();
            this.areas = StockArea.getStockAreas();
            for (StockArea area : this.areas) {
                JCheckBox check = new JCheckBox(area.getName(), SuggestedOrderingReportState.this.selectedStockAreas.contains(area));
                this.areasBuilder.addRow("", (Component)check);
                this.areasMap.put(area, check);
            }
            this.areasPanel.add(this.areasBuilder.getPanel());
            return super.start();
        }

        @Override
        public void gotOk() {
            SuggestedOrderingReportState.this.selectedStockAreas = new ArrayList();
            for (StockArea area : this.areas) {
                if (this.areasMap.get(area).isSelected()) {
                    SuggestedOrderingReportState.this.selectedStockAreas.add(area);
                    continue;
                }
                SuggestedOrderingReportState.this.selectedStockAreas.remove(area);
            }
            this.dispose();
        }

        @Override
        public void gotCancel() {
            for (StockArea area : this.areas) {
                JCheckBox check = this.areasMap.get(area);
                check.setSelected(SuggestedOrderingReportState.this.selectedStockAreas.contains(area));
            }
            this.dispose();
        }
    }

    private class RefreshActionListener
    implements ActionListener {
        private RefreshActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SuggestedOrderingReportState.this.updatesAllowed) {
                SuggestedOrderingReportState.this.refresh();
            }
        }
    }

    private class SuggestedOrderingSetupTask
    extends AbstractGuiTask {
        private SuggestedOrderingSetupTask() {
        }

        public String getName() {
            return "Loading Suggested Ordering Report screen...";
        }

        public void doGuiTask() throws Exception {
            SuggestedOrderingReportState.this.setupGUI();
            this.emitProgress();
            SuggestedOrderingReportState.this.setupTree();
            this.emitProgress();
            SuggestedOrderingReportState.this.setupTable();
            this.emitProgress();
            SuggestedOrderingReportState.this.refresh();
            SuggestedOrderingReportState.this.alreadySetup = true;
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 4;
        }
    }
}

