/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.suggested;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateTimeUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import org.apache.commons.lang.mutable.MutableDouble;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class SuggestedOrderingTableModel
extends QueryTableModel {
    private int roundMode = 0;
    private Map<String, MutableDouble> totalStockInPurchaseOrders = new HashMap<String, MutableDouble>();

    public SuggestedOrderingTableModel(SelectQuery selQuery, DBConnectionInterface dc, String idField, String[] colNames, String[] colDisplayNames) {
        super(selQuery, dc, idField, colNames, colDisplayNames);
    }

    @Override
    public void setData(ResultSet rs) throws SQLException {
        super.setData(rs);
        if (SystemProperty.getInstance().isSuggestedOrderIncPurchases()) {
            this.getSuggestedOrderingIncludePurchasesValues();
        }
    }

    private void getSuggestedOrderingIncludePurchasesValues() {
        Calendar dateRangeCal = Calendar.getInstance();
        dateRangeCal.add(6, 1);
        Date start = DateTimeUtils.getEndOfDay((Date)dateRangeCal.getTime());
        dateRangeCal.add(2, -1);
        ObjectQuery alreadyOrderedQuery = Query.select(StockInvoice.class).equals(StockInvoice.Properties.INVOICE_TYPE, (Object)"Purchase Order").active(StockInvoice.class).wherePropertyBetween(StockInvoice.Properties.CREATION_DATE, dateRangeCal.getTime(), start, SQLDateType.DATE);
        List invoices = PersistenceManager.getObjectList(StockInvoice.class, (String)alreadyOrderedQuery.toString());
        this.totalStockInPurchaseOrders = new HashMap<String, MutableDouble>();
        for (StockInvoice i : invoices) {
            List entries = i.getEntries();
            for (StockInvoiceEntry e : entries) {
                String stockItemName = e.getStockItem().getName();
                MutableDouble mDouble = new MutableDouble(0.0);
                if (this.totalStockInPurchaseOrders.containsKey(stockItemName)) {
                    mDouble.setValue((Object)this.totalStockInPurchaseOrders.get(stockItemName));
                }
                mDouble.setValue(mDouble.doubleValue() + e.getNumReceived());
                mDouble.setValue(mDouble.doubleValue() + e.getBonusReceived());
                this.totalStockInPurchaseOrders.put(stockItemName, mDouble);
            }
        }
    }

    @Override
    protected Object getTableValue(int row, int col, String colName, int dbColIndex, ResultSet rs) throws SQLException {
        if (colName.equals("SOHQuantity")) {
            Long fkContainer = rs.getLong("stock_item.fk_display_measure_unit_container");
            MeasureUnitContainer container = (MeasureUnitContainer)PersistenceManager.getByID((long)fkContainer, MeasureUnitContainer.class);
            return new Quantity(container, rs.getDouble(colName), true);
        }
        if (colName.equals("SuggestedOrder")) {
            Long fkContainer = rs.getLong("stock_item.fk_display_measure_unit_container");
            MeasureUnitContainer container = (MeasureUnitContainer)PersistenceManager.getByID((long)fkContainer, MeasureUnitContainer.class);
            double rawSuggestedQty = rs.getDouble(colName);
            Quantity qty = new Quantity(container, rawSuggestedQty, true);
            if (SystemProperty.getInstance().isSuggestedOrderIncPurchases() && this.totalStockInPurchaseOrders.containsKey(rs.getString("stock_item.Name"))) {
                double stockOrdered = this.totalStockInPurchaseOrders.get(rs.getString("stock_item.Name")).doubleValue();
                Quantity amountOrdered = new Quantity(container, stockOrdered, false);
                qty = qty.subtract(amountOrdered);
            }
            switch (this.roundMode) {
                case 1: {
                    qty = new Quantity(container, Math.ceil(qty.doubleValue()), false);
                    break;
                }
                case 2: {
                    double rawQuantity = rs.getDouble("stock_item.Quantity");
                    String outerName = rs.getString("stock_item.OuterName");
                    double outerMult = rs.getDouble("stock_item.OuterQuantity");
                    boolean suggestedOrderIncPurchases = SystemProperty.getInstance().isSuggestedOrderIncPurchases() && this.totalStockInPurchaseOrders.containsKey(rs.getString("stock_item.Name"));
                    double outers = !suggestedOrderIncPurchases ? rawSuggestedQty / (rawQuantity * outerMult) : qty.doubleValue() / outerMult;
                    double truncOuters = Math.floor(outers);
                    double remainder = outers - truncOuters;
                    MeasureUnit outerMeasure = MeasureUnitHelper.createOuterMeasureUnit((String)outerName, (double)outerMult, (double)rawQuantity);
                    if (remainder > 0.0) {
                        outers = truncOuters + 1.0;
                    }
                    qty = new Quantity((MeasureUnitI)outerMeasure, outers * rawQuantity * outerMult, true);
                    break;
                }
            }
            if (qty.doubleValue() < 0.0) {
                qty = qty.multiply(0.0);
            }
            return qty;
        }
        if (colName.equals("stock_item.Quantity")) {
            double rawQuantity = rs.getDouble("stock_item.Quantity");
            String measureString = rs.getString("stock_item.IngredientMeasureUnit");
            MeasureUnit measure = MeasureUnitHelper.getMeasureUnit((String)measureString);
            return new Quantity((MeasureUnitI)measure, rawQuantity, true);
        }
        return super.getTableValue(row, col, colName, dbColIndex, rs);
    }

    public void setRoundUpMode(int roundUpMode) {
        this.roundMode = roundUpMode;
    }
}

