/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.transfer;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY_HM;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import officemate.adminkit.DefaultObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.fieldpanels.DateTimeFieldPanel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectRefFieldPanel;
import officemate.adminkit.fieldpanels.QuantityFieldPanel;
import officemate.adminkit.fieldpanels.StringFieldPanel;
import officemate.screens.maintainstock.UsageStockAreaFieldPanel;
import officemate.screens.maintainstock.transfer.TransferData;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockTransfer;
import ordermate.database.users.AllPermissions;

public class StockTransferEditorPanel
extends DefaultObjectEditorPanel {
    private static final String[] EDIT_FIELDS = new String[]{"Quantity", "User", "Reason", "Stock Item", "Transfer From", "Transfer To", "Usage Date"};
    private StockTransfer trans;
    private UsageStockAreaFieldPanel transferToPanel;
    private UsageStockAreaFieldPanel transferFromPanel;
    private DateTimeFieldPanel datePanel;
    private ObjectRefFieldPanel stockItemPanel;
    private ObjectSelectorPanel stockItemSelector;
    private QuantityFieldPanel qtyPanel;
    private static final TransferData lastAccessedState = new TransferData();

    public StockTransferEditorPanel() {
        super(EDIT_FIELDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ObjectManager manager, ObjectTemplate objectTemplate, Object obj) {
        super.init(manager, objectTemplate, obj);
        Assert.isEqual(StockTransfer.class, (Object)objectTemplate.getObjectJavaClass(), (String)"Template must support StockTransfers");
        this.trans = (StockTransfer)obj;
        this.transferToPanel = (UsageStockAreaFieldPanel)this.getFieldPanel("Transfer To");
        this.transferFromPanel = (UsageStockAreaFieldPanel)this.getFieldPanel("Transfer From");
        ObjectRefFieldPanel userPanel = (ObjectRefFieldPanel)this.getFieldPanel("User");
        ObjectSelectorPanel userSelector = userPanel.getObjectSelector();
        if (this.isNewObject()) {
            userSelector.setSelectedObject(GuiApp.getAppComplex().getApplicationSecurity().getUser());
        }
        String userAccess = GuiApp.getAppComplex().getApplicationSecurity().getUser().getPermissionAccessLevel(AllPermissions.CHANGE_ADJUSTMENT_USER);
        userSelector.setEnabled(userAccess.equals("ENABLED"));
        userSelector.setVisible(!userAccess.equals("HIDDEN"));
        this.stockItemPanel = (ObjectRefFieldPanel)this.getFieldPanel("Stock Item");
        this.stockItemSelector = this.stockItemPanel.getObjectSelector();
        this.stockItemSelector.objectSelected.connect((Object)this, "gotStockItemSelected");
        this.qtyPanel = (QuantityFieldPanel)this.getFieldPanel("Quantity");
        this.datePanel = (DateTimeFieldPanel)this.getFieldPanel("Usage Date");
        QuantityEventListener listener = new QuantityEventListener();
        this.qtyPanel.addChangeListenerToComponent(listener);
        this.qtyPanel.addFocusListenerToComponent(listener);
        if (this.isNewObject()) {
            StringFieldPanel reasonPanel = (StringFieldPanel)this.getFieldPanel("Reason");
            TransferData transferData = lastAccessedState;
            synchronized (transferData) {
                if (lastAccessedState.isInitialized()) {
                    userPanel.setValue(lastAccessedState.getUser());
                    if (lastAccessedState.getStockItem().isPersistent()) {
                        this.stockItemPanel.setValue(lastAccessedState.getStockItem());
                    }
                    this.qtyPanel.setValue(lastAccessedState.getQty());
                    this.transferToPanel.setValue(lastAccessedState.getTransferTo());
                    this.transferFromPanel.setValue(lastAccessedState.getTransferFrom());
                    this.datePanel.setValue(lastAccessedState.getDate());
                    reasonPanel.setValue(lastAccessedState.getReason());
                }
            }
            this.applyStockItemDefaults();
        } else if (this.trans.isFrozen()) {
            FieldPanel[] fieldPanels = this.getFieldPanels();
            for (int i = 0; i < fieldPanels.length; ++i) {
                FieldPanel panel = fieldPanels[i];
                panel.setEnabled(false);
            }
        }
        this.updateAreaPanels();
    }

    private void updateAreaPanels() {
        this.updateAreaPanels((StockItem)this.stockItemPanel.getValue(), this.qtyPanel.getValue());
    }

    private void updateAreaPanels(StockItem item, Quantity currentQtyObj) {
        Quantity originalQty = this.trans != null ? this.trans.getQuantityUsed() : new Quantity(0.0);
        this.updateAreaPanels(item, currentQtyObj, originalQty);
    }

    private void updateAreaPanels(StockItem item, Quantity currentQtyObj, Quantity originalQtyObj) {
        double currentQty = currentQtyObj.doubleValue();
        double originalQty = originalQtyObj.doubleValue();
        if (this.trans == null || !this.trans.isFrozen()) {
            item.reload();
            this.transferFromPanel.updateLabels(item, currentQty, originalQty);
            this.transferToPanel.updateLabels(item, -currentQty, -originalQty);
        }
    }

    @Override
    public String[] getInvalidFields() {
        StockArea areaFrom;
        String[] invalidFields = super.getInvalidFields();
        int numInvalid = invalidFields.length;
        StockArea areaTo = (StockArea)this.transferToPanel.getValue();
        if (areaTo.equals((Object)(areaFrom = (StockArea)this.transferFromPanel.getValue()))) {
            String[] newInvalidFields = new String[numInvalid + 2];
            int newNumInvalid = newInvalidFields.length;
            System.arraycopy(invalidFields, 0, newInvalidFields, 0, numInvalid);
            newInvalidFields[newNumInvalid - 2] = "Transfer To";
            newInvalidFields[newNumInvalid - 1] = "Transfer From";
            invalidFields = newInvalidFields;
        }
        return invalidFields;
    }

    @Override
    protected FieldPanel createFieldPanel(String fieldName) {
        if (fieldName.equals("Transfer To") || fieldName.equals("Transfer From")) {
            UsageStockAreaFieldPanel panel = new UsageStockAreaFieldPanel(this.getObjectManager());
            panel.setFieldType(this.getTemplate().getFieldType(fieldName));
            return panel;
        }
        return super.createFieldPanel(fieldName);
    }

    @Override
    public boolean requestSaveAllowed() {
        boolean frozen;
        Date date = (Date)this.datePanel.getValue();
        StockTake stockTake = StockTake.getLastSavedStockTake();
        StockArea areaTo = (StockArea)this.transferToPanel.getValue();
        StockArea areaFrom = (StockArea)this.transferFromPanel.getValue();
        boolean bl = frozen = this.trans != null && this.trans.isFrozen();
        if (!frozen) {
            if (stockTake != null && date.before(stockTake.getDate())) {
                JOptionPane.showMessageDialog(this, "The transfer date must be more recent than the last stocktake. (" + new DateDMY_HM(stockTake.getDate()) + ") \nPlease choose a more recent date.", "Can't create stock transfer", 2);
                return false;
            }
            if (areaTo.equals((Object)areaFrom)) {
                JOptionPane.showMessageDialog(this, "Transfer not allowed between the same stock area. \nPlease select different areas.", "Can't create stock transfer", 2);
                return false;
            }
            return super.requestSaveAllowed();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveObject() {
        boolean isNew = this.isNewObject();
        super.saveObject();
        if (isNew) {
            StockTransfer obj = (StockTransfer)this.getEditedObject();
            TransferData transferData = lastAccessedState;
            synchronized (transferData) {
                lastAccessedState.setTransferTo(obj.getStockAreaTransferTo()).setTransferFrom(obj.getStockArea()).setUser(obj.getUser()).setStockItem(obj.getStockItem()).setQty(obj.getQuantityUsed()).setDate(obj.getUsageDate()).setReason(obj.getReason()).setInitialized();
            }
        }
    }

    private void applyStockItemDefaults() {
        MeasureUnitContainer defaultDispUnits;
        StockItem defaultStockItem = (StockItem)this.stockItemPanel.getValue();
        Quantity qty = this.qtyPanel.getValue();
        double value = 1.0;
        if (defaultStockItem != null) {
            defaultDispUnits = defaultStockItem.getDisplayMeasureUnitContainer();
            value = qty.doubleValue() * defaultStockItem.getPurchaseQty().doubleValue();
        } else {
            defaultDispUnits = new MeasureUnitContainer(MeasureUnitHelper.getMeasureUnitForName((String)"units"));
        }
        this.qtyPanel.setValue(new Quantity(defaultDispUnits, value, false));
    }

    void gotStockItemSelected(Object o) {
        this.applyStockItemDefaults();
        this.updateAreaPanels((StockItem)o, this.qtyPanel.getValue());
        this.repaint();
    }

    @Override
    public int getDialogMode() {
        if (this.trans != null && this.trans.isFrozen()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean requestCloseAllowed() {
        return this.getDialogMode() == 1;
    }

    private class QuantityEventListener
    implements ChangeListener,
    FocusListener {
        private QuantityEventListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            StockTransferEditorPanel.this.updateAreaPanels();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            StockTransferEditorPanel.this.updateAreaPanels();
        }
    }
}

