/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintainstock.transfer;

import au.com.ordermate.application.ApplicationFrame;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Assert;
import au.com.ordermate.util.DateDMY;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import officemate.adminkit.DateRangePanel;
import officemate.adminkit.ObjectChangeRecorder;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.print.Printing;
import officemate.adminkit.state.ActionFactory;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.adminkit.templates.Templates;
import officemate.adminkit.tree.stockgroup.StockGroupTreePanel;
import officemate.screens.ObjectManagerI;
import officemate.screens.maintainstock.transfer.OldTransfersLookDifferentCellRenderer;
import officemate.screens.maintainstock.transfer.StockTransferTableModel;
import ordermate.database.misc.StockControlEventLog;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.reports.stock.transfer.StockTransfersReportQuery;
import ordermate.database.searchers.stock.transfer.StockTransfersSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.usage.StockTransfer;
import ordermate.database.stock.usage.StockUsage;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;

public class StockTransferState
extends BasicOfficeMateState {
    static final String DB_STOCK_USAGE_ID = "stock_usage.ID";
    static final String DB_STOCK_ITEM_NAME = "stock_item.Name";
    static final String DB_STOCK_USAGE_QUANTITY = "stock_usage.Quantity";
    static final String DB_STOCK_USAGE_DATE = "stock_usage.UsageDate";
    static final String DB_STOCK_USAGE_CREATION_DATE = "stock_usage.CreationDate";
    static final String DB_STOCK_ITEM_DISPLAY_UNIT = "stock_item.fk_display_measure_unit_container";
    static final String DB_STOCK_USAGE_VALUE = "UsageValue";
    private JPanel innerPanel;
    private JPanel northPanel;
    private JSplitPane splitter;
    private StockGroupTreePanel treePanel = null;
    private SelectQuery query;
    private JPanel tablePanel;
    private JPanel southPanel;
    private QueryTable table;
    private QueryTableModel tableModel;
    private LinkedTotalTable totalsTable;
    private DateRangePanel datePanel = null;
    private final ObjectTemplate stockTransferTemplate = Templates.STOCK_TRANSFER;
    private JComboBox areaFromCombo;
    private JComboBox areaToCombo;
    private JComboBox userCombo;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;
    private StockTransfersSearcher searcher;

    public StockTransferState() {
        super("Transfer", AllPermissions.ACCESS_TRANSFER_SCREEN, "View, create and modify stock transfers between areas");
        this.innerPanel = new JPanel(new BorderLayout());
        this.innerPanel.setName("Transfer");
        this.setScreenPanel(this.innerPanel);
        this.searcher = new StockTransfersSearcher();
        this.addAction((Action)ActionFactory.createPermissibleNewAction(this, AllPermissions.ADD_TRANSFERS));
        this.addAction((Action)ActionFactory.createPermissibleEditAction(this, AllPermissions.EDIT_TRANSFERS));
        this.addAction((Action)ActionFactory.createPermissibleDeleteAction(this, AllPermissions.DELETE_TRANSFERS));
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Stock Transfer screen...");
        if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new StockTransferSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        } else {
            this.refresh();
        }
        this.updateButtonStates();
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    @Override
    public boolean supportsNew() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doNewAction() {
        this.addObject();
    }

    private void setupGUI() {
        this.splitter = new JSplitPane();
        this.northPanel = new JPanel(new BorderLayout());
        this.innerPanel.add((Component)this.splitter, "Center");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupDates() {
        this.datePanel = new DateRangePanel();
        this.datePanel.datesChanged.connect((Object)this, "gotDatesChanged");
        Date now = new Date();
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        Date startOfMonth = new Date(cal.getTimeInMillis());
        this.datePanel.setEndDate(now);
        this.datePanel.setStartDate(startOfMonth);
        this.northPanel.add((Component)this.datePanel, "East");
    }

    private void setupCombos() {
        this.areaFromCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areaFromCombo.insertItemAt("(All)", 0);
        this.areaFromCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areaFromCombo);
        this.areaFromCombo.addActionListener(new ComboActionListener());
        this.areaToCombo = new JComboBox<Object>(StockArea.getStockAreas().toArray());
        this.areaToCombo.insertItemAt("(All)", 0);
        this.areaToCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.areaToCombo);
        this.areaToCombo.addActionListener(new ComboActionListener());
        this.userCombo = new JComboBox(new Vector(User.getUsers()));
        this.userCombo.insertItemAt("(All)", 0);
        this.userCombo.setSelectedIndex(0);
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.userCombo);
        this.userCombo.addActionListener(new ComboActionListener());
        FieldPanelBuilder builder = new FieldPanelBuilder(0);
        builder.addRow("Area From:", (Component)this.areaFromCombo);
        builder.addRow("Area To:", (Component)this.areaToCombo);
        builder.addRow("User:", (Component)this.userCombo);
        this.northPanel.add((Component)builder.getPanel(), "West");
    }

    private void setupTree() {
        this.treePanel = new StockGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void setupTable() {
        this.tableModel = new StockTransferTableModel(this.query, DB_STOCK_USAGE_ID, StockTransfersReportQuery.dbColumns, StockTransfersReportQuery.displayColumns, GuiApp.getAppComplex().getApplicationContext());
        this.tableModel.addTotalColumn(DB_STOCK_USAGE_VALUE);
        this.table = new QueryTable(this.tableModel);
        StockTake lastStockTake = StockTake.getLastSavedStockTake();
        if (lastStockTake != null) {
            this.table.setCellRendererForAll(new OldTransfersLookDifferentCellRenderer(lastStockTake.getDate()));
        }
        this.table.objectChosen.connect((Object)this, "doEditAction");
        this.table.objectSelected.connect((Object)this, "gotTableObjectSelected");
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        JPanel buttonWrapperPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
        this.southPanel = new JPanel(new BorderLayout());
        this.southPanel.add((Component)this.tablePanel, "Center");
        this.southPanel.add((Component)buttonWrapperPanel, "East");
        this.splitter.setRightComponent(this.southPanel);
        this.splitter.setDividerLocation(160);
    }

    private void setupTotalsPanel() {
        this.totalsTable = new LinkedTotalTable(this.table.getColumnModel());
        JPanel totalWrapperPanel = new JPanel(new BorderLayout());
        totalWrapperPanel.add((Component)new JLabel("Totals:"), "North");
        totalWrapperPanel.add((Component)this.totalsTable, "Center");
        this.tablePanel.add((Component)totalWrapperPanel, "South");
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.updatesAllowed = false;
        if (this.treePanel == null) {
            this.updatesAllowed = true;
            return;
        }
        Object comboSelected = this.areaFromCombo.getSelectedItem();
        this.areaFromCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
        this.areaFromCombo.insertItemAt("(All)", 0);
        this.areaFromCombo.setSelectedIndex(0);
        this.areaFromCombo.setSelectedItem(comboSelected);
        Object selGroup = this.treePanel.getSelectedObject();
        this.treePanel.refresh();
        this.treePanel.getTree().setSelectedObject(selGroup);
        comboSelected = this.areaToCombo.getSelectedItem();
        this.areaToCombo.setModel(new DefaultComboBoxModel<Object>(StockArea.getStockAreas().toArray()));
        this.areaToCombo.insertItemAt("(All)", 0);
        this.areaToCombo.setSelectedIndex(0);
        this.areaToCombo.setSelectedItem(comboSelected);
        comboSelected = this.userCombo.getSelectedItem();
        this.userCombo.setModel(new DefaultComboBoxModel(new Vector(User.getUsers())));
        this.userCombo.insertItemAt("(All)", 0);
        this.userCombo.setSelectedIndex(0);
        this.userCombo.setSelectedItem(comboSelected);
        StockTake lastStockTake = StockTake.getLastSavedStockTake();
        if (lastStockTake != null) {
            this.table.setCellRendererForAll(new OldTransfersLookDifferentCellRenderer(lastStockTake.getDate()));
        }
        this.updateQuery(this.getCurrentStockGroup());
        this.updatesAllowed = true;
    }

    @Override
    public void doPrintAction() {
        String title = "Transfers";
        DateDMY start = new DateDMY((Date)this.datePanel.getSQLStartDate());
        DateDMY end = new DateDMY((Date)this.datePanel.getSQLEndDate());
        String dateString = " from " + start + " to " + end;
        StockArea areaFrom = this.getCurrentStockAreaFrom();
        StockArea areaTo = this.getCurrentStockAreaTo();
        User user = this.getCurrentUser();
        String areaFromString = areaFrom != null ? " From: " + areaFrom.getLabel() : "";
        String areaToString = areaTo != null ? " To: " + areaTo.getLabel() : "";
        String userString = user != null ? " User: " + user.getLabel() : "";
        Printing.printJTableReport(this.table, title + dateString, areaFromString + areaToString + userString, 8, this.totalsTable.getColumnStrings());
    }

    private StockArea getCurrentStockAreaFrom() {
        Object obj = this.areaFromCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    private StockArea getCurrentStockAreaTo() {
        Object obj = this.areaToCombo.getSelectedItem();
        return obj instanceof StockArea ? (StockArea)obj : null;
    }

    private User getCurrentUser() {
        Object obj = this.userCombo.getSelectedItem();
        return obj instanceof User ? (User)obj : null;
    }

    private StockGroup getCurrentStockGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof StockGroup ? (StockGroup)obj : null;
    }

    private void updateQuery() {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockAreaFrom(), this.getCurrentStockAreaTo(), this.getCurrentStockGroup(), this.datePanel.getStartDate(), this.datePanel.getEndDate());
    }

    private void updateQuery(Date start, Date end) {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockAreaFrom(), this.getCurrentStockAreaTo(), this.getCurrentStockGroup(), start, end);
    }

    private void updateQuery(StockGroup currentStockGroup) {
        this.updateQuery(this.getCurrentUser(), this.getCurrentStockAreaFrom(), this.getCurrentStockAreaTo(), currentStockGroup, this.datePanel.getStartDate(), this.datePanel.getEndDate());
    }

    private void updateQuery(User user, StockArea areaFrom, StockArea areaTo, StockGroup group, Date start, Date end) {
        this.searcher.getStockAreaFromFilter().setSearchValue((Object)areaFrom);
        this.searcher.getStockAreaToFilter().setSearchValue((Object)areaTo);
        this.searcher.getUserSearchFilter().setSearchValue((Object)user);
        this.searcher.getStockGroupFilter().setSearchValue((Object)group);
        this.searcher.getDateRangeFilter().setStart((Comparable)start);
        this.searcher.getDateRangeFilter().setEnd((Comparable)end);
        this.query = this.searcher.getQuery();
        this.tableModel.setQuery(this.query);
        this.table.updateModel();
        this.totalsTable.setColumnValues(this.table.getTotals());
        this.table.revalidate();
        this.table.repaint();
        this.totalsTable.repaint();
    }

    private void addObject() {
        boolean hasAreaAndItem;
        boolean bl = hasAreaAndItem = StockArea.stockAreasExist() && StockItemQueries.stockItemsExist();
        if (!hasAreaAndItem) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To create a transfer, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't create transfer!", 2);
            return;
        }
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Creating " + this.stockTransferTemplate.getName() + "...");
        ObjectEditorPanel editorView = this.stockTransferTemplate.getNewEditPanel(null);
        while (ObjectEditorDialog.doDialog(frame.getFrame(), editorView, true) == 0) {
            editorView.saveObject();
            StockUsage obj = (StockUsage)editorView.getEditedObject();
            Assert.isTrue((obj != null ? 1 : 0) != 0, (String)"Failed to create StockTransfer");
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(obj, this.stockTransferTemplate);
            if (obj != null) {
                obj.commit();
                StockControlEventLog.logCreateStockTransfer((User)this.getUser(), (StockTransfer)((StockTransfer)obj));
            }
            editorView = this.stockTransferTemplate.getNewEditPanel(null);
            this.updateQuery();
        }
        editorView.cancelObject();
        frame.resetStatusBarText();
    }

    @Override
    public void doEditAction() {
        boolean hasAreaAndItem;
        boolean bl = hasAreaAndItem = StockArea.stockAreasExist() && StockItemQueries.stockItemsExist();
        if (!hasAreaAndItem) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To edit a transfer, please ensure that you have set up at least one\n    - Stock Area \n    - Stock Item ", "Can't edit transfer!", 2);
            return;
        }
        StockTransfer obj = this.getCurrentStockTransfer();
        ObjectChangeRecorder changeRecorder = new ObjectChangeRecorder(this.stockTransferTemplate);
        changeRecorder.snapshot(obj);
        ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
        frame.setStatusBarText("Editing " + this.stockTransferTemplate.getName() + ":  " + this.stockTransferTemplate.getObjectText(obj));
        ObjectEditorPanel editorView = this.stockTransferTemplate.getNewEditPanel(obj);
        int result = ObjectEditorDialog.doDialog(frame.getFrame(), editorView);
        if (result == 0) {
            editorView.saveObject();
            StockControlEventLog.logEditStockTransfer((User)this.getUser(), (StockTransfer)obj, changeRecorder.getChanges(obj));
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().saveObject(obj, this.stockTransferTemplate);
            obj.commit();
        } else if (result == 1) {
            editorView.cancelObject();
        } else if (result != 2) {
            throw new IllegalArgumentException("Illegal dialog result: " + result);
        }
        this.updateQuery();
        frame.resetStatusBarText();
    }

    @Override
    public void doDeleteAction() {
        int result = JOptionPane.showConfirmDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Are you sure you wish to delete the selected transfer? \nThis operation cannot be undone.", "Delete transfer?", 0, 2);
        if (result == 0) {
            StockTransfer obj = this.getCurrentStockTransfer();
            int selRow = this.table.getSelectedRow();
            ApplicationFrame frame = GuiApp.getAppComplex().getApplicationFrame();
            frame.setStatusBarText("Removing " + this.stockTransferTemplate.getName() + ":  " + this.stockTransferTemplate.getObjectText(obj));
            StockControlEventLog.logDeleteStockTransfer((User)this.getUser(), (StockTransfer)obj);
            ((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager().deleteObject(obj, this.stockTransferTemplate);
            obj.cancelUsage();
            this.updateQuery();
            this.table.requestFocus();
            int rowCount = this.table.getModel().getRowCount();
            if (selRow < rowCount) {
                this.table.setRowSelectionInterval(selRow, selRow);
            } else if (rowCount > 0) {
                this.table.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            }
            this.updateButtonStates();
            frame.resetStatusBarText();
        }
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.updatesAllowed) {
            StockGroup group = null;
            if (obj instanceof StockGroup) {
                group = (StockGroup)obj;
            }
            this.updateQuery(group);
        }
    }

    public StockTransfer getCurrentStockTransfer() {
        long id = this.tableModel.getID(this.table.getSelectedRow());
        return id != -1L ? new StockTransfer(id) : null;
    }

    void gotTableObjectSelected() {
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        StockTransfer usage = this.getCurrentStockTransfer();
        boolean isObjectSelected = usage != null && this.table.getSelectedRow() != -1;
        this.toggleDefaultAction(this.getEditAction(), isObjectSelected);
        this.toggleDefaultAction(this.getDeleteAction(), isObjectSelected);
    }

    void gotDatesChanged(Date newStartDate, Date newEndDate) {
        if (this.datePanel != null) {
            this.updateQuery(newStartDate, newEndDate);
        }
    }

    public StockTransfersSearcher getSearcher() {
        return this.searcher;
    }

    private class ComboActionListener
    implements ActionListener {
        private ComboActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (StockTransferState.this.updatesAllowed) {
                StockTransferState.this.refresh();
            }
        }
    }

    private class StockTransferSetupTask
    extends AbstractGuiTask {
        private StockTransferSetupTask() {
        }

        public String getName() {
            return "Loading Stock Transfer screen...";
        }

        public void doGuiTask() throws Exception {
            StockTransferState.this.setupGUI();
            this.emitProgress();
            StockTransferState.this.setupCombos();
            this.emitProgress();
            StockTransferState.this.setupTree();
            this.emitProgress();
            StockTransferState.this.setupTable();
            this.emitProgress();
            StockTransferState.this.setupTotalsPanel();
            this.emitProgress();
            StockTransferState.this.setupDates();
            this.emitProgress();
            StockTransferState.this.refresh();
            StockTransferState.this.alreadySetup = true;
            if (StockTransferState.this.table.getModel().getRowCount() > 0) {
                StockTransferState.this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 7;
        }
    }
}

