/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.humpback;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.search.control.RefreshAction;
import javax.swing.Action;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.maintenance.advanced.humpback.HumpSyncSearch;
import officemate.screens.maintenance.advanced.unknown.SyncHumpBackAction;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class HumpSyncState
extends AbstractTableState<PersistentObject> {
    private final SyncHumpBackAction syncTheHump = new SyncHumpBackAction(new RefreshAction((Refreshable)this));

    public HumpSyncState() {
        super("HumpBack Sync", AllPermissions.ACCESS_MENU_PROFILES, "View and synchronise menu elements:");
        this.addAction((Action)((Object)this.syncTheHump));
    }

    @Override
    protected OfficeMateObjectSearch<PersistentObject> createSearchPanelFactory() {
        return new HumpSyncSearch();
    }

    @Override
    protected TableStateCentralArea<PersistentObject> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new ClassColumnFormat("Class"));
        format.addColumn((ColumnFormat)new ToStringColumnFormat("Label"));
        format.addColumn((ColumnFormat)new PropertyColumnFormat(PersistentObject.Properties.ID));
        format.addColumn((ColumnFormat)new MasterIdColumnFormat("Master ID"));
        PersistentObjectTable<PersistentObject> table = new PersistentObjectTable<PersistentObject>(this.getObjectList(), format);
        table.getTable().getColumn(1).setMinWidth(300);
        table.getTable().getColumn(1).setPreferredWidth(400);
        return table;
    }

    @Override
    protected Class<PersistentObject> getDisplayingType() {
        return PersistentObject.class;
    }

    class MasterIdColumnFormat
    extends AbstractColumnFormat {
        public MasterIdColumnFormat(String newName) {
            super(newName, String.class);
        }

        public Object resolveColumnValue(Object baseObject) {
            return ((PersistentObject)baseObject).getProperties().getProperty("masterId").resolveValue(baseObject);
        }
    }

    class ToStringColumnFormat
    extends AbstractColumnFormat {
        public ToStringColumnFormat(String newName) {
            super(newName, String.class);
        }

        public Object resolveColumnValue(Object baseObject) {
            return String.valueOf(baseObject);
        }
    }

    class ClassColumnFormat
    extends AbstractColumnFormat {
        public ClassColumnFormat(String newName) {
            super(newName, String.class);
        }

        public Object resolveColumnValue(Object baseObject) {
            return baseObject.getClass().getSimpleName();
        }
    }
}

