/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.maintenance.advanced.unknown;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.integration.humpy.HumpBackSync;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class SyncHumpBackAction
extends BasicAction {
    private RefreshAction refresh;

    public SyncHumpBackAction(RefreshAction refreshAction) {
        this.refresh = refreshAction;
        this.setText("Sync to Cloud");
        this.setToolTipText("Synchronises resolved mappings with HumpBack");
        this.setIcon(IconLoader.get((String)"/officemate/images/resync.png"));
    }

    public void actionPerformed(ActionEvent arg0) {
        Dialogs.showProgressDialog(new AbstractTask(){

            protected int getTotalSubTasks() {
                return 2;
            }

            protected void performTask() throws Exception {
                CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(HumpBackSync.class.getCanonicalName(), new String[]{"getInstance", "needsSync"});
                Boolean result = (Boolean)PersistenceManager.getServerConnection().runSync((Executable)exec);
                if (null == result) {
                    Dialogs.showInfoDialog("Error", "There was an error on Servermate, cannot synchronise");
                    return;
                }
                if (Boolean.FALSE.equals(result)) {
                    Dialogs.showInfoDialog("No Sync Required", "There are no resolved, un-synced unknowns");
                    return;
                }
                this.emitProgress();
                exec = new CallMethodOnClassExecutable(HumpBackSync.class.getCanonicalName(), new String[]{"getInstance", "performSync"});
                result = (Boolean)PersistenceManager.getServerConnection().runSync((Executable)exec);
                this.emitProgress();
                if (result == null) {
                    Dialogs.showInfoDialog("Error Syncing", "There was an error on Servermate, no syncing has taken place.");
                    return;
                }
                if (Boolean.FALSE.equals(result)) {
                    Dialogs.showInfoDialog("Error Syncing", "There was an error synchronising and some unknowns may not be synced.");
                    return;
                }
                Dialogs.showInfoDialog("Sync Successful", "All resolved unknowns were synchronised.");
            }

            public String getName() {
                return "Synchronising...";
            }
        });
        if (this.refresh != null) {
            this.refresh.doRefresh();
        }
    }
}

