/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.messaging.sms;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.components.AbstractObjectEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.message.Command;
import ordermate.database.message.MessageDestination;
import ordermate.database.message.ScheduledMessage;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public class ScheduledSmsEditPanel
extends AbstractObjectEditor<ScheduledMessage> {
    private final String TIME_SPINNER_FORMAT = "HH:mm";
    private EventList<Command> commandList;
    private EventList<String> weekdayList;
    private ListComboBoxModel weekdayComboboxModel;
    private PersistentObjectTable<MessageDestination> destinationsTable;
    private final EventList<MessageDestination> destinationList = new BasicEventList();
    private JPanel destinationsPanel;
    private Button removeButton;

    public ScheduledSmsEditPanel() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JComboBox commandBox = this.setupComboBox(ScheduledMessage.Properties.COMMAND, this.getCommandList());
        JPanel panelCommand = new JPanel();
        panelCommand.add(commandBox);
        JComboBox weekdayBox = this.setupComboBox(ScheduledMessage.Properties.DAY, this.getWeekdayComboboxModel(), (Validator)new NotEmptyValidator());
        JSpinner timeSpinner = this.setupDateSpinner(ScheduledMessage.Properties.TIME, "HH:mm", null, null);
        JLabel labelTime = new JLabel("Time");
        JPanel panelDayTime = new JPanel();
        panelDayTime.add(weekdayBox);
        panelDayTime.add(labelTime);
        panelDayTime.add(timeSpinner);
        builder.addRow("Command", (Component)panelCommand);
        builder.addRow("Day", (Component)panelDayTime);
        builder.addRow("Phone Number", (Component)this.getDestinationPanel());
        this.add((Component)builder.getPanel(), "North");
        this.add(this.getMessageDestinationTable(), "Center");
    }

    @Override
    public void setObject(ScheduledMessage toEdit) {
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.destinationList, toEdit.getDestination());
        super.setObject(toEdit);
    }

    private PersistentObjectTable<MessageDestination> getMessageDestinationTable() {
        if (this.destinationsTable == null) {
            this.destinationsTable = new PersistentObjectTable<MessageDestination>(this.destinationList, new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Phone Number", MessageDestination.Properties.DESTINATION)}));
            this.destinationsTable.addSelectionChangeListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ScheduledSmsEditPanel.this.removeButton.setEnabled(ScheduledSmsEditPanel.this.destinationsTable.getSelectedObject() != null);
                }
            });
        }
        return this.destinationsTable;
    }

    private JPanel getDestinationPanel() {
        if (this.destinationsPanel == null) {
            this.destinationsPanel = new JPanel();
            final JTextField phoneNumber = new JTextField(20);
            Button addButton = new Button("Add");
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ScheduledSmsEditPanel.this.addDestination(phoneNumber.getText())) {
                        phoneNumber.setText("");
                    }
                }
            });
            this.removeButton = new Button("Remove");
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ScheduledSmsEditPanel.this.removeSelectedDestination()) {
                        ((Button)e.getSource()).setEnabled(true);
                    }
                }
            });
            this.removeButton.setEnabled(false);
            this.destinationsPanel.add(phoneNumber);
            this.destinationsPanel.add(addButton);
            this.destinationsPanel.add(this.removeButton);
        }
        return this.destinationsPanel;
    }

    private boolean addDestination(String newDestination) {
        List destinations = ((ScheduledMessage)this.getObject()).getDestination();
        if (!destinations.isEmpty()) {
            for (MessageDestination dest : destinations) {
                if (!dest.getDestination().equals(newDestination)) continue;
                return false;
            }
        }
        MessageDestination newDestinationInstance = new MessageDestination();
        newDestinationInstance.setDestination(newDestination);
        destinations.add(newDestinationInstance);
        ((ScheduledMessage)this.getObject()).setDestination(destinations);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.destinationList, ((ScheduledMessage)this.getObject()).getDestination());
        return true;
    }

    private boolean removeSelectedDestination() {
        List destinations;
        MessageDestination selected = this.getMessageDestinationTable().getSelectedObject();
        if (selected != null && (destinations = ((ScheduledMessage)this.getObject()).getDestination()).contains(selected)) {
            destinations.remove(selected);
            selected.delete();
            OfficeMateAdminGuiUtils.getInstance().refreshList(this.destinationList, ((ScheduledMessage)this.getObject()).getDestination());
            return true;
        }
        return false;
    }

    private ComboBoxModel getWeekdayComboboxModel() {
        if (this.weekdayComboboxModel == null) {
            this.weekdayComboboxModel = new ListComboBoxModel(this.getWeekdayList());
        }
        return this.weekdayComboboxModel;
    }

    private EventList<String> getWeekdayList() {
        if (this.weekdayList == null) {
            List<String> weekdaysList = Arrays.asList(new DateFormatSymbols().getWeekdays());
            ArrayList<String> capitalweekdays = new ArrayList<String>();
            for (String day : weekdaysList) {
                if (day.equals("")) continue;
                capitalweekdays.add(day.toUpperCase());
            }
            this.weekdayList = GlazedLists.eventList(capitalweekdays);
        }
        return this.weekdayList;
    }

    private EventList<Command> getCommandList() {
        if (this.commandList == null) {
            this.commandList = GlazedLists.eventList((Collection)Command.getAllCommands());
        }
        return this.commandList;
    }
}

