/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.messaging.sms;

import au.com.ordermate.gui.ObjectEditor;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.DefaultPropertySearcher;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import javax.swing.Action;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractEditableTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.messaging.sms.SmsSenderPanelWrapper;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.message.SmsLog;
import ordermate.database.users.AllPermissions;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class SmsHistoryState
extends AbstractEditableTableState<SmsLog> {
    public SmsHistoryState() {
        super("SMS History", AllPermissions.MESSAGING, "See the SMS History.");
        this.addAction((Action)new SmsSenderPanelWrapper().getSendAction());
    }

    @Override
    protected ObjectEditor<SmsLog> createObjectEditor() {
        return null;
    }

    @Override
    public String getTypeName() {
        return "SMS Log";
    }

    @Override
    public boolean canCreateOrDelete() {
        return false;
    }

    @Override
    public TableStateCentralArea<SmsLog> createCentralArea() {
        PersistentObjectTable<SmsLog> table = new PersistentObjectTable<SmsLog>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Date/Time", SmsLog.Properties.TIMESTAMP), new PropertyColumnFormat(SmsLog.Properties.USER), new PropertyColumnFormat("Message Text", SmsLog.Properties.TEXT), new PropertyColumnFormat(SmsLog.Properties.DESTINATION)}));
        return table;
    }

    @Override
    protected Class<SmsLog> getDisplayingType() {
        return SmsLog.class;
    }

    @Override
    protected OfficeMateObjectSearch<SmsLog> createSearchPanelFactory() {
        SmsHistorySearch guiSearch = new SmsHistorySearch();
        RefreshAction refresh = new RefreshAction((Refreshable)guiSearch);
        DateRangeSearchField searchField = new DateRangeSearchField("Date Filter", guiSearch.getSearcher().getDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)refresh);
        guiSearch.addSearchField((SearchGuiField)searchField);
        return guiSearch;
    }

    private class SmsHistorySearcher
    extends DefaultPropertySearcher<SmsLog> {
        private final RangeQuerySearchFilter<Date> dateRangeFilter;

        public SmsHistorySearcher() {
            super(SmsLog.class);
            this.dateRangeFilter = new OptimisedDateRangeSearchFilter(SmsLog.Properties.TIMESTAMP, SQLDateType.TIMESTAMP);
            this.addSearchFilter((SearchFilterI)this.dateRangeFilter);
        }

        public IRangedQuerySearchFilter<Date> getDateRangeFilter() {
            return this.dateRangeFilter;
        }
    }

    private class SmsHistorySearch
    extends ObjectPropertySearch<SmsLog> {
        private SmsHistorySearcher searcher;

        public SmsHistorySearch() {
            super(SmsLog.class);
            this.searcher = new SmsHistorySearcher();
        }

        @Override
        public void resetSearch() {
        }

        @Override
        protected ObjectQuerySearcher<SmsLog> constructPropertySearcher() {
            return this.getSearcher();
        }

        public SmsHistorySearcher getSearcher() {
            return this.searcher;
        }
    }
}

