/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports;

import au.com.ordermate.persistence.CSVPropertiedObjExporter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.csvwritestrategy.DefaultPersistentObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.PropertiedObjCSVWriteStrategy;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.CSVColumn;
import au.com.ordermate.persistence.csvwritestrategy.csvcolumn.PropertyAccessorCSVColumn;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import officemate.OfficeMate;
import officemate.adminkit.columnformats.csv.GenericCSVColumn;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;
import org.jfree.ui.FilesystemFilter;

public class CSVExportAction<T extends PropertiedObject>
extends AbstractAction {
    private EventList<T> exportList;
    private String defaultFileName;
    private ColumnFormat[] columns;
    private List<PropertyAccessor> propsAccessors;
    private PropertiedObjCSVWriteStrategy<T> writeStrategy;

    public CSVExportAction(EventList<T> listOfExports, ColumnFormat[] columns, String defFilename) {
        super("Export to CSV", IconLoader.get((String)"/ordermate/images/left_arrow.png"));
        this.exportList = listOfExports;
        this.columns = columns;
        this.writeStrategy = new DefaultPersistentObjCSVWriteStrategy(this.createCSVColumns(columns));
        this.defaultFileName = defFilename;
    }

    private List<CSVColumn> createCSVColumns(ColumnFormat[] colFormats) {
        ArrayList<CSVColumn> toReturn = new ArrayList<CSVColumn>();
        for (ColumnFormat colFormat : colFormats) {
            if (colFormat instanceof PropertyColumnFormat) {
                toReturn.add((CSVColumn)new PropertyAccessorCSVColumn(colFormat.getName().replaceAll("\\<[^>]*>", ""), ((PropertyColumnFormat)colFormat).getPropertyAccessor(), ((PropertyColumnFormat)colFormat).getFormatter()));
                continue;
            }
            toReturn.add(new GenericCSVColumn(colFormat.getName(), colFormat));
        }
        return toReturn;
    }

    public void setName(String newName) {
        this.putValue("Name", newName);
    }

    public void setIcon(ImageIcon newIcon) {
        this.putValue("SmallIcon", newIcon);
    }

    public void setCSVWriteStrategy(PropertiedObjCSVWriteStrategy<T> toSet) {
        this.writeStrategy = toSet;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        this.exportList.getReadWriteLock().readLock().lock();
        ArrayList<T> items = new ArrayList<T>(this.exportList);
        this.exportList.getReadWriteLock().readLock().unlock();
        String filename = this.defaultFileName;
        JFileChooser fileChooser = new JFileChooser(filename);
        fileChooser.setFileFilter((FileFilter)new FilesystemFilter("csv", "csv"));
        fileChooser.setSelectedFile(new File(this.defaultFileName));
        if (fileChooser.showSaveDialog(OfficeMate.getApplicationFrame()) == 0 && (file = fileChooser.getSelectedFile()) != null) {
            List objsToExport = this.writeStrategy.compileExportData(items);
            CSVPropertiedObjExporter exporter = new CSVPropertiedObjExporter(this.writeStrategy);
            try {
                exporter.export(file, objsToExport);
                Dialogs.showInfoDialog("Exported successfully", "Successfully exported to : " + file.getAbsolutePath());
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Could not export item sold", (Throwable)ex);
                Dialogs.showErrorDialog("Could not export", "Unable to export to " + filename + " see logs for details.");
            }
        }
    }
}

