/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.covers;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.SingleValueQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.util.DateTimeUtils;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.util.Collection;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.objectsearch.CustomerSearcherGui;
import officemate.components.search.searchfield.ObjectSearchField;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.reports.CoversReport;
import ordermate.database.reports.covers.CoversReportProvider;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.searchers.reports.CoversReportSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class CoversReportSearchState
extends AbstractTableState
implements SearchGuiState {
    private final RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private final EventList customerCategories = GlazedLists.eventList((Collection)CustomerCategory.getAllCategories());
    private final CoversReportSearcher searcher;
    private final CoversReportProvider provider;

    public CoversReportSearchState(CoversReportProvider reportProvider, String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        this.searcher = reportProvider.getSearcher();
        this.provider = reportProvider;
    }

    protected TableStateCentralArea createCentralArea() {
        String[] titles = this.provider.getColumnTitles();
        PropertiedObject.Property[] props = this.provider.getColumnProperties();
        PersistentObjectTable centralTable = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat(titles[0], props[0]), new PropertyColumnFormat(titles[1], props[1]), new PropertyColumnFormat(titles[3], props[3]), new PropertyColumnFormat(titles[2], props[2]), new PropertyColumnFormat(titles[4], props[4])}));
        centralTable.add((Component)this.getSearchFactory().getSearchPanel(), "North");
        return centralTable;
    }

    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch guiSearch = new ObjectPropertySearch(this.getDisplayingType(), (EventList)new BasicEventList()){

            protected ObjectQuerySearcher constructPropertySearcher() {
                return CoversReportSearchState.this.searcher;
            }
        };
        guiSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        guiSearch.addSearchField(new ObjectSearchField((SingleValueQuerySearchFilter)this.searcher.getCustomerFilter(), (OfficeMateObjectSearch)new CustomerSearcherGui(this.customerCategories), CustomerSearcherGui.DEFAULT_TABLE_FORMAT, "Customer", (Action)this.refreshAction));
        guiSearch.addSearchField((SearchGuiField)new ComboSearchField("Customer Category", this.searcher.getCustomerCategoryFilter(), true, (Action)this.refreshAction, this.customerCategories));
        guiSearch.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        guiSearch.addSearchField(new TimeRangeSearchField(this.searcher.getTimeSearchFilter(), (Action)this.refreshAction));
        return guiSearch;
    }

    protected Class getDisplayingType() {
        return CoversReport.class;
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.refresh();
    }

    public ObjectQuerySearcher getSearcher() {
        return this.searcher;
    }
}

