/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.custom;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.search.control.DateRangePanel;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.components.search.searchfield.PeriodReportSelector;
import officemate.screens.reports.custom.CustomReportStateHelper;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.reports.dynamicjasper.ArbitraryPeriodReportAdapter;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

class CustomReportJasperToolbarFactory
extends JasperToolbarFactory {
    private JComboBox<CustomReport> reportCombo;
    private PeriodReportSelector periodPanel;
    private DateRangePanel rangePanel;
    private RefreshAction refresh;
    private User currentUser;
    private final boolean showReportCombo;

    CustomReportJasperToolbarFactory(RefreshAction refresh, User user, boolean showReportCombo) {
        this.refresh = refresh;
        this.currentUser = user;
        this.showReportCombo = showReportCombo;
    }

    public PeriodReportAdapter getAdapter() {
        PeriodReportAdapter adapter = this.periodPanel.getAdapter();
        boolean reversal = PeriodReportAdapter.WEEK_ENDING.equals(adapter);
        Date start = DateTimeUtils.getStartOfDay((Date)(reversal ? this.rangePanel.getEndDate() : this.rangePanel.getStartDate()));
        Date end = DateTimeUtils.getEndOfDay((Date)(reversal ? this.rangePanel.getStartDate() : this.rangePanel.getEndDate()));
        if (!start.equals(DateTimeUtils.getStartOfDay((Date)this.periodPanel.getStartDate())) || !end.equals(DateTimeUtils.getEndOfDay((Date)this.periodPanel.getEndDate()))) {
            adapter = new ArbitraryPeriodReportAdapter(start, end);
        }
        return adapter;
    }

    @Override
    protected JPanel getCustomReportControlPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        this.periodPanel = new PeriodReportSelector("Period", (Action)this.refresh);
        this.periodPanel.changed.connect((Object)this, "periodChanged");
        this.rangePanel = new DateRangePanel();
        if (this.showReportCombo) {
            this.reportCombo = new JComboBox();
            ComponentUtils.setupComboBox(this.reportCombo);
            builder.addRow("Report", this.reportCombo);
        }
        builder.addRow(this.periodPanel.getJLabelForComponent(), this.periodPanel.getGuiComponent());
        builder.addRow("Effective Date Range", (Component)this.rangePanel);
        return builder.getPanel();
    }

    public JComboBox<CustomReport> getReportCombo() {
        return this.reportCombo;
    }

    public PeriodReportSelector getPeriodPanel() {
        return this.periodPanel;
    }

    public void updateReports() {
        if (this.reportCombo != null) {
            this.reportCombo.removeAllItems();
            for (CustomReport report : CustomReportStateHelper.getCustomReportsToDisplay(this.currentUser)) {
                this.reportCombo.addItem(report);
            }
        }
    }

    public void periodChanged() {
        if (PeriodReportAdapter.WEEK_ENDING.equals(this.periodPanel.getAdapter())) {
            this.rangePanel.setStartDate(this.periodPanel.getEndDate());
            this.rangePanel.setEndDate(this.periodPanel.getStartDate());
        } else {
            this.rangePanel.setStartDate(this.periodPanel.getStartDate());
            this.rangePanel.setEndDate(this.periodPanel.getEndDate());
        }
    }
}

