/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.custom;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.config.custompermission.CustomPermission;
import ordermate.database.config.custompermission.CustomPermissionHelper;
import ordermate.database.config.custompermission.CustomPermissionSearcher;
import ordermate.database.hardware.Terminal;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.reports.config.custom.manager.CustomReportManagerRemote;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;

public class CustomReportStateHelper {
    public static List<CustomReport> getCustomReportsToDisplay(User user) {
        ArrayList<CustomReport> toReturn = new ArrayList<CustomReport>();
        for (CustomReport report : CustomReportStateHelper.getAllTopLevelCustomReports()) {
            if (!CustomPermissionHelper.isPermitted((String)"Custom Report", (String)report.getTitle(), (PermissionGroup)user.getCachedPermissionGroup(), (boolean)true)) continue;
            toReturn.add(report);
        }
        toReturn.addAll(CustomReportStateHelper.getAllTransientCustomReports());
        return toReturn;
    }

    public static CustomReportManagerRemote getCustomReportManager() throws Exception {
        return (CustomReportManagerRemote)SimpleRMI.getObject((InetAddress)Terminal.getServerMateTerminal().getAddress(), (String)"CustomReportManagerRemote", (int)11100);
    }

    public static List<CustomReport> getAllTransientCustomReports() {
        try {
            CustomReportManagerRemote reportMan = CustomReportStateHelper.getCustomReportManager();
            return reportMan.getAvailableCustomReports();
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Failed to get CustomReportManagerRemote over RMI!", (Throwable)e);
            return new ArrayList<CustomReport>(0);
        }
    }

    public static List<CustomReport> getAllTopLevelCustomReports() {
        return PersistenceManager.getObjectList(CustomReport.class, (String)Query.select(CustomReport.class).isNull(CustomReport.Properties.PARENT).toString());
    }

    public static List<String> getAllTopLevelCustomReportNames() {
        List<CustomReport> customReports = CustomReportStateHelper.getAllTopLevelCustomReports();
        ArrayList<String> toReturn = new ArrayList<String>();
        for (CustomReport report : customReports) {
            toReturn.add(report.getTitle());
        }
        return toReturn;
    }

    public static void updateAffectedCustomPermissions(CustomReport report) {
        CustomReport unchangedObject;
        if (report.isPersistent() && !(unchangedObject = (CustomReport)PersistenceManager.getByID((long)report.getID(), CustomReport.class)).getTitle().equals(report.getTitle())) {
            CustomPermission permission;
            CustomPermissionSearcher searcher = new CustomPermissionSearcher();
            searcher.getCategoryFilter().setSearchValue("Custom Report");
            searcher.getPermissionKeyFilter().setSearchValue(unchangedObject.getTitle());
            searcher.setLimit(1);
            List results = searcher.search();
            CustomPermission customPermission = permission = results.isEmpty() ? null : (CustomPermission)results.get(0);
            if (permission != null) {
                permission.setPermissionKey(report.getTitle());
                permission.save();
            }
        }
    }
}

