/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.dailysales;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.dailysales.DailySalesReport;
import ordermate.database.searchers.reports.dailysales.DailySalesReportCompiler;
import org.apache.commons.lang.NotImplementedException;

public class DailySalesReportSearchControl
extends AbstractObjectSearch<DailySalesReport> {
    private DailySalesReportCompiler compiler;
    private EventList<TradingDay> tradingDays;
    private ComboSearchField tradingDaySearch;

    public DailySalesReportSearchControl(DailySalesReportCompiler compiler) {
        super(new BasicEventList());
        this.compiler = compiler;
        this.reaquireSearchOptions();
    }

    @Override
    public void resetSearch() {
        if (!this.tradingDays.isEmpty()) {
            this.tradingDaySearch.setSelectedObject(this.tradingDays.get(this.tradingDays.size() - 1));
        }
    }

    @Override
    public void reaquireSearchOptions() {
        if (this.tradingDays != null) {
            this.tradingDays.clear();
            ArrayList allDays = new ArrayList(TradingDay.getAllTradingDays());
            Collections.reverse(allDays);
            this.tradingDays.addAll(allDays);
        }
    }

    @Override
    public JPanel createSearchPanel() {
        SearchBarPanel panel = new SearchBarPanel();
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        this.tradingDays = GlazedLists.eventList((Collection)TradingDay.getAllTradingDays());
        this.tradingDaySearch = new ComboSearchField("Date:", this.compiler.getSearcher().getTradingDayFilter(), false, (Action)refresh, this.tradingDays);
        this.resetSearch();
        panel.addSearchField((SearchGuiField)this.tradingDaySearch);
        panel.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.compiler.getSearcher().getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return panel;
    }

    @Override
    protected void doRefresh() {
        this.clearObjectList();
        this.copyIntoObjectList(this.compiler.compileResults());
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        throw new NotImplementedException("This has not been implemented for this class");
    }
}

