/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.dailysales;

import au.com.ordermate.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.dailysales.DailySalesReportSearchControl;
import ordermate.database.reports.dailysales.DailySalesReport;
import ordermate.database.searchers.reports.dailysales.DailySalesReportCompiler;
import ordermate.database.searchers.reports.dailysales.DailySalesReportSearcher;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class DailySalesReportSearchState
extends AbstractTableState<DailySalesReport>
implements SearchGuiState,
ActionListener {
    private DailySalesReportCompiler compiler;
    private JCheckBox hidePeriodsWithNoData;
    private DailySalesReportSearchControl searchControl;

    public DailySalesReportSearchState(DailySalesReportCompiler compiler) {
        super("Search", null, "Select date to report on.");
        this.compiler = compiler;
    }

    @Override
    protected TableStateCentralArea<DailySalesReport> createCentralArea() {
        ColumnTableFormat colFormat = new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat(DailySalesReport.Properties.START_TIME).setName("Time").setCustomRenderer((TableCellRenderer)new TimePeriodRenderer()), new PropertyColumnFormat(DailySalesReport.Properties.SALES), new PropertyColumnFormat(DailySalesReport.Properties.PATRONS).setCustomRenderer((TableCellRenderer)new PatronRenderer()), new PropertyColumnFormat(DailySalesReport.Properties.TRADE_VOLUME)});
        return new PersistentObjectTable<DailySalesReport>(this.getObjectList(), colFormat);
    }

    @Override
    protected Class<DailySalesReport> getDisplayingType() {
        return DailySalesReport.class;
    }

    public DailySalesReportSearcher getSearcher() {
        return this.compiler.getSearcher();
    }

    @Override
    protected OfficeMateObjectSearch<DailySalesReport> createSearchPanelFactory() {
        this.searchControl = new DailySalesReportSearchControl(this.compiler);
        JPanel panel = this.searchControl.getSearchPanel();
        JPanel additionalOptionsPanel = new JPanel();
        this.hidePeriodsWithNoData = new JCheckBox();
        this.hidePeriodsWithNoData.addActionListener(this);
        additionalOptionsPanel.add(new JLabel("Hide Periods With No Sales Or Trade Volume"));
        additionalOptionsPanel.add(this.hidePeriodsWithNoData);
        panel.add((Component)additionalOptionsPanel, "East");
        return this.searchControl;
    }

    private void hidePeriodsWithNoData() {
        this.compiler.setFilterPeriodsWithNoSalesData(this.hidePeriodsWithNoData.isSelected());
        this.searchControl.doRefresh();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.hidePeriodsWithNoData) {
            this.hidePeriodsWithNoData();
        }
    }

    private class PatronRenderer
    extends DefaultTableCellRenderer {
        PatronRenderer() {
            this.setHorizontalAlignment(2);
        }
    }

    static class TimePeriodRenderer
    extends DefaultTableCellRenderer {
        TimePeriodRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Calendar startTime = DateTimeUtils.getCalendar((Date)((Date)value));
            Calendar endTime = DateTimeUtils.getCalendar((Date)startTime.getTime());
            endTime.add(12, 30);
            String displayTxt = DateTimeUtils.get24HFormat().format(startTime.getTime()) + " - " + DateTimeUtils.get24HFormat().format(endTime.getTime());
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText(displayTxt);
            } else if (comp instanceof JLabel) {
                ((JLabel)comp).setText(displayTxt);
            }
            return comp;
        }
    }
}

