/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.finance;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.finance.CashDrawerDenominationAggregateReportProvider;
import ordermate.database.reports.finance.DenominationReportCompiler;
import ordermate.database.users.AllPermissions;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class DenominationReportState
extends JasperReportState {
    private static EventList<TradingDay> days;

    public DenominationReportState() {
        super((ReportProvider)new CashDrawerDenominationAggregateReportProvider(new DenominationReportCompiler()), "Denomination Report", AllPermissions.SKIMS, "View your Reconciliation and Skims by currency denomination");
    }

    public static void clearTradingDays() {
        days.clear();
    }

    public static EventList<TradingDay> getTradingDays() {
        return days;
    }

    @Override
    protected JasperToolbarFactory createJasperToolbarFactory() {
        days = new BasicEventList();
        final RefreshAction refresh = new RefreshAction((Refreshable)this);
        JasperToolbarFactory factory = new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                JPanel fields = new JPanel();
                fields.add(new JLabel("Trading Day"));
                fields.add(new ComboSearchField("Trading Day", (ISingleValueSearchFilter)((CashDrawerDenominationAggregateReportProvider)DenominationReportState.this.getProvider()).getCompiler().getSearcher().getTradingDayFilter(), false, (Action)refresh, days).getGuiComponent());
                return fields;
            }
        };
        return factory;
    }

    @Override
    protected void onStart() {
        days.clear();
        ArrayList allDays = new ArrayList(TradingDay.getAllTradingDays());
        Collections.reverse(allDays);
        days.addAll(allDays);
        super.onStart();
    }
}

