/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.hourlysales;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import officemate.components.search.AbstractObjectSearch;
import officemate.components.search.SearchBarPanel;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.hourlysales.HourlySalesCollation;
import ordermate.database.reports.hourlysales.HourlySalesCompiler;
import org.apache.commons.lang.NotImplementedException;

class HourlySalesReportSearchControl
extends AbstractObjectSearch<HourlySalesCollation> {
    private EventList<TradingDay> tradingDays;
    private ComboSearchField tradingDaySearch;
    private HourlySalesCompiler compiler;

    public HourlySalesReportSearchControl(HourlySalesCompiler yourCompiler, RefreshAction refresh) {
        super(new BasicEventList());
        this.compiler = yourCompiler;
        this.tradingDays = new BasicEventList();
        this.tradingDaySearch = new ComboSearchField("Trading Day", (ISingleValueSearchFilter)this.compiler.getData().getSearcher().getTradingDayFilter(), false, (Action)refresh, this.tradingDays);
        this.tradingDays.addAll((Collection)TradingDay.getAllTradingDays());
        Collections.reverse(this.tradingDays);
        this.tradingDaySearch.setListData(this.tradingDays);
    }

    @Override
    public void doRefresh() {
        this.clearObjectList();
        List collated = this.compiler.compileReports();
        this.copyIntoObjectList(collated);
    }

    @Override
    public void resetSearch() {
        this.tradingDaySearch.reset();
    }

    @Override
    public void reaquireSearchOptions() {
        this.tradingDays.clear();
        ArrayList allDays = new ArrayList(TradingDay.getAllTradingDays());
        Collections.reverse(allDays);
        this.tradingDays.addAll(allDays);
    }

    @Override
    public JPanel createSearchPanel() {
        RefreshAction refresh = new RefreshAction((Refreshable)this);
        SearchBarPanel panel = new SearchBarPanel();
        panel.addSearchField("Trading Day", this.tradingDaySearch.getGuiComponent());
        panel.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.compiler.getData().getSearcher().getSalesLocationFilter(), (Action)refresh, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return panel;
    }

    @Override
    public void addToSearchPanel(JComponent comp) {
        throw new NotImplementedException("This has not been implemented for this class");
    }
}

