/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.itemgp;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.sql.queries.Operator;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;
import officemate.adminkit.MenuGroupTreePanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.print.Printing;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.searchpanels.InventoryItemSearchPanel;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.PriceGroupedTableModel;
import officemate.adminkit.table.QueryTable;
import officemate.screens.ObjectManagerI;
import officemate.screens.reports.cogs.SQLDeletedItemsLookDifferentCellRenderer;
import officemate.screens.reports.itemgp.ItemGPTableModel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.reports.itemgp.ItemGPQueries;
import ordermate.database.reports.itemgp.ItemGPSearcher;
import ordermate.database.users.AllPermissions;

public class ItemGPReportState
extends BasicOfficeMateState {
    private JPanel innerPanel = new JPanel(new BorderLayout());
    private JPanel northPanel;
    private JPanel northWestPanel;
    private JPanel northEastPanel;
    private JPanel tablePanel;
    private JPanel rightPanel;
    private JPanel eastPanel;
    private JPanel southPanel;
    private JSplitPane splitter;
    private MenuGroupTreePanel treePanel = null;
    private JComboBox profilesCombo;
    private LinkedTotalTable totalsTable;
    private GroupedTable groupedTable;
    private JCheckBox groupedCheck;
    private boolean groupResults = true;
    private JSpinner profitableLevel;
    private JComboBox profitableComboBox;
    private RowFilter filter;
    private SelectQuery query;
    private QueryTable table;
    private ItemGPSearcher searcher;
    private ItemGPTableModel tableModel;
    private boolean alreadySetup = false;
    private boolean allowUpdate = true;

    public ItemGPReportState() {
        super("Item GP", AllPermissions.ACCESS_ITEM_GP_REPORT, "Item Gross Profit Report, shows GP per item at current cost");
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Item GP Report screen...");
        if (InventoryProfile.getAllProfiles().size() == 0) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "To view the Item GP Report, please ensure that you have set up at least one Menu Profile.", "Can't view Item GP Report", 2);
            if (this.alreadySetup) {
                this.refresh();
            }
        } else if (!this.alreadySetup) {
            this.alreadySetup = Dialogs.showProgressDialog((AbstractTask)new ItemGPSetupTask());
            if (!this.alreadySetup) {
                Dialogs.showErrorDialog("Error Loading Screen", "Please contact OrderMate Support");
                return;
            }
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    protected void onEnd() {
    }

    private void setupGUI() {
        this.splitter = new JSplitPane();
        this.northPanel = new JPanel(new BorderLayout());
        this.northWestPanel = new JPanel(new FlowLayout());
        this.northEastPanel = new JPanel(new FlowLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.tablePanel = new JPanel(new BorderLayout());
        this.eastPanel = new JPanel(new BorderLayout());
        this.southPanel = new JPanel(new GridLayout(2, 1));
        this.tablePanel.add((Component)this.southPanel, "South");
        this.rightPanel.add((Component)this.eastPanel, "East");
        this.splitter.setRightComponent(this.rightPanel);
        this.rightPanel.add((Component)this.tablePanel, "Center");
        this.innerPanel.add((Component)this.splitter, "Center");
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.northPanel.add((Component)this.northEastPanel, "East");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupMenuProfileCombo() {
        this.profilesCombo = new JComboBox(InventoryProfile.getAllProfiles());
        this.profilesCombo.setName("Profiles");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.profilesCombo);
        this.profilesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ItemGPReportState.this.allowUpdate) {
                    ItemGPReportState.this.refresh();
                }
            }
        });
        this.northWestPanel.add(new JLabel("Menu Profiles: "));
        this.northWestPanel.add(this.profilesCombo);
        this.northPanel.add((Component)this.northWestPanel, "West");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupGroupCheck() {
        this.groupedCheck = new JCheckBox("Group results", this.groupResults);
        this.northWestPanel.add(this.groupedCheck);
        this.groupedCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemGPReportState.this.groupResults = ItemGPReportState.this.groupedCheck.isSelected();
                ItemGPReportState.this.profitableComboBox.setEnabled(!ItemGPReportState.this.groupResults);
                ItemGPReportState.this.profitableLevel.setEnabled(!ItemGPReportState.this.groupResults);
                ItemGPReportState.this.refresh();
            }
        });
    }

    private void setupProfitable() {
        this.northEastPanel.add(new JLabel("Gross Profit"));
        this.profitableLevel = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        this.northEastPanel.add(this.profitableLevel);
        this.profitableComboBox = new JComboBox<Object>(new Object[]{"Any", Operator.LESS_THAN, Operator.GREATER_THAN});
        this.profitableComboBox.setName("Gross Profit");
        this.profitableComboBox.setToolTipText("Select < for lesser than, > for greater than or Any for any GP %.");
        this.profitableComboBox.setEnabled(!this.groupResults);
        ComponentUtils.setupComboBox((JComboBox)this.profitableComboBox);
        this.profitableLevel.setEnabled(!this.groupResults);
        this.profitableLevel.setToolTipText("Select the % GP value to filter.");
        this.northEastPanel.add(this.profitableComboBox);
    }

    private void setupTree() {
        this.treePanel = new MenuGroupTreePanel(((ObjectManagerI)GuiApp.getAppComplex().getApplicationContext()).getObjectManager(), this.getCurrentMenuProfile());
        this.treePanel.objectSelected.connect((Object)this, "gotTreeObjectSelected");
        this.splitter.setLeftComponent(this.treePanel);
    }

    private void setupTable() {
        this.query = this.getSearcher().getSelectQuery();
        this.tableModel = new ItemGPTableModel(this.query, GuiApp.getAppComplex().getApplicationContext().getDatabaseConnection(), "inventory_item_unit.ID", ItemGPQueries.dbColumns, ItemGPQueries.displayColumns);
        this.tableModel.addTotalColumn("Cost");
        this.tableModel.addTotalColumn("CostEx");
        this.tableModel.addTotalColumn("inventory_unit_price_level_link.Price");
        this.tableModel.addTotalColumn("GPPercent");
        this.tableModel.addTotalColumn("GPValue");
        this.table = new QueryTable(this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup(this.table);
        SQLDeletedItemsLookDifferentCellRenderer renderer = new SQLDeletedItemsLookDifferentCellRenderer();
        this.table.setCellRendererForAll(renderer);
        this.filter = new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                if (!ItemGPReportState.this.groupResults && ItemGPReportState.this.profitableComboBox.getSelectedIndex() > 0) {
                    Double columnValue = (Double)entry.getValue(entry.getValueCount() - 2);
                    if (null == columnValue) {
                        return false;
                    }
                    double gpPercent = (Double)entry.getValue(entry.getValueCount() - 2);
                    double level = ((Integer)ItemGPReportState.this.profitableLevel.getValue()).doubleValue();
                    Operator op = (Operator)ItemGPReportState.this.profitableComboBox.getSelectedItem();
                    if (Operator.GREATER_THAN == op) {
                        return gpPercent > level;
                    }
                    return gpPercent < level;
                }
                return true;
            }
        };
        TableRowSorter<ItemGPTableModel> sorter = new TableRowSorter<ItemGPTableModel>(this.tableModel);
        sorter.setRowFilter(this.filter);
        this.table.setRowSorter(sorter);
        this.tablePanel.add((Component)this.table.getScroller(), "Center");
    }

    private GroupedTable getNewGroupedTable() {
        PriceGroupedTableModel model = new PriceGroupedTableModel((AbstractTableModel)this.table.getModel(), "Group", new String[0]);
        this.groupedTable = new GroupedTable(model);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)((Object)this.groupedTable));
        return this.groupedTable;
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.allowUpdate = false;
        if (this.treePanel == null) {
            this.allowUpdate = true;
            return;
        }
        Object treeSel = this.treePanel.getTree().getSelectedObject();
        Object comboSel = this.profilesCombo.getSelectedItem();
        this.profilesCombo.setModel(new DefaultComboBoxModel(InventoryProfile.getAllProfiles()));
        this.profilesCombo.setSelectedItem(comboSel);
        this.treePanel.setMenuProfile(this.getCurrentMenuProfile());
        this.treePanel.getTree().setSelectedObject(treeSel);
        Long selectedID = OfficeMateAdminGuiUtils.getInstance().getSelectedID(this.table, this.groupResults ? this.groupedTable : null);
        int selectedTableRow = OfficeMateAdminGuiUtils.getInstance().getSelectedTableRow(this.table, this.groupResults ? this.groupedTable : null);
        this.updateQuery(this.getCurrentMenuProfile(), this.getCurrentMenuGroup());
        OfficeMateAdminGuiUtils.getInstance().selectIfPossible(this.table, this.groupResults ? this.groupedTable : null, selectedID, selectedTableRow);
        this.allowUpdate = true;
    }

    @Override
    public boolean supportsSearch() {
        return true;
    }

    @Override
    public void doSearchAction() {
        InventoryItemSearchPanel searchPanel = new InventoryItemSearchPanel(this.getCurrentMenuProfile());
        Long id = SearchDialog.search(GuiApp.getAppComplex().getApplicationFrame().getFrame(), searchPanel, "Find Menu Item...");
        if (id != null) {
            JScrollPane scrollerToUse;
            Object tableToUse;
            int tableRow;
            this.treePanel.getTree().setSelectedObject(null);
            int originalRow = this.table.getQueryTableModel().getRow(id);
            if (this.groupResults) {
                tableRow = this.groupedTable.getGroupedTableModel().getGroupedRow(originalRow);
                this.groupedTable.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.groupedTable;
                scrollerToUse = this.groupedTable.getScroller();
            } else {
                tableRow = originalRow;
                this.table.setRowSelectionInterval(tableRow, tableRow);
                tableToUse = this.table;
                scrollerToUse = this.table.getScroller();
            }
            GuiUtils.scrollToTableRow((JScrollPane)scrollerToUse, (JTable)tableToUse, (int)tableRow);
            ((JComponent)tableToUse).revalidate();
            ((Component)tableToUse).repaint();
        }
    }

    public void updateQuery(InventoryProfile profile, InventoryGroup group) {
        this.searcher.getProfileFilter().setSearchValue((Object)profile);
        this.searcher.getGroupFilter().setSearchValue((Object)group);
        this.searcher.getGroupedFilter().setSearchValue((Object)this.groupResults);
        this.query = this.searcher.getSelectQuery();
        this.tableModel.setQuery(this.query);
        this.table.updateModel();
        this.tablePanel.remove(this.table.getScroller());
        if (this.groupedTable != null) {
            this.tablePanel.remove(this.groupedTable.getScroller());
        }
        if (this.groupResults) {
            this.tablePanel.add((Component)this.getNewGroupedTable().getScroller(), "Center");
        } else {
            this.tablePanel.add((Component)this.table.getScroller(), "Center");
        }
        this.setupTotalsPanel();
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
        this.totalsTable.repaint();
    }

    private Number[] getCorrectTotals(Number[] theNormalTotals) {
        Number[] normalTotals = theNormalTotals;
        if (this.groupResults) {
            int titleColumn = this.tableModel.findColumn("Group");
            Number[] newTotals = new Number[normalTotals.length - 1];
            int write = 0;
            for (int read = 0; read < normalTotals.length; ++read) {
                if (read == titleColumn) continue;
                newTotals[write++] = normalTotals[read];
            }
            normalTotals = newTotals;
        }
        return normalTotals;
    }

    public JTable getActiveTable() {
        return this.groupResults ? this.groupedTable : this.table;
    }

    private void setupTotalsPanel() {
        if (this.tablePanel != null && this.totalsTable != null) {
            this.tablePanel.remove(this.totalsTable);
        }
        this.totalsTable = new LinkedTotalTable(this.getActiveTable().getColumnModel());
        this.totalsTable.setName("Totals");
        this.tablePanel.add((Component)this.totalsTable, "South");
        Number[] totals = this.tableModel.getTotals();
        this.totalsTable.setColumnValues(this.getCorrectTotals(totals));
    }

    @Override
    public void doPrintAction() {
        DateDMY now = new DateDMY(System.currentTimeMillis());
        String title = "Item Gross Profit Report at " + now;
        InventoryProfile profile = this.getCurrentMenuProfile();
        InventoryGroup group = this.getCurrentMenuGroup();
        String profileString = profile != null ? " Profile: " + profile.getLabel() : "";
        String groupString = group != null ? " Group: " + group.getLabel() : "";
        Printing.printJTableReport(this.getActiveTable(), title, profileString + groupString, 8, null);
    }

    private InventoryProfile getCurrentMenuProfile() {
        return (InventoryProfile)this.profilesCombo.getSelectedItem();
    }

    private InventoryGroup getCurrentMenuGroup() {
        Object obj = this.treePanel.getSelectedObject();
        return obj instanceof InventoryGroup ? (InventoryGroup)obj : null;
    }

    void gotTreeObjectSelected(Object obj) {
        if (this.allowUpdate) {
            InventoryGroup group = null;
            if (obj instanceof InventoryGroup) {
                group = (InventoryGroup)obj;
            }
            this.updateQuery(this.getCurrentMenuProfile(), group);
            if (this.table != null && this.table.getRowCount() > 0) {
                this.table.setRowSelectionInterval(0, 0);
            }
        }
    }

    ItemGPSearcher getSearcher() {
        if (this.searcher == null) {
            this.searcher = new ItemGPSearcher();
        }
        return this.searcher;
    }

    private class ItemGPSetupTask
    extends AbstractGuiTask {
        private ItemGPSetupTask() {
        }

        public String getName() {
            return "Loading Item GP Report screen...";
        }

        public void doGuiTask() throws Exception {
            ItemGPReportState.this.setupGUI();
            this.emitProgress();
            ItemGPReportState.this.setupMenuProfileCombo();
            this.emitProgress();
            ItemGPReportState.this.setupGroupCheck();
            this.emitProgress();
            ItemGPReportState.this.setupTree();
            this.emitProgress();
            ItemGPReportState.this.setupProfitable();
            this.emitProgress();
            ItemGPReportState.this.setupTable();
            this.emitProgress();
            ItemGPReportState.this.getNewGroupedTable();
            ItemGPReportState.this.splitter.setDividerLocation(160);
            this.emitProgress();
        }

        public int getTotalSubTasks() {
            return 6;
        }
    }
}

