/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.itemssold.substates;

import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.screens.reports.itemssold.SalesReportState;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReportProvider;
import ordermate.database.searchers.reports.sales.general.itemsold.ItemSoldReportCompiler;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;

public class DailyItemSoldState
extends JasperReportState {
    private EventList<TradingDay> tradingDays;
    private final ItemSoldReportCompiler compiler;
    private final ItemSoldReportProvider reportProvider;
    private JCheckBox showCOGSCheckBox;

    public DailyItemSoldState(ItemSoldReportCompiler itemSoldReportCompiler) {
        this(itemSoldReportCompiler, SalesReportState.getItemSoldPermission());
    }

    public DailyItemSoldState(ItemSoldReportCompiler itemSoldReportCompiler, Permission permission) {
        super(null, "Report", permission, "");
        this.compiler = itemSoldReportCompiler;
        this.reportProvider = new ItemSoldReportProvider(itemSoldReportCompiler, PeriodReportAdapter.DAILY);
        this.setReportProvider((ReportProvider)this.reportProvider);
    }

    @Override
    protected void init() {
        this.tradingDays = GlazedLists.eventList((Collection)TradingDay.getAllTradingDays());
        super.init();
    }

    @Override
    protected void onStart() {
        this.showCOGSCheckBox.setSelected(SystemProperty.getInstance().isStockControlEnabled());
    }

    @Override
    public JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory(){

            @Override
            protected JPanel getCustomReportControlPanel() {
                JPanel panel = new JPanel();
                ComboSearchField field = new ComboSearchField("Day", DailyItemSoldState.this.compiler.getSearcher().getTradingDayFilter(), false, DailyItemSoldState.this.getRefreshAction(), DailyItemSoldState.this.tradingDays);
                panel.add(field.getJLabelForComponent());
                panel.add(field.getGuiComponent());
                field.setSelectedObject((Object)TradingDay.getCurrentTradingDay());
                DailyItemSoldState.this.showCOGSCheckBox = new JCheckBox(DailyItemSoldState.this.getRefreshAction());
                DailyItemSoldState.this.showCOGSCheckBox.setText("Show COGS");
                panel.add(DailyItemSoldState.this.showCOGSCheckBox);
                return panel;
            }
        };
    }

    @Override
    public void refresh() {
        TradingDay day = (TradingDay)this.compiler.getSearcher().getTradingDayFilter().getSearchValue();
        String title = "Item sold report for : " + (day != null ? day.toString() : "No date set");
        try {
            this.reportProvider.getBuilder().setTitle(title);
        }
        catch (BuilderException ex) {
            OrderMate.LOG.error("Error setting report title", (Throwable)ex);
            return;
        }
        this.reportProvider.setShowCOGS(this.showCOGSCheckBox.isSelected());
        super.refresh();
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.tradingDays, TradingDay.getAllTradingDays());
    }

    public boolean getShowCOGS() {
        return this.showCOGSCheckBox.isSelected();
    }
}

