/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.jasper;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRFillInterruptedException;
import net.sf.jasperreports.engine.print.JRPrinterAWT;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.swing.JRViewerPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.screens.reports.jasper.JasperToolbarFactory;
import ordermate.OrderMate;
import ordermate.database.reports.maker.ConfigurableReportMaker;
import ordermate.database.users.Permission;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.reports.impl.ErrorReportProvider;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class JasperReportState
extends BasicOfficeMateState
implements JRViewerListener {
    public static final String NO_RESULTS_LABEL = "There are no results for the report criteria.";
    private final JRViewerController controller;
    private ReportProvider reportProvider;
    private ReportLoader reportLoader;
    private JPanel reportPanel = new JPanel(new BorderLayout());
    private JPanel emptyPanel = new JPanel();
    private final JasperToolbarFactory toolbarFactory;
    private JScrollPane viewerScrollPane;
    private static JFileChooser chooser = null;

    public static JFileChooser getChooser() {
        return chooser;
    }

    public JasperReportState(ReportProvider provider, String stateName, Permission permission, String description) {
        super(stateName, permission, description);
        this.emptyPanel.add(new JLabel(NO_RESULTS_LABEL));
        this.toolbarFactory = this.createJasperToolbarFactory();
        this.toggleDefaultAction(this.getRefreshAction(), false);
        this.controller = new JRViewerController(Locale.getDefault(), null);
        this.controller.addListener((JRViewerListener)this);
        this.reportProvider = provider;
        this.setScreenPanel(new JPanel(new BorderLayout()));
    }

    public void setReportProvider(ReportProvider provider) {
        this.reportProvider = provider;
        if (this.reportProvider != null) {
            this.toggleDefaultAction(this.getRefreshAction(), true);
            this.reportProvider.setBusy(true);
        } else {
            this.toggleDefaultAction(this.getRefreshAction(), false);
        }
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public void doPrintAction() {
        Dialogs.showProgressDialog(new AbstractTask(){

            public String getName() {
                return "Printing...";
            }

            protected int getTotalSubTasks() {
                return 0;
            }

            protected void performTask() throws Exception {
                try {
                    JasperPrint toPrint = JasperReportState.this.getJasperPrint();
                    JRPrinterAWT.printPages((JasperPrint)toPrint, (int)0, (int)(toPrint.getPages().size() - 1), (boolean)true);
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Failed to invoke print on jasper report!", (Throwable)e);
                }
            }
        });
    }

    public JasperPrint getJasperPrint() throws JRException {
        return this.reportProvider == null ? null : this.reportProvider.getReportPrint();
    }

    public final synchronized JRViewerController getController() {
        return this.controller;
    }

    protected JasperToolbarFactory createJasperToolbarFactory() {
        return new JasperToolbarFactory();
    }

    @Override
    protected void init() {
        if (this.isFirstRun()) {
            super.init();
            JRViewerPanel viewerPanel = new JRViewerPanel(this.controller);
            this.controller.setZoomRatio(0.75f);
            this.viewerScrollPane = this.getScrollPaneFromViewer((JPanel)viewerPanel);
            Signal csvSignal = Signals.createSignal();
            csvSignal.connect((Object)this, "gotCsv");
            this.getScreenPanel().add((Component)this.toolbarFactory.createToolbarPanel(this.controller, csvSignal), "North");
            this.getReportPanel().add((Component)viewerPanel, "Center");
            this.getReportPanel().setVisible(false);
            this.emptyPanel.setVisible(true);
            this.getScreenPanel().add((Component)this.getReportPanel(), "Center");
            this.getScreenPanel().add((Component)this.emptyPanel, "South");
        }
    }

    protected JasperToolbarFactory getToolbarFactory() {
        return this.toolbarFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotCsv() {
        try {
            chooser = new JFileChooser();
            chooser.setAcceptAllFileFilterUsed(false);
            FileNameExtensionFilter filter = new FileNameExtensionFilter("Excel Documents", "csv");
            chooser.addChoosableFileFilter(filter);
            int response = chooser.showSaveDialog(null);
            if (response == 0) {
                File file = chooser.getSelectedFile();
                String csv = ConfigurableReportMaker.createCsv((List)ConfigurableReportMaker.tabulateResults((ReportProvider)this.reportProvider, null));
                StringUtils.writeTextToFile((File)file, (String)csv);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot create sample", (Throwable)ex);
        }
        finally {
            chooser = null;
        }
    }

    private JPanel getReportPanel() {
        return this.reportPanel;
    }

    private JPanel getEmptyPanel() {
        return this.emptyPanel;
    }

    protected void setNoResultText(String text) {
        for (Component comp : this.getEmptyPanel().getComponents()) {
            if (!(comp instanceof JLabel)) continue;
            ((JLabel)comp).setText(text);
            break;
        }
    }

    @Override
    protected void onStart() {
        this.init();
        if (this.reportProvider != null && !this.reportProvider.isBusy()) {
            this.reportProvider.addParam("OM_USER", (Object)this.getUser());
            this.toggleDefaultAction(this.getRefreshAction(), true);
            this.reportProvider.setBusy(true);
        }
        this.toolbarFactory.refreshSearchOptions();
        super.onStart();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.displayReport();
    }

    public final void displayReport() {
        if (GuiApp.getAppComplex().getApplicationFrame().getFrame() == null) {
            return;
        }
        Dialog progressDialog = this.getProgressDialog();
        this.loadReportIntoController(progressDialog);
    }

    protected final ReportProvider getProvider() {
        return this.reportProvider;
    }

    private Dialog getProgressDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Was expecting EDT");
        }
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        JDialog dialog = new JDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Loading report");
        dialog.setSize(100, 50);
        dialog.setLocationRelativeTo(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        dialog.getContentPane().add(bar);
        dialog.pack();
        return dialog;
    }

    public void loadReportIntoController() {
        this.loadReportIntoController(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadReportIntoController(Dialog progressDialog) {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should only be called from EDT");
        }
        JasperReportState jasperReportState = this;
        synchronized (jasperReportState) {
            if (this.reportLoader != null && !this.reportLoader.isDone() && !this.reportLoader.isCancelled()) {
                ReportLoader newReportLoader = new ReportLoader(progressDialog, this.reportLoader);
                this.reportLoader.cancel(true);
                this.reportLoader = newReportLoader;
            } else {
                this.reportLoader = new ReportLoader(progressDialog, this.reportLoader);
            }
        }
        if (progressDialog != null) {
            progressDialog.setVisible(true);
        }
        this.reportLoader.execute();
    }

    private JScrollPane getScrollPaneFromViewer(JPanel viewerPanel) {
        for (Component comp : viewerPanel.getComponents()) {
            if (!(comp instanceof JScrollPane)) continue;
            return (JScrollPane)comp;
        }
        return null;
    }

    public void viewerEvent(JRViewerEvent event) {
        if (event.getCode() == 3 && this.viewerScrollPane != null) {
            this.viewerScrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    class ReportLoader
    extends SwingWorker<JasperPrint, Object> {
        private final Dialog progressDialog;
        private volatile JasperPrint print;
        private Thread activeThread;
        private ReportLoader oldReportLoader;

        protected ReportLoader(Dialog dialog, ReportLoader reportLoader) {
            this.progressDialog = dialog;
            this.oldReportLoader = reportLoader;
        }

        public void waitTillFinish() {
            try {
                if (this.activeThread != null && this.activeThread.isAlive() && !this.isDone()) {
                    try {
                        this.activeThread.join();
                    }
                    catch (InterruptedException ie) {
                        OrderMate.LOG.warn("JasperReportState#waitTillFinish - Active thread is interrupted.");
                    }
                }
            }
            finally {
                this.activeThread = null;
            }
        }

        @Override
        public JasperPrint doInBackground() {
            this.activeThread = Thread.currentThread();
            if (this.oldReportLoader != null) {
                this.oldReportLoader.waitTillFinish();
                this.oldReportLoader = null;
            }
            try {
                JasperPrint jasperPrint = JasperReportState.this.getJasperPrint();
                return jasperPrint;
            }
            catch (JRException ex) {
                if (!(ex.getCause() instanceof JRFillInterruptedException)) {
                    OrderMate.LOG.error("Could not load jasper report into state controller", (Throwable)ex);
                    JasperReportState.this.controller.loadReport(ErrorReportProvider.getJasperPrint());
                }
            }
            finally {
                this.activeThread = null;
                this.oldReportLoader = null;
            }
            return null;
        }

        private boolean hasPages() {
            if (this.print == null) {
                return false;
            }
            return this.print.getPages().size() > 0;
        }

        @Override
        protected void done() {
            try {
                this.print = (JasperPrint)this.get();
                if (this.print != null && this.hasPages()) {
                    JasperReportState.this.controller.loadReport(this.print);
                    JasperReportState.this.controller.setPageIndex(0);
                    JasperReportState.this.controller.fitWidth();
                    JasperReportState.this.controller.refreshPage();
                }
            }
            catch (ExecutionException ex) {
                OrderMate.LOG.error("Error in jasper reports swing worker", (Throwable)ex);
            }
            catch (InterruptedException ie) {
                OrderMate.LOG.error("Error in jasper reports swing worker", (Throwable)ie);
                return;
            }
            catch (CancellationException ce) {
                OrderMate.LOG.error("Error in jasper reports swing worker", (Throwable)ce);
                return;
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error in jasper reports swing worker", (Throwable)ex);
                return;
            }
            finally {
                JasperReportState.this.reportProvider.setBusy(false);
                this.cleanupProgressDialog();
            }
            boolean showReport = this.hasPages();
            JasperReportState.this.getReportPanel().setVisible(showReport);
            JasperReportState.this.getEmptyPanel().setVisible(!showReport);
            JasperReportState.this.getScreenPanel().doLayout();
            JasperReportState.this.getScreenPanel().invalidate();
        }

        private void cleanupProgressDialog() {
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
        }
    }
}

