/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.keycategories;

import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.SplitTableState;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.StaticTextColumnFormat;
import ordermate.database.finance.reports.TotalsReport;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.searchers.reports.CategoryReportSearcher;
import ordermate.database.users.Permission;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class KeyCategoriesSearchState
extends AbstractTableState<CategorySalesReport>
implements SearchGuiState<CategorySalesReport> {
    private final CategoryReportSearcher searcher = new CategoryReportSearcher();
    private final EventList<CategorySalesReport> categorySalesReports = new BasicEventList();
    private final EventList<TotalsReport> totalsReport = new BasicEventList(1);
    private final RefreshAction refreshAction = new RefreshAction((Refreshable)this);

    public KeyCategoriesSearchState(Permission permission) {
        super("Key Category Search", permission, "Search and display key category reports");
    }

    @Override
    protected TableStateCentralArea<CategorySalesReport> createCentralArea() {
        PersistentObjectTable<CategorySalesReport> table = new PersistentObjectTable<CategorySalesReport>(this.categorySalesReports, new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Category", CategorySalesReport.Properties.INVENTORY_CATEGORY_NAME), new PropertyColumnFormat(CategorySalesReport.Properties.QUANTITY_SOLD), new PropertyColumnFormat(CategorySalesReport.Properties.SALES_VALUE), new PropertyColumnFormat("% of Total Sales", (PropertiedObject.Property)CategorySalesReport.Properties.PERC_OF_SALES_STR)}));
        PersistentObjectTable<TotalsReport> totals = new PersistentObjectTable<TotalsReport>(this.totalsReport, new ColumnTableFormat(new ColumnFormat[]{new StaticTextColumnFormat("Totals", "Total:"), new PropertyColumnFormat("Total transactions", TotalsReport.Properties.COUNT), new PropertyColumnFormat("Total Sales inc.", TotalsReport.Properties.TOTAL), new PropertyColumnFormat("Total Sales ex.", (PropertiedObject.Property)TotalsReport.Properties.TOTAL_EX)}));
        SplitTableState<CategorySalesReport> splitState = SplitTableState.createVerticalSplit(totals, table);
        return splitState;
    }

    @Override
    public OfficeMateObjectSearch<CategorySalesReport> createSearchPanelFactory() {
        ObjectPropertySearch<CategorySalesReport> guiSearch = new ObjectPropertySearch<CategorySalesReport>(CategorySalesReport.class, (ObjectQuerySearcher)this.searcher, this.categorySalesReports){

            @Override
            public void doRefresh() {
                this.clearObjectList();
                ObjectQuerySearcher localSearcher = this.getPropertySearcher();
                this.copyIntoObjectList(localSearcher.search());
                KeyCategoriesSearchState.this.totalsReport.clear();
                KeyCategoriesSearchState.this.totalsReport.addAll((Collection)KeyCategoriesSearchState.this.searcher.getTotalSearcher().search());
            }
        };
        guiSearch.addSearchField((SearchGuiField)new DateRangeSearchField("Day", this.searcher.getTradingDayDateRangeFilter(), Calendar.getInstance().getTime(), (Action)this.refreshAction));
        return guiSearch;
    }

    @Override
    protected Class<CategorySalesReport> getDisplayingType() {
        return CategorySalesReport.class;
    }

    public CategoryReportSearcher getSearcher() {
        return this.searcher;
    }
}

