/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.kts;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.screens.reports.saleshistory.ComboDateRangeSearchField;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrintDeviceType;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.reports.kts.KTSReport;
import ordermate.database.searchers.reports.KTSReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class KTSReportSearchState
extends AbstractTableState<KTSReport>
implements SearchGuiState<KTSReport> {
    private final KTSReportSearcher searcher;
    private final EventList ktsList;
    private static final Format timeFormatter = new Format(){

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            int time = (Integer)obj / 1000;
            int minutes = time / 60;
            if (minutes < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(minutes);
            toAppendTo.append(":");
            int seconds = time % 60;
            if (seconds < 10) {
                toAppendTo.append("0");
            }
            toAppendTo.append(seconds);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    };

    public KTSReportSearchState(KTSReportSearcher rrSearcher) {
        super("Search", null, "Select Refunds to report on");
        List physPrinters = KTSDocketPrinter.getAllActivePrintDevices();
        ArrayList<PhysicalPrintDevice> onlyKTSPrinters = new ArrayList<PhysicalPrintDevice>();
        for (PhysicalPrintDevice ppd : physPrinters) {
            if (!ppd.getPrintDeviceType().equals((Object)PhysicalPrintDeviceType.ktsPrinter)) continue;
            onlyKTSPrinters.add(ppd);
        }
        this.ktsList = GlazedLists.eventList(onlyKTSPrinters);
        this.searcher = rrSearcher;
    }

    public KTSReportSearcher getSearcher() {
        return this.searcher;
    }

    @Override
    protected TableStateCentralArea<KTSReport> createCentralArea() {
        return new PersistentObjectTable<KTSReport>(this.getObjectList(), new ColumnTableFormat(new ColumnFormat[]{new PropertyColumnFormat("Date/Time", KTSReport.Properties.DATE_TIME), new PropertyColumnFormat("KTS Name", KTSReport.Properties.KTS_NAME), new PropertyColumnFormat("Account Number", (PropertiedObject.Property)KTSReport.Properties.ACCOUNT_NUMBER), new PropertyColumnFormat("Account Description", (PropertiedObject.Property)KTSReport.Properties.ACCOUNT_DESCRIPTION), new PropertyColumnFormat("Time", (PropertyAccessor)KTSReport.Properties.TIME, timeFormatter)}));
    }

    @Override
    protected Class<KTSReport> getDisplayingType() {
        return KTSReport.class;
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch<KTSReport> search = new ObjectPropertySearch<KTSReport>(KTSReport.class, (ObjectQuerySearcher<KTSReport>)this.getSearcher(), (EventList<KTSReport>)new BasicEventList());
        search.useSearchRefreshStrategy();
        RefreshAction refreshAction = new RefreshAction(search);
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter == null || periodAdapter == PeriodReportAdapter.DAILY) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Dates", this.searcher.getDateRangeFilter(), Calendar.getInstance().getTime(), (Action)refreshAction));
        } else {
            search.addSearchField(new ComboDateRangeSearchField((IRangedQuerySearchFilter<Date>)this.searcher.getDateRangeFilter(), periodAdapter, refreshAction));
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("KTS", (Action)refreshAction, this.ktsList, null, this.searcher.getKTSSearchFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField(new TimeRangeSearchField(this.getSearcher().getTimeFilter(), (Action)refreshAction));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return search;
    }
}

