/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.options;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.reports.sales.general.OptionSoldReport;
import ordermate.database.searchers.reports.sales.general.OptionSoldReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class OptionsReportSearchState
extends AbstractTableState<OptionSoldReport>
implements SearchGuiState<OptionSoldReport> {
    private final OptionSoldReportSearcher searcher;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private EventList<Date> dates;

    public OptionsReportSearchState(OptionSoldReportSearcher searcher) {
        super("Search", null, "Select Options to report on.");
        this.searcher = searcher;
    }

    @Override
    protected TableStateCentralArea<OptionSoldReport> createCentralArea() {
        return new PersistentObjectTable<OptionSoldReport>(this.getObjectList(), this.createColumnTableFormat());
    }

    protected ColumnTableFormat createColumnTableFormat() {
        ArrayList<ColumnFormat> cols = new ArrayList<ColumnFormat>();
        cols.add((ColumnFormat)new PropertyColumnFormat("Option Group", OptionSoldReport.Properties.OPTION_GROUP_NAME));
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            cols.add((ColumnFormat)new PropertyColumnFormat("Option ID", OptionSoldReport.Properties.OPTION_ID));
        }
        cols.addAll(Arrays.asList(new PropertyColumnFormat("Size", OptionSoldReport.Properties.OPTION_GROUP_SIZE), new PropertyColumnFormat("Option Name", OptionSoldReport.Properties.OPTION_NAME), new PropertyColumnFormat("Price", (PropertiedObject.Property)OptionSoldReport.Properties.AVERAGE_PRICE), new PropertyColumnFormat(OptionSoldReport.Properties.QUANTITY), new PropertyColumnFormat("Sales", OptionSoldReport.Properties.SALES_VALUE)));
        ColumnTableFormat format = new ColumnTableFormat(cols);
        return format;
    }

    @Override
    protected Class<OptionSoldReport> getDisplayingType() {
        return OptionSoldReport.class;
    }

    @Override
    public ObjectQuerySearcher<OptionSoldReport> getSearcher() {
        return this.searcher;
    }

    @Override
    public void refresh() {
        super.refresh();
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter != null) {
            GlazedListUtils.setAsList(this.dates, new ArrayList(periodAdapter.getDateList()));
        }
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch<OptionSoldReport> search = new ObjectPropertySearch<OptionSoldReport>(OptionSoldReport.class, this.getSearcher(), (EventList<OptionSoldReport>)new BasicEventList());
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        search.useSearchRefreshStrategy();
        if (periodAdapter == null) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        } else {
            this.dates = GlazedLists.eventList((Collection)periodAdapter.getDateList());
            FixedRangeSearchFilter searchProp = this.searcher.getFixedRangeFilter();
            searchProp.setOffsetFunction((OffsetFunction)periodAdapter.getDateOffset());
            this.searcher.addSearchFilter((SearchFilterI)searchProp);
            search.addSearchField((SearchGuiField)new ComboSearchField(periodAdapter.getLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)this.refreshAction, this.dates, (Format)periodAdapter.getFormatter()));
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Option Group", (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryOptionGroup.getOptionGroups()), null, this.searcher.getOptionGroupFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Size", (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryItemSize.getAllSizes()), null, this.searcher.getSizeFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new StringSearchField("Name", (ISingleValueSearchFilter)this.searcher.getTextFilter(), (Action)this.refreshAction));
        search.addSearchField(new TimeRangeSearchField(this.searcher.getTimeFilter(), (Action)this.refreshAction));
        return search;
    }
}

