/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.periodstock;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.Stringifier;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.print.Printing;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.table.LinkedTotalTable;
import officemate.adminkit.table.ShadeAlternateRowsTableCellRenderer;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.reports.periodstock.PeriodStockTableModel;
import ordermate.database.stock.StockTake;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import org.jdesktop.swingx.JXTable;

public class PeriodStockReportState
extends BasicOfficeMateState {
    private JPanel innerPanel;
    private JPanel northEastPanel;
    private JPanel northPanel;
    private JPanel tablePanel;
    private JPanel eastPanel;
    private JButton nextPeriodButton;
    private JButton lastPeriodButton;
    private JButton currentPeriodButton;
    private JXTable table = null;
    private JComboBox startStockTakeCombo;
    private JComboBox endStockTakeCombo;
    private PeriodStockAreaReport report = new PeriodStockAreaReport(null, null);
    private PeriodStockTableModel tableModel;
    private LinkedTotalTable totalsTable;
    private JButton goButton;
    private boolean alreadySetup = false;
    private boolean updatesAllowed = true;

    public PeriodStockReportState() {
        super("Period Stock", AllPermissions.ACCESS_PERIOD_STOCK_REPORT, "Show costs and profit between stocktakes");
        this.innerPanel = new JPanel(new BorderLayout());
        this.setScreenPanel(this.innerPanel);
    }

    @Override
    protected void onStart() {
        GuiApp.getAppComplex().getApplicationFrame().setStatusBarText("Loading Period Stock Report screen...");
        Vector stockTakes = StockTake.getSavedStockTakes();
        if (stockTakes.isEmpty()) {
            JOptionPane.showMessageDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame(), "At least one stock take must be saved \nbefore the Period Stock Report can be viewed.", "Can't create report", 2);
        } else if (!this.alreadySetup) {
            this.setupGUI();
            this.setupStockTakeCombo();
            PeriodStockAreaReport report = new PeriodStockAreaReport(this.getStartStockTake(), this.getEndStockTake());
            this.setupTable(report);
            this.setupTotalsPanel(report);
            this.setupButtons();
            this.alreadySetup = true;
        } else {
            this.refreshStocktakeCombos();
        }
        GuiApp.getAppComplex().getApplicationFrame().resetStatusBarText();
    }

    @Override
    public boolean supportsRefresh() {
        return true;
    }

    @Override
    public boolean supportsPrint() {
        return true;
    }

    @Override
    public void doRefreshAction() {
        this.refresh();
    }

    @Override
    public synchronized void refresh() {
        if (this.updatesAllowed) {
            this.updatesAllowed = false;
            this.refreshStocktakeCombos();
            this.applyStockTakes(this.getStartStockTake(), this.getEndStockTake());
            this.updatesAllowed = true;
        }
    }

    private void refreshStocktakeCombos() {
        Object[] savedStockTakes = StockTake.getSavedStockTakes().toArray();
        Object existingStartValue = this.startStockTakeCombo.getSelectedItem();
        this.startStockTakeCombo.setModel(new DefaultComboBoxModel<Object>(savedStockTakes));
        this.startStockTakeCombo.setSelectedItem(existingStartValue);
        Object existingEndValue = this.endStockTakeCombo.getSelectedItem();
        this.endStockTakeCombo.setModel(new DefaultComboBoxModel<Object>(savedStockTakes));
        this.endStockTakeCombo.insertItemAt("(NOW)", 0);
        this.endStockTakeCombo.setSelectedItem(existingEndValue);
    }

    private void setupGUI() {
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel = new JPanel(new BorderLayout());
        this.northEastPanel = new JPanel(new GridLayout(1, 0, 5, 5));
        this.tablePanel = new JPanel(new BorderLayout());
        JPanel addRemoveWrapper = new JPanel(new BorderLayout());
        this.eastPanel.add((Component)this.tablePanel, "Center");
        this.eastPanel.add((Component)addRemoveWrapper, "East");
        this.innerPanel.add((Component)this.eastPanel, "Center");
        this.innerPanel.add((Component)this.northPanel, "North");
    }

    private void setupButtons() {
        this.goButton = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
        this.goButton.setToolTipText("Go");
        this.goButton.setPreferredSize(new Dimension(56, 40));
        this.nextPeriodButton = new JButton(IconLoader.get((String)"/ordermate/images/1rightarrow.png"));
        this.lastPeriodButton = new JButton(IconLoader.get((String)"/ordermate/images/1leftarrow.png"));
        this.currentPeriodButton = new JButton(IconLoader.get((String)"/ordermate/images/today.png"));
        this.goButton.setToolTipText("Show for the selected dates");
        this.nextPeriodButton.setToolTipText("Next period");
        this.lastPeriodButton.setToolTipText("Previous period");
        this.currentPeriodButton.setToolTipText("Current period");
        PeriodButtonListener al = new PeriodButtonListener();
        this.goButton.addActionListener(al);
        this.nextPeriodButton.addActionListener(al);
        this.lastPeriodButton.addActionListener(al);
        this.currentPeriodButton.addActionListener(al);
        this.northEastPanel.add(this.lastPeriodButton);
        this.northEastPanel.add(this.nextPeriodButton);
        this.northEastPanel.add(this.currentPeriodButton);
        this.northEastPanel.add(this.goButton);
        this.northEastPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        JPanel northEastWrapper = new JPanel(new BorderLayout());
        northEastWrapper.add((Component)this.northEastPanel, "West");
        this.northPanel.add((Component)northEastWrapper, "Center");
    }

    public void enableButtons(boolean enable) {
        this.nextPeriodButton.setEnabled(enable);
        this.lastPeriodButton.setEnabled(enable);
        this.currentPeriodButton.setEnabled(enable);
        this.goButton.setEnabled(enable);
        this.startStockTakeCombo.setEnabled(enable);
        this.endStockTakeCombo.setEnabled(enable);
        this.toggleDefaultAction(this.getRefreshAction(), enable);
        this.toggleDefaultAction(this.getPrintAction(), enable);
    }

    private void setupStockTakeCombo() {
        Vector stockTakes = StockTake.getSavedStockTakes();
        this.startStockTakeCombo = new JComboBox(stockTakes);
        this.startStockTakeCombo.setName("Period Start");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.startStockTakeCombo);
        stockTakes = StockTake.getSavedStockTakes();
        this.endStockTakeCombo = new JComboBox(stockTakes);
        this.endStockTakeCombo.setName("Period End");
        OfficeMateAdminGuiUtils.getInstance().standardComboSetup(this.endStockTakeCombo);
        this.endStockTakeCombo.insertItemAt("(NOW)", 0);
        FieldPanelBuilder builder = new FieldPanelBuilder(0, 3);
        builder.addRow("Period Start:", (Component)this.startStockTakeCombo);
        builder.addRow("Period End:", (Component)this.endStockTakeCombo);
        this.northPanel.add((Component)builder.getPanel(), "West");
        this.updatesAllowed = false;
        this.startStockTakeCombo.setSelectedIndex(0);
        this.endStockTakeCombo.setSelectedIndex(0);
        this.updatesAllowed = true;
    }

    private PeriodStockTableModel createTableModel(PeriodStockAreaReport report) {
        return new PeriodStockTableModel(report);
    }

    private void setupTable(PeriodStockAreaReport report) {
        this.table = new JXTable(){

            public boolean isCellEditable(int r, int c) {
                return false;
            }
        };
        this.tableModel = this.createTableModel(report);
        this.table.setModel((TableModel)this.tableModel);
        OfficeMateAdminGuiUtils.getInstance().standardTableSetup((JTable)this.table);
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new ShadeAlternateRowsTableCellRenderer());
        ShadeAlternateRowsTableCellRenderer percRenderer = new ShadeAlternateRowsTableCellRenderer();
        percRenderer.setStringifier((Stringifier)new FormatStringifier((Format)NumberFormat.getPercentInstance(), Double.class));
        this.table.getColumn(9).setCellRenderer(percRenderer);
        this.table.getColumn(8).setCellRenderer(percRenderer);
        JScrollPane scroller = new JScrollPane((Component)this.table, 20, 31);
        this.tablePanel.add((Component)scroller, "Center");
    }

    private void setupTotalsPanel(PeriodStockAreaReport report) {
        JLabel totalsLabel = new JLabel("Total:");
        TableColumnModel columnModel = this.table.getColumnModel();
        this.totalsTable = new LinkedTotalTable(columnModel);
        this.totalsTable.setName("Total table");
        this.refreshTotalValues();
        JPanel totalsPanel = new JPanel(new GridLayout(0, 1));
        totalsPanel.add(totalsLabel);
        totalsPanel.add(this.totalsTable);
        this.tablePanel.add((Component)totalsPanel, "South");
    }

    private void refreshTotalValues() {
        this.totalsTable.setColumnValues(this.tableModel.getTotals());
    }

    private synchronized void applyStockTakes(StockTake start, StockTake end) {
        this.report.setPeriod(start, end);
        this.tableModel = this.createTableModel(this.report);
        this.refreshTotalValues();
        this.table.setModel((TableModel)this.tableModel);
        this.table.revalidate();
        this.table.repaint();
        this.totalsTable.revalidate();
        this.totalsTable.repaint();
    }

    PeriodStockAreaReport getReport() {
        return this.report;
    }

    @Override
    public void doPrintAction() {
        StockTake stockTakeStart = this.getStartStockTake();
        StockTake stockTakeEnd = this.getEndStockTake();
        String endString = stockTakeEnd != null ? stockTakeEnd.getLabel() : "NOW";
        String title = "Period Stock (" + stockTakeStart + " - " + endString + ")";
        Printing.printJTableReport((JTable)this.table, title, "", 8, this.totalsTable.getColumnValues());
    }

    private StockTake getStartStockTake() {
        Object o = this.startStockTakeCombo.getSelectedItem();
        return o instanceof StockTake ? (StockTake)o : null;
    }

    private StockTake getEndStockTake() {
        Object o = this.endStockTakeCombo.getSelectedItem();
        return o instanceof StockTake ? (StockTake)o : null;
    }

    private class PeriodButtonListener
    implements ActionListener {
        private PeriodButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (src == PeriodStockReportState.this.nextPeriodButton) {
                int currentStartIndex = PeriodStockReportState.this.startStockTakeCombo.getSelectedIndex();
                int currentEndIndex = PeriodStockReportState.this.endStockTakeCombo.getSelectedIndex();
                if (currentStartIndex > 0 && currentEndIndex > 0) {
                    PeriodStockReportState.this.updatesAllowed = false;
                    PeriodStockReportState.this.startStockTakeCombo.setSelectedIndex(currentStartIndex - 1);
                    PeriodStockReportState.this.endStockTakeCombo.setSelectedIndex(currentEndIndex - 1);
                    PeriodStockReportState.this.updatesAllowed = true;
                }
            } else if (src == PeriodStockReportState.this.lastPeriodButton) {
                int currentStartIndex = PeriodStockReportState.this.startStockTakeCombo.getSelectedIndex();
                int currentEndIndex = PeriodStockReportState.this.endStockTakeCombo.getSelectedIndex();
                int startSize = PeriodStockReportState.this.startStockTakeCombo.getModel().getSize();
                int endSize = PeriodStockReportState.this.endStockTakeCombo.getModel().getSize();
                if (currentStartIndex < startSize - 1 && currentEndIndex < endSize - 1) {
                    PeriodStockReportState.this.updatesAllowed = false;
                    PeriodStockReportState.this.startStockTakeCombo.setSelectedIndex(currentStartIndex + 1);
                    PeriodStockReportState.this.endStockTakeCombo.setSelectedIndex(currentEndIndex + 1);
                    PeriodStockReportState.this.updatesAllowed = true;
                }
            } else if (src == PeriodStockReportState.this.currentPeriodButton) {
                PeriodStockReportState.this.updatesAllowed = false;
                PeriodStockReportState.this.refreshStocktakeCombos();
                PeriodStockReportState.this.startStockTakeCombo.setSelectedIndex(0);
                PeriodStockReportState.this.endStockTakeCombo.setSelectedIndex(0);
                PeriodStockReportState.this.updatesAllowed = true;
            } else if (src == PeriodStockReportState.this.goButton) {
                PeriodStockReportState.this.enableButtons(false);
                PeriodStockReportState.this.refresh();
                PeriodStockReportState.this.innerPanel.revalidate();
                PeriodStockReportState.this.innerPanel.repaint();
                PeriodStockReportState.this.enableButtons(true);
            }
        }
    }
}

