/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.pluses;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.FixedRangeSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import au.com.ordermate.search.searchfield.java.StringSearchField;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.OffsetFunction;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.swing.Action;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.search.searchfield.TimeRangeSearchField;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.ExperimentalFeatureHelper;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.misc.ConfigShift;
import ordermate.database.reports.sales.general.PlusesSoldReport;
import ordermate.database.searchers.reports.sales.general.PlusesSoldReportSearcher;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PlusesReportSearchState
extends AbstractTableState<PlusesSoldReport>
implements SearchGuiState<PlusesSoldReport> {
    private final PlusesSoldReportSearcher searcher;
    private RefreshAction refreshAction = new RefreshAction((Refreshable)this);
    private EventList<Date> dates;

    public PlusesReportSearchState(PlusesSoldReportSearcher searcher) {
        super("Search", null, "Select Pluses to report on");
        this.searcher = searcher;
    }

    @Override
    protected TableStateCentralArea<PlusesSoldReport> createCentralArea() {
        ColumnTableFormat format = new ColumnTableFormat();
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Plus Group", PlusesSoldReport.Properties.PLUS_GROUP_NAME));
        if (ExperimentalFeatureHelper.isShowItemIds()) {
            format.addColumn((ColumnFormat)new PropertyColumnFormat("Plus ID", PlusesSoldReport.Properties.PLUS_ID));
        }
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Size", PlusesSoldReport.Properties.PLUS_GROUP_SIZE));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Plus Name", PlusesSoldReport.Properties.PLUS_NAME));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Price", (PropertiedObject.Property)PlusesSoldReport.Properties.AVERAGE_PRICE));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Quantity", PlusesSoldReport.Properties.QUANTITY));
        format.addColumn((ColumnFormat)new PropertyColumnFormat("Sales", PlusesSoldReport.Properties.TOTAL_PRICE));
        return new PersistentObjectTable<PlusesSoldReport>(this.getObjectList(), format);
    }

    @Override
    protected Class<PlusesSoldReport> getDisplayingType() {
        return PlusesSoldReport.class;
    }

    @Override
    public ObjectQuerySearcher<PlusesSoldReport> getSearcher() {
        return this.searcher;
    }

    @Override
    public void refresh() {
        super.refresh();
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter != null) {
            GlazedListUtils.setAsList(this.dates, new ArrayList(periodAdapter.getDateList()));
        }
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch<PlusesSoldReport> search = new ObjectPropertySearch<PlusesSoldReport>(PlusesSoldReport.class, this.getSearcher(), (EventList<PlusesSoldReport>)new BasicEventList());
        PeriodReportAdapter periodAdapter = this.searcher.getPeriod();
        if (periodAdapter == null) {
            search.addSearchField((SearchGuiField)new DateRangeSearchField("Date", this.searcher.getTradingDayDateRangeFilter(), DateTimeUtils.getOneMonthAgoCal().getTime(), (Action)this.refreshAction));
        } else {
            this.dates = GlazedLists.eventList((Collection)periodAdapter.getDateList());
            FixedRangeSearchFilter searchProp = this.searcher.getFixedRangeFilter();
            searchProp.setOffsetFunction((OffsetFunction)periodAdapter.getDateOffset());
            this.searcher.addSearchFilter((SearchFilterI)searchProp);
            search.addSearchField((SearchGuiField)new ComboSearchField(periodAdapter.getLabel(), (ISingleValueSearchFilter)searchProp, false, (Action)this.refreshAction, this.dates, (Format)periodAdapter.getFormatter()));
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Plus Group", (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryAddGroup.getAllAddGroups()), null, this.searcher.getAddGroupFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Size", (Action)this.refreshAction, GlazedLists.eventList((Collection)InventoryItemSize.getAllSizes()), null, this.searcher.getSizeFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new StringSearchField("Name", (ISingleValueSearchFilter)this.searcher.getTextFilter(), (Action)this.refreshAction));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", (Action)this.refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations()), null, this.searcher.getSalesLocationFilter()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (Action)this.refreshAction, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShifts()), null, this.searcher.getShiftFilter()));
        search.addSearchField(new TimeRangeSearchField(this.searcher.getTimeSearchFilter(), (Action)this.refreshAction));
        return search;
    }
}

