/*
 * Decompiled with CFR 0.152.
 */
package officemate.screens.reports.productivity;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.oquery.search.ObjectQuerySearcher;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.SearchFilterI;
import au.com.ordermate.search.control.RefreshAction;
import au.com.ordermate.search.searchfield.java.ComboSearchField;
import au.com.ordermate.search.searchfield.java.DateRangeSearchField;
import au.com.ordermate.search.searchfield.java.MultiSelectComboSearchField;
import au.com.ordermate.search.searchfield.java.SearchGuiField;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import officemate.adminkit.state.SearchGuiState;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.renderers.DynamicListCellRenderer;
import officemate.components.search.ObjectPropertySearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.ConfigShift;
import ordermate.database.queries.users.UserQueries;
import ordermate.database.reports.productivity.ProductivityReport;
import ordermate.database.searchers.reports.productivity.ProductivityReportSearcher;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import ordermate.gui.themes.OrderMateTheme;
import ordermate.internationalization.Internationalization;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ProductivityReportSearchState
extends AbstractTableState<ProductivityReport>
implements SearchGuiState<ProductivityReport> {
    ProductivityReportSearcher searcher = new ProductivityReportSearcher();
    private static final EventList usersList = GlazedLists.eventList((Collection)UserQueries.getAllUsersIncDeleted());
    private final EventList groupList = GlazedLists.eventList((Collection)PermissionGroup.getPermissionGroups());
    public static final String userType_Order = "User who Ordered Items";
    public static final String userType_Open = "User Who Opened Table";
    private ComboSearchField userTypeCombo;

    public ProductivityReportSearchState(String stateName, Permission permission, String stateDesc) {
        super(stateName, permission, stateDesc);
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        EventList objectList = this.getObjectList();
        PersistentObjectTable centralTable = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat((ColumnFormat[])new PropertyColumnFormat[]{new PropertyColumnFormat("Trading Day", ProductivityReport.Properties.TRADING_DAY), new PropertyColumnFormat("User", ProductivityReport.Properties.USER), new PropertyColumnFormat("Total Sales", ProductivityReport.Properties.SALES_TOTAL), new PropertyColumnFormat("Total " + Internationalization.getLiteralFor((String)"COVERS"), ProductivityReport.Properties.PATRON_TOTAL), new PropertyColumnFormat("Sales Per " + Internationalization.getLiteralFor((String)"COVER"), (PropertiedObject.Property)ProductivityReport.Properties.SALES_PER_PATRON)}));
        centralTable.groupOn("Trading Day", null);
        return centralTable;
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        ObjectPropertySearch<ProductivityReport> search = new ObjectPropertySearch<ProductivityReport>(ProductivityReport.class, this.getSearcher(), (EventList<ProductivityReport>)new BasicEventList());
        search.useSearchRefreshStrategy();
        RefreshAction refreshAction = new RefreshAction(search);
        search.addSearchField((SearchGuiField)new DateRangeSearchField("Date Range", this.searcher.getTradingDayDateRangeFilter(), Calendar.getInstance().getTime(), (Action)refreshAction));
        MultiSelectComboSearchField userField = new MultiSelectComboSearchField("User", (Action)refreshAction, usersList, null, this.searcher.getUserSearchFilter(), new JCheckBoxCellRenderer());
        userField.setRenderer((ListCellRenderer)new DynamicListCellRenderer<User>(){

            @Override
            protected void extraRenderStep(User value, DefaultListCellRenderer renderer) {
                if (value.getSystemState().equals("DELETED")) {
                    renderer.setForeground(OrderMateTheme.ORDERMATE_RED);
                }
            }
        });
        search.addSearchField((SearchGuiField)userField);
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("User Groups", (Action)refreshAction, this.groupList, null, this.searcher.getGroupSearchFilter(), new JCheckBoxCellRenderer()));
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Shift", (Action)refreshAction, GlazedLists.eventList((Collection)ConfigShift.getAllConfigShiftsNames()), null, (MultiOptionSearchFilter)this.searcher.getShiftSearchFilter(), new JCheckBoxCellRenderer()));
        search.getRefreshStrategy().setShowProgressDialog(true);
        this.userTypeCombo = new UserTypeSearchField(this.searcher.getUserTypeSearchFilter(), (Action)refreshAction, this.searcher);
        search.addSearchField((SearchGuiField)this.userTypeCombo);
        if (this.searcher.isUserPerformanceBasedOffOpeningUser()) {
            this.userTypeCombo.setSelectedObject((Object)"User who opened the table");
        } else {
            this.userTypeCombo.setSelectedObject((Object)"User who ordered the first item");
        }
        search.addSearchField((SearchGuiField)new MultiSelectComboSearchField("Sales Location", this.searcher.getSalesLocationFilter(), (Action)refreshAction, GlazedLists.eventList((Collection)SalesLocation.getSalesLocations())));
        return search;
    }

    @Override
    protected Class getDisplayingType() {
        return ProductivityReport.class;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public ObjectQuerySearcher<ProductivityReport> getSearcher() {
        return this.searcher;
    }

    private static class UserTypeSearchField
    extends ComboSearchField {
        private ISingleValueSearchFilter searchProperty;
        private ProductivityReportSearcher searcher;

        public UserTypeSearchField(ISingleValueSearchFilter searchProperty, Action refreshAction, ProductivityReportSearcher searcher) {
            String[] stringArray = new String[2];
            stringArray[0] = "User who opened the table";
            stringArray[1] = "User who ordered the first item";
            super("User Type:", searchProperty, false, refreshAction, GlazedLists.eventList(Arrays.asList(stringArray)));
            this.searchProperty = searchProperty;
            this.searcher = searcher;
        }

        public SearchFilterI getSearchProperty() {
            Object value = this.getComboBox().getSelectedItem();
            this.searchProperty.clearSearch();
            if (value != null && !value.toString().equals("Any")) {
                this.searchProperty.setSearchValue(value);
                this.searcher.setUserTypeFilter(value.toString());
            }
            return this.searchProperty;
        }
    }
}

